angular.module('salestool-login', [
    'ngAnimate',
    'ngRoute',
    'ngAnimate-animate.css',
    'ngFx',
    'stServices',
    'datatables',
    'ngResource',
    'mgcrea.ngStrap',
    'cgBusy',
    'ngBootbox',
    'flow',
    'ui.utils',
    'inform',
    //'ngNotificationsBar',
    'ngSanitize',
    'daterangepicker',
    'ui.select',
    'angular-storage',
])

// Http intereceptor for errors
.factory("appHttpInterceptor", ["$q", "inform", function ($q, inform) {
    return {
        'response': function(response) {
            return response || $q.when(response);
        },
        'responseError': function(response) {
            var msg = response.data.message ? response.data.message : response.statusText;
            switch (response.status) {
                case 401:
                    inform.add("Ocorreu um erro ao executar a solicitação: " + msg, {type:"danger"});
                    break;
                case 403:
                    inform.add("Ocorreu um erro ao executar a solicitação: " + msg, {type:"danger"});
                    break;
                case 500:
                    inform.add("Ocorreu um erro ao executar a solicitação: " + msg, {type:"danger"});
                    break;
                default:
                    inform.add("Ocorreu um erro ao executar a solicitação: " + msg, {type:"danger"});
            }

            return $q.reject(response);
        }
    };
}])

.config(["$interpolateProvider", "$httpProvider", "$resourceProvider", "$routeProvider",function($interpolateProvider, $httpProvider, $resourceProvider, $routeProvider){
    $httpProvider.interceptors.push('appHttpInterceptor');
    var defaultTransition = {
        enter: 'slide-in-left-fade',
        leave: 'slide-out-right-fade',
        ease: 'sine',
        speed: 400
    };
}])

.factory('DTLoadingTemplate', function() {
    return {
        html: '<div align="center"><img src="'+_baseUrl+'/img/ring.gif"></div>'
    };
})

.value('cgBusyDefaults',{
    message:'Por favor, aguarde...',
    templateUrl: 'loading.tpl.html',
    backdrop: true
})

.run(["DTDefaultOptions", "$ngBootbox", "$rootScope", function(DTDefaultOptions, $ngBootbox, $rootScope){
    $ngBootbox.setDefaults({
        locale: "pt"
    });
    $rootScope.isRouteLoading = false;
}])

/**
 * Login Controller
 */
.controller('LoginCtrl', ["$scope", "$http", function($scope, $http){

    $scope.error = false;
    $scope.sending = false;
    $scope.statusMessage = '';
    $scope.data = {};
    $scope.submit = function(form){

        $scope.submitted = true;
        if (form.$invalid) {
            return false;
        }

        $scope.statusMessage = 'Autenticando...';
        $scope.sending = true;

        var url = _baseUrl + '/login/auth';

        $http({
            method: 'post',
            url: url,
            data: $.param($scope.data),
            headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
        }).success(function (data, status, headers, config) {

            console.log(data);
            if(!data.success){
                $scope.sending = false;
                $scope.error = data.message;
                return;
            }

            // Redirect to home
            $scope.statusMessage = 'Redirecionando...';
            window.location.href = _baseUrl;

        }).error(function (data, status, headers, config) {
            console.log(data);
            $scope.sending = false;
            $scope.error = 'Erro ao autenticador usuário. Status: ' + status;
        });

    };

}]);