/**
 * Warehouse Manager Controller
 */
angular.module('salestool').controller('WarehouseManagerCtrl',
    ["$scope", "$http", "$urlService", "$resource", "DTOptionsBuilder", "DTColumnBuilder", "DTColumnDefBuilder", "DTInstances", "$modal", "$resource", "store", "$filter", "inform", "StringUtils",
    function($scope, $http, $urlService, $resource, DTOptionsBuilder, DTColumnBuilder, DTColumnDefBuilder, DTInstances, $modal, $resource, store, $filter, inform, StringUtils){

    // Rest Entity
    var ProductWarehouse = $resource($urlService.rest('/product-warehouse/:id'));

    DTInstances.getLast().then(function (dtInstance) {
        $scope.dataTable = dtInstance;
        //dtInstance.rerender();
        //dtInstance.reloadData();
    });

    var FilterAmountEnum = {
        TODOS: 'all',
        COM_ESTOQUE: 'stock',
        SEM_ESTOQUE: 'nostock'
    }

    // Params
    $scope.params = {
        filterAmount: FilterAmountEnum.TODOS
    }

    $scope.$watch('params.filterAmount', function(val) {
        if(val && $scope.params.warehouse){
            $scope.loadList();
        }
    }, false);

    $scope.$watch('params.warehouse', function(val) {
        if(!val){
            $scope.list = [];
        }else{
            $scope.loadList();
        }
    }, false);

    // Promises
    $scope.promiseList;

    // Datatable
    $scope.dtOptions = DTOptionsBuilder.newOptions()
        .withPaginationType('full_numbers')
        .withOption('order', [[0, 'asc']])
        .withOption('processing', true);

    $scope.dtColumnDefs = [
        DTColumnDefBuilder.newColumnDef(0),
        DTColumnDefBuilder.newColumnDef(1),
        DTColumnDefBuilder.newColumnDef(2),
        DTColumnDefBuilder.newColumnDef(3)
    ];

    /**
     * Load datatable list
     */
    $scope.loadList = function(){

        var qParams = {
            warehouse: $scope.params.warehouse,
            filter: $scope.params.filterAmount
        }

        // Get data
        $scope.loadingList = true;
        $scope.promiseList = ProductWarehouse.query(qParams, function(data){

            $scope.loadingList = false;
            $scope.list = data;

        }, function(err){

            $scope.loadingList = false;
            console.log(err);

        }).$promise;

    }

    /**
     * Update stock
     * @param obj
     * @param amount
     * @returns {*}
     */
    $scope.updateStock = function(obj, amount){

        if(!StringUtils.isNumber(amount)){
            return "Valor inválido";
        }

        amount = parseFloat(amount);
        if(!angular.isNumber(amount)){
            return "Valor inválido";
        }

        obj.amount = amount;
        return $scope.promiseList = obj.$save(function(data){

            //var msg = err.data.message ? err.data.message : err.statusText;
            //inform.add("Ocorreu um erro ao atualizar o estoque: " + msg, {type:"danger"});
            console.log(data);

        }, function(err){
            var msg = err.data.message ? err.data.message : err.statusText;
            return "Ocorreu um erro ao atualizar o estoque: " + msg;
        });

    }

    /**
     * Filter list
     * @deprecated
     * @param v
     * @param k
     * @returns {boolean}
     */
    $scope.fnFilterList = function(v,k){

        var currentFilter = $scope.params.filterAmount;
        if(currentFilter == FilterAmountEnum.COM_ESTOQUE){
            if(v.amount > 0){
                return true;
            }
        }else if(currentFilter == FilterAmountEnum.SEM_ESTOQUE){
            if(v.amount <= 0){
                return true;
            }
        }else if(currentFilter == FilterAmountEnum.TODOS){
            return true;
        }

        return false;

    }

    $scope.$urlService = $urlService;

}]);