/**
 * User Controller
 */

angular.module('salestool')
.controller('UserCtrl', ["$scope", "$http", "$urlService", "$resource", "DTOptionsBuilder", "DTColumnBuilder", "DTColumnDefBuilder", "$modal", "inform", "uiGmapGoogleMapApi", "uiGmapIsReady", "$filter",
function($scope, $http, $urlService, $resource, DTOptionsBuilder, DTColumnBuilder, DTColumnDefBuilder, $modal, inform, uiGmapGoogleMapApi, uiGmapIsReady, $filter){

    // Entities
    var Device                  = $resource($urlService.rest('/device/:id'));
    var User                    = $resource($urlService.rest('/user/:id'));
    var UserLocation            = $resource($urlService.rest('/user-location/:id'));
    var Warehouse               = $resource($urlService.rest('/warehouse/:id'));
    var RepresentedCompany      = $resource($urlService.rest('/represented-company/:id'));
    var UserRepresentedCompany  = $resource($urlService.rest('/user-represented-company/:id'));

    // Attributes
    $scope.passwords = {};
    $scope.tableState;
    $scope.promiseList;
    $scope.promiseForm;
    $scope.promiseLocations;
    $scope.params = { limit: 10 };
    $scope.dateRange = {
        range: { startDate: moment().startOf('day').toDate(), endDate: moment().endOf('day').toDate() }
    };

    $scope.representedCompanies = RepresentedCompany.query();

    /**
     * Modal form setup
     */
    var modalForm = $modal({
        animation:"am-slide-top",
        title:"Usuário",
        scope: $scope,
        template:'modal-entity-form.html',
        show:false
    });

    /**
     * Update password modal setup
     */
    var modalUpdatePasswordForm = $modal({
        animation:"am-slide-top",
        title:"Alterar Senha",
        scope: $scope,
        template:'modal-update-password-form.html',
        show:false
    });

    /**
     * Modal map setup
     */
    $scope.modalMap = $modal({
        //animation:"am-fade-and-slide-top",
        animation:"am-slide-top",
        title:"Localização",
        scope: $scope,
        template:'modal-map.html',
        show:false
    });

    /**
     * Show Modal
     * @param entityID
     */
    $scope.showModalForm = function(obj) {

        if(obj != undefined){


            $scope.promiseForm = $scope.userRepresentedCompanies = UserRepresentedCompany.query({user: obj.id}, function(data){

                $scope.userRepresentedCompanies = data;

                for(var i = 0, len = $scope.representedCompanies.length; i < len; i++){
                    var hasRep = false;
                    var rep = $scope.representedCompanies[i];
                    for(var j = 0, lenReps = $scope.userRepresentedCompanies.length; j < lenReps; j++){
                        var uRep = $scope.userRepresentedCompanies[j];
                        if(uRep.representedCompany.id == rep.id){
                            rep.selected = true;
                            rep.commission = uRep.commission;
                            hasRep = true;
                            //break;
                        }
                    }
                    if(!hasRep){
                        rep.selected = false;
                        rep.commission = null;
                    }
                }

            }).$promise;

            $scope.editing = true;
            $scope.entity = new User(obj);
            modalForm.show();

        }else{

            $scope.editing = false;
            $scope.entity = new User();
            modalForm.show();

        }

    };

    /**
     * Show Modal
     * @param entityID
     */
    $scope.showModalUpdatePasswordForm = function(obj) {

        $scope.entity = new User(obj);
        delete $scope.entity.password;
        modalUpdatePasswordForm.show();

    };

    //----------------------------------------MAP--------------------------------------//
        /**
         * Show modal map
         * @param obj
         */
        $scope.showModalMap = function(obj){
            console.log('showModalMap');
            console.log(window);  
            if(!obj){
                inform.add("Por favor, selecione um usuário.", {type:"danger"});
                return;
            }

            //$scope.entity = obj;
            GLOBAL_USER_ENTITY = obj;
            $scope.modalMap.show();
        };
    //----------------------------------------MAP--------------------------------------//

    /**
     * Delete entity
     * @param id
     */
    $scope.delete = function(obj){

        $scope.promiseList = User.delete({id:obj.id}, function(data){

            $scope.loadList();

        }, function(err){

            //console.log(err);

        }).$promise;

    };

    /**
     * Load list
     * @param tableState
     */
    $scope.loadList = function(tableState){

        if(tableState){
            $scope.tableState = tableState;
        }else{
            tableState = $scope.tableState;
        }

        var pagination = tableState.pagination;
        var sort = tableState.sort;

        $scope.params.page = pagination.start >= 10 ? ((pagination.start/pagination.number)+1) : 0;
        $scope.params.limit = pagination.number || 10;

        if(sort){
            $scope.params.sort = sort.predicate;
            $scope.params.sortOrder = sort.reverse == true ? 'DESC' : 'ASC';
        }else{
            $scope.params.sort = null;
            $scope.params.sortOrder = null;
        }

        if(tableState.search.predicateObject){
            $scope.params.search = tableState.search.predicateObject.$;
        }

        $scope.promiseList = User.query($scope.params, function(data, responseHeaders){

            var countPages = 0;
            if(responseHeaders('x-count-pages')){
                countPages = parseInt(responseHeaders('x-count-pages'));
            }

            $scope.list = data;
            if(tableState){
                tableState.pagination.numberOfPages = countPages;
            }else{
                $scope.tableState.pagination.numberOfPages = countPages;
            }

        }).$promise;
    };

    /**
     * Form submit
     * @param form
     * @returns {boolean}
     */
    $scope.save = function(form){

        $scope.submitted = true;
        if (form.$invalid) {
            return false;
        }

        if($scope.entity.id){
            delete $scope.entity.password;
            delete $scope.entity.created;
            delete $scope.entity.updated;
        }

        // User represented companies list
        $scope.entity.representedCompanies = [];

        if($scope.representedCompanies.length > 0){

            for(var i = 0, len = $scope.representedCompanies.length; i < len; i++){
                var hasRep = null;
                var rep = $scope.representedCompanies[i];

                if($scope.userRepresentedCompanies){

                    for(var j = 0, lenReps = $scope.userRepresentedCompanies.length; j < lenReps; j++){
                        var uRep = $scope.userRepresentedCompanies[j];
                        if(rep.id == uRep.representedCompany.id){
                            if(rep.selected){
                                hasRep = true;
                                uRep.commission = rep.commission;
                                delete uRep.created;
                                delete uRep.updated;
                                $scope.entity.representedCompanies.push(uRep);
                            }
                        }
                    }

                }

                if(hasRep == null && rep.selected){
                    $scope.entity.representedCompanies.push({
                        user: $scope.entity.id,
                        representedCompany: rep.id,
                        commission: rep.commission
                    });
                }

            };
        }

        $scope.sending = true;

        $scope.promiseForm = $scope.entity.$save(function(data){

            $scope.sending = false;
            $scope.submitted = false;
            $scope.loadList();
            modalForm.hide();

        },function(err){

            modalForm.hide();

        });

    };

    /**
     * Form update password
     * @param form
     * @returns {boolean}
     */
    $scope.updatePassword = function(form){

        $scope.submitted = true;
        if (form.$invalid) {
            return false;
        }

        if($scope.entity.password != $scope.entity.passwordConfirm){
            inform.add("As senhas não conferem, por favor, verifique a senha informada.", {type:"danger"});
            return false;
        }

        delete $scope.entity.created;
        delete $scope.entity.updated;

        $scope.promiseForm = $scope.entity.$save(function(data){

            $scope.sending = false;
            $scope.submitted = false;
            $scope.loadList();
            modalUpdatePasswordForm.hide();

        },function(err){

            modalUpdatePasswordForm.hide();

        });

    };

    /**
     * Toggle device status
     * @param ent
     */
    $scope.toggleStatus = function(ent){

        ent.active = !ent.active;

        delete ent.created;
        delete ent.created;
        delete ent.updated;

        $scope.promiseList = ent.$save(function(data){
            // OK
        },function(err){
            //console.log(err);
        });

    };


}]);
