/**
 * Product Unit Controller
 */
angular.module('salestool').controller('UnitCtrl', ["$scope", "$http", "$urlService", "$resource", "DTOptionsBuilder", "DTColumnBuilder", "DTColumnDefBuilder", "$modal", "$resource",
    function($scope, $http, $urlService, $resource, DTOptionsBuilder, DTColumnBuilder, DTColumnDefBuilder, $modal, $resource){

    // Rest Entity
    var Unit = $resource($urlService.rest('/unit/:id'));

    // Promises
    $scope.promiseList;
    $scope.promiseForm;

    // $scope.title = 'Nova Unidade de Medida';

    // Setup Modal
    var modalForm = $modal({
        //animation:"am-fade-and-slide-top",
        animation:"am-slide-top",
        title:"Unidade de Medida",
        scope: $scope,
        template:'modal-form.html',
        show:false
    });

    // Datatable
    $scope.dtOptions = DTOptionsBuilder.newOptions()
        .withPaginationType('full_numbers')
        .withOption('processing', true);

    $scope.dtColumnDefs = [
        DTColumnDefBuilder.newColumnDef(0),
        DTColumnDefBuilder.newColumnDef(1),
        DTColumnDefBuilder.newColumnDef(2),
        DTColumnDefBuilder.newColumnDef(3),
        DTColumnDefBuilder.newColumnDef(4).notSortable()
    ];

    /**
     * Show Modal
     * @param entityID
     */
    $scope.showModal = function(obj) {

        if(obj != undefined){

            modalForm.$options.title = 'Alterar Unidade de Medida';
            $scope.editing = true;
            $scope.entity = new Unit(obj);
            modalForm.show();

        }else{

            modalForm.$options.title = 'Nova Unidade de Medida';
            $scope.editing = false;
            $scope.entity = new Unit();
            modalForm.show();

        }

    };

    /**
     * Delete entity
     * @param id
     */
    $scope.delete = function(obj){

        $scope.promiseList = Unit.delete({id:obj.id}, function(data){

            $scope.loadList();

        }, function(err){

            console.log(err);

        }).$promise;

    };

    /**
     * Load datatable list
     */
    $scope.loadList = function(){

        // Get data
        $scope.loadingList = true;
        $scope.promiseList = Unit.query(function(data){

            $scope.loadingList = false;
            $scope.list = data;

        }, function(err){

            console.log(err);

        }).$promise;

    }

    /**
     * Form submit
     * @param form
     * @returns {boolean}
     */
    $scope.submit = function(form){

        $scope.submitted = true;
        if (form.$invalid) {
            return false;
        }

        $scope.statusMessage = 'Autenticando...';
        $scope.sending = true;

        $scope.promiseForm = $scope.entity.$save(function(data){

            $scope.sending = false;
            $scope.submitted = false;
            $scope.loadList();
            modalForm.hide();

        },function(err){

            $scope.sending = false;
            $scope.submitted = false;
            modalForm.hide();

        });

    };

    // Init
    $scope.loadList();

}]);