/**
 * Size Controller
 */
angular.module('salestool').controller('SizeCtrl',["$scope", "$http", "$urlService", "$resource", "DTOptionsBuilder", "DTColumnBuilder", "DTColumnDefBuilder", "$modal", "$resource",
    function($scope, $http, $urlService, $resource, DTOptionsBuilder, DTColumnBuilder, DTColumnDefBuilder, $modal, $resource){

    // Rest Entity
    var PaymentCondition = $resource($urlService.rest('/size/:id'));

    // Promises
    $scope.promiseList;
    $scope.promiseForm;

    // Setup Modal
    var modalForm = $modal({
        //animation:"am-fade-and-slide-top",
        animation:"am-slide-top",
        title:"Tamanho",
        scope: $scope,
        template:'modal-form.html',
        show:false
    });

    // Datatable
    $scope.dtOptions = DTOptionsBuilder.newOptions()
        .withPaginationType('full_numbers')
        .withOption('processing', true);

    $scope.dtColumnDefs = [
        DTColumnDefBuilder.newColumnDef(0),                 // id
        DTColumnDefBuilder.newColumnDef(1),                 // descricao
        DTColumnDefBuilder.newColumnDef(2),                 // created_at
        DTColumnDefBuilder.newColumnDef(3),                 // updated_at
        DTColumnDefBuilder.newColumnDef(4).notSortable()    // options
    ];

    /**
     * Show Modal
     * @param entityID
     */
    $scope.showModal = function(obj) {

        if(obj != undefined){

            modalForm.$options.title = 'Alterar Condição de Pagamento';
            $scope.editing = true;
            $scope.entity = new PaymentCondition(obj);
            modalForm.show();

        }else{

            modalForm.$options.title = 'Nova Condição de Pagamento';
            $scope.editing = false;
            $scope.entity = new PaymentCondition();
            modalForm.show();

        }

    };

    /**
     * Delete entity
     * @param id
     */
    $scope.delete = function(obj){

        $scope.promiseList = PaymentCondition.delete({id:obj.id}, function(data){

            $scope.loadList();

        }, function(err){

            console.log(err);

        }).$promise;

    };

    /**
     * Load datatable list
     */
    $scope.loadList = function(){

        // Get data
        $scope.loadingList = true;
        $scope.promiseList = PaymentCondition.query(function(data){

            $scope.loadingList = false;
            $scope.list = data;

        }, function(err){

            console.log(err);

        }).$promise;

    }

    /**
     * Form submit
     * @param form
     * @returns {boolean}
     */
    $scope.submit = function(form){

        $scope.submitted = true;
        if (form.$invalid) {
            return false;
        }

        $scope.sending = true;

        $scope.promiseForm = $scope.entity.$save(function(data){

            $scope.sending = false;
            $scope.submitted = false;
            $scope.loadList();
            modalForm.hide();

        },function(err){

            $scope.sending = false;
            $scope.submitted = false;
            modalForm.hide();

        });

    };

    // Init
    $scope.loadList();

}]);