/**
 * Customer Controller
 */
angular.module('salestool')
.controller('SellerMapCtrl',["$scope", "$timeout", "$http", "$urlService", "$resource", "DTOptionsBuilder", "DTColumnBuilder", "DTColumnDefBuilder", "$modal", "$resource", "Upload", "inform", "uiGmapGoogleMapApi", "uiGmapIsReady",
function($scope, $timeout, $http, $urlService, $resource, DTOptionsBuilder, DTColumnBuilder, DTColumnDefBuilder, $modal, $resource, Upload, inform, uiGmapGoogleMapApi, uiGmapIsReady){

    var geocoder = null;

    $scope.entity = GLOBAL_USER_ENTITY;

    // Attributes
    $scope.mapOptions = {
        center: {
            latitude: -23.408607,
            longitude: -51.9370970
        },
        zoom: 4
    };
    $scope.mapRef = false;
    $scope.sellers = [];
    $scope.sellersOriginal = [];
    $scope.list = {
        states: [],
        cities: []
    };
    $scope.states = [];
    $scope.cities = [];
    $scope.markers = [];
    $scope.filter = {
        select: 'none',
        state: null,
        city: null
    };

    uiGmapGoogleMapApi.then(function(maps) {
        maps.visualRefresh = true;
    });

    uiGmapIsReady.promise().then(function (instances) {
        $scope.mapRef = instances[0].map;
        initMap();
        $scope.findSellers();
    });

    var initMap = function() {
        geocoder = new google.maps.Geocoder();
    };

    $scope.cleanMap = function() {
        if ($scope.markers !== null) {
            for (var i in $scope.markers) {
                $scope.markers[i].setMap(null);
                $scope.markers.splice(i, 1);
            }
        }
        if ($scope.markers.length !== undefined && $scope.markers.length > 0)
            $scope.cleanMap();
        google.maps.event.trigger($scope.mapRef, 'resize');
    };

    function getRandomColor() {
        var letters = '0123456789ABCDEF';
        var color = '#';
        for (var i = 0; i < 6; i++ ) {
            color += letters[Math.floor(Math.random() * 16)];
        }
        return color;
    }

    /**
     * Find sellers
     */
    $scope.findSellers = function () {

        if ($scope.mapRef == false)
            return false;

        $scope.cleanMap();

        $http.get($urlService.rest('/seller-map'))
        .then(function(response) {
            if (response.data !== null && response.data !== undefined) {
                for (var s in response.data) {

                    var seller = response.data[s];
                    seller.selected = false;
                    seller.color = getRandomColor();

                    for (var state in seller.states) {
                        var cities = seller.states[state];
                        for (var city in cities) {

                            if ($scope.cities[state] === undefined)
                                $scope.cities[state] = [];

                            $scope.cities[state].push(city);

                        }
                    }

                    $scope.sellers.push(seller);
                }
                $scope.sellersOriginal = angular.copy($scope.sellers);
                $scope.states = [];
                for (var state in $scope.cities) {
                    $scope.states.push(state);
                    $scope.list.states.push(state.toUpperCase());
                }
            }
        });
    };

    $scope.setFilterCities = function () {
        $scope.list.cities = [];
        $scope.filter.city = null;
        if ($scope.filter.state === null || $scope.filter.state === undefined)
            return;
        if (
            $scope.cities[$scope.filter.state.toLowerCase()] !== undefined
        ) {
            for (var c in $scope.cities[$scope.filter.state.toLowerCase()]) {
                var city = $scope.cities[$scope.filter.state.toLowerCase()][c];
                if (city !== "" && $scope.list.cities.indexOf(city.toUpperCase()) === -1)
                    $scope.list.cities.push(city.toUpperCase());
            }
        }
        $scope.setFilterSeller();
    };

    $scope.setFilterSeller = function () {
        $scope.cleanMap();
        $scope.sellers = [];
        var sellersToFilter = $scope.sellersOriginal;
        if ($scope.filter.state !== null && $scope.filter.state !== undefined && $scope.filter.state !== "") {
            for (var s in sellersToFilter) {
                var seller = sellersToFilter[s];
                if (seller.states[$scope.filter.state.toLowerCase()] !== undefined) {
                    if (
                        $scope.filter.city === null ||
                        $scope.filter.city === ""
                    ) {
                        $scope.sellers.push(seller);
                    } else if (
                        seller.states[$scope.filter.state.toLowerCase()][$scope.filter.city.toLowerCase()] !== undefined &&
                        seller.states[$scope.filter.state.toLowerCase()][$scope.filter.city.toLowerCase()] === true
                    ) {
                        $scope.sellers.push(seller);
                    }
                }
            }
        }
    };

    function addMarker (address, sellerName, sellerColor) {
        geocoder.geocode(address, function(results, status) {
            if (status == google.maps.GeocoderStatus.OK) {
                /*
                 var cityCircle = new google.maps.Circle({
                 strokeColor: seller.color,
                 strokeOpacity: 0.8,
                 strokeWeight: 2,
                 fillColor: seller.color,
                 fillOpacity: 0.35,
                 map: $scope.mapRef,
                 center: {
                 lat: results[0].geometry.location.lat(),
                 lng: results[0].geometry.location.lng()
                 },
                 radius: Math.sqrt(10000) * 50
                 });
                 */
                var lat = results[0].geometry.location.lat();
                var long = results[0].geometry.location.lng();
                var rep = "0.00"+Math.floor((Math.random() * 1000) + 1);
                var config = {
                    position: new google.maps.LatLng(lat+parseFloat(rep), long),
                    map: $scope.mapRef,
                    icon: 'http://chart.apis.google.com/chart?chst=d_map_pin_letter&chld=%E2%80%A2|'+sellerColor.substring(1, 7),
                    title: sellerName
                };
                var marker = new google.maps.Marker(config);
                $scope.markers.push(marker);

                (function (marker, sellerName, address) {
                    google.maps.event.addListener(marker, "click", function (e) {
                        var infoWindow = new google.maps.InfoWindow();
                        infoWindow.setContent(
                            "Vendedor: "+sellerName+"<br/>"+
                            "Cidade: "+address+""
                        );
                        infoWindow.open($scope.mapRef, marker);
                    });
                })(marker, sellerName, results[0].formatted_address);
            }
        });

    }

    /**
     * Find pins on map
     */
    $scope.showCityPin = function (seller) {
        for (var state in seller.states) {
            var cities = seller.states[state];
            var lastTime = 0;
            for (var city in cities) {
                var address = {'address': city.toUpperCase()+', '+state.toUpperCase()+', Brasil'};

                (function (address, sellerName, sellerColor, time) {
                    setTimeout(function () {
                        addMarker(address, sellerName, sellerColor);
                    }, time);
                })(address, seller.name, seller.color, lastTime + 500);

                lastTime = lastTime + 500;
            }
        }
    };

}]);