/**
 * User profile Controller
 */
angular.module('salestool').controller('ProfileCtrl', ["$scope", "$http", "$urlService", "$resource", "DTOptionsBuilder", "DTColumnBuilder", "DTColumnDefBuilder", "$modal", "$resource", "inform",
    function($scope, $http, $urlService, $resource, DTOptionsBuilder, DTColumnBuilder, DTColumnDefBuilder, $modal, $resource, inform){

    //notifications.showSuccess({message:"hello world!!!"});

    // Rest Entity
    var User = $resource(
        $urlService.rest('/profile/:id'),
        null,
        {
            save: {
                method: 'POST',
                transformRequest: function(data){
                    var fd = new FormData();
                    angular.forEach(data, function(value, key) {
                        fd.append(key, value);
                    });
                    return fd;
                },
                headers: {'Content-Type':undefined, enctype:'multipart/form-data'}
            }
        }
    );

    // Promises
    $scope.promiseList;
    $scope.promiseFormInfo;
    $scope.entity = {};
    $scope.pwdData = {};

    /**
     * Load datatable list
     */
    $scope.getEntity = function(){

        // Get data
        $scope.loadingList = true;
        $scope.promiseList = User.query(function(data){

            $scope.loadingList = false;
            $scope.entity = data[0];

        }, function(err){
            console.log(err);

        }).$promise;

    }

    /**
     * Submit user info
     * @param form
     * @returns {boolean}
     */
    $scope.submitInfo = function(form){

        try{

            $scope.infoSubmitted = true;
            if (form.$invalid) {
                return false;
            }

            if($scope.imageFile.files.length > 0){
                $scope.entity.image = $scope.imageFile.files[0].file;
            }

            $scope.promiseFormInfo = $scope.entity.$save(function(data){

                inform.add("Seus dados foram atualizados!", {type:"success"});
                console.log(data);
                $scope.sending = false;
                $scope.submitted = false;

            },function(err){

                $scope.sending = false;
                $scope.submitted = false;

            });

        }catch(err){

        }


    }

    /**
     * Submit user password update data
     * @param form
     * @returns {boolean}
     */
    $scope.submitPasswordUpdate = function(form){

        $scope.passwordUpdateSubmitted = true;
        if (form.$invalid) {
            return false;
        }

        $scope.pwdData.id = $scope.entity.id;

        $scope.promiseFormPassword = User.save($scope.pwdData, function(data){

            if(data){
                inform.add("Sua senha alterada com sucesso!", {type:"success"});
                $scope.passwordUpdateSubmitted = false;
                $scope.pwdData = {};
            }

        },function(err){

            $('input[name=password]').focus();
            $scope.pwdData.password = "";
            $scope.passwordUpdateSubmitted = false;
            var msg = err.data.message ? err.data.message : err.statusText;
            inform.add("Erro ao alterar senha: " + msg, {type:"danger"});

        })

    }

    // Init
    $scope.getEntity();

}]);