/**
 * Product Controller
 */

angular.module('salestool')
.controller('ProductCtrl', ["$scope", "$http", "$urlService", "$resource", "DTOptionsBuilder", "DTColumnBuilder", "DTColumnDefBuilder", "$modal", "Upload",
function($scope, $http, $urlService, $resource, DTOptionsBuilder, DTColumnBuilder, DTColumnDefBuilder, $modal, Upload){

    var modalForm = $modal({
        //animation:"am-fade-and-slide-top",
        animation:"am-slide-top",
        title:"Estoques",
        scope: $scope,
        template:'modal.warehouse.html',
        show:false
    });

    /* default
    $scope.dtOptions = DTOptionsBuilder.fromSource($urlService.to('/product/list'))
            .withPaginationType('full_numbers');
            .withOption('fnRowCallback', function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {                
                var linkObj = $(aData[0]);
                var imgObj = linkObj.children('img');
                imgObj.attr('src', imgObj.attr('data-img-url'));
                linkObj.append(imgObj);
                $('td:eq(0)', nRow).html( linkObj.prop('outerHTML') ); 
            });
    */

    // Represented Companies
    var RepresentedCompany = $resource($urlService.rest('/represented-company/:id'));
    $scope.listRepresentedCompanies = RepresentedCompany.query();

    $scope.tableState;
    $scope.promiseList;
    $scope.params = {
        active: 1,
        limit: 10
    };

    $scope.$watch('params.active', function(val) {
        $scope.loadingList = true;
        $scope.loadList();
    }, false);

    $scope.loadList = function(tableState){

        $scope.promiseList = $http.get($urlService.to('/product/list'), {params: $scope.params}).success(function (data, status, headers, config) {

            if(!data.error){
                $scope.list = data.results;
                if(tableState){
                    tableState.pagination.numberOfPages = data.pages.pageCount;
                }else{
                    $scope.tableState.pagination.numberOfPages = data.pages.pageCount;
                }
            }

        }).error(function (data, status, headers, config) {

            console.log(data);

        });

    };

    $scope.callServer = function(tableState){

        $scope.tableState = tableState;

        var pagination = tableState.pagination;
        var sort = tableState.sort;

        $scope.params.page = pagination.start >= 10 ? ((pagination.start/pagination.number)+1) : 0; // Get page number
        $scope.params.limit = pagination.number || 10;

        if(sort){
            $scope.params.sort = sort.predicate;
            $scope.params.sortOrder = sort.reverse == true ? 'DESC' : 'ASC';
        }else{
            $scope.params.sort = null;
            $scope.params.sortOrder = null;
        }

        if(tableState.search.predicateObject){
            $scope.params.search = tableState.search.predicateObject.$;
        }

        $scope.loadList(tableState);

    };

    $scope.selectedProduct = {};
    $scope.promiseCheckWarehouse;
    $scope.warehouseList = [];
    $scope.loadWarehouse = function(productObj){
        $scope.selectedProduct = productObj;
        modalForm.show();
        $scope.promiseCheckWarehouse = $http.get($urlService.to('/product/warehouse-stats/'+productObj.id)).success(function (data, status, headers, config) {

            $scope.warehouseList = data;

        }).error(function (data, status, headers, config) {

            console.log(data);

        });
    };

}]);


angular.module('salestool')
.controller('ProductImportCtrl', ["$scope", "Upload", "$timeout", "inform",
function($scope, Upload, $timeout, inform){

    //-------ngFileUpload
    $scope.importTypeModel = 'change';
    $scope.importIdModel = 'reference';
    $scope.uploadFiles = function(file, errFiles) {
        $scope.f = file;
        $scope.errFile = errFiles && errFiles[0];
        if (file && $scope.importTypeModel != '') {
            file.upload = Upload.upload({
                url: '/app/product/import/'+$scope.importTypeModel+'/'+$scope.importIdModel,
                data: {file: file}
            });
            file.upload.then(function (response) {
                $timeout(function () {
                    file.result = response.data;
                    inform.add((response.data.msg !== undefined ? response.data.msg : 'A importação foi realizada com sucesso!'), {type:(response.data.success?"success":"danger")});
                });
            }, function (response) {
                inform.add((response.data.msg !== undefined ? response.data.msg : 'Não foi possível realizar a importação!'), {type:"danger"});
            }, function (evt) {
                //Do nothing
            });
        }
    };
    //-------ngFileUpload

}]);