/**
 * Order Form Controller
 */
angular.module('salestool').controller('OrderFormCtrl',["$scope", "$http", "$urlService", "$resource", "DTOptionsBuilder", "DTColumnBuilder", "DTColumnDefBuilder", "$modal", "$resource", "inform", "$window", "$q", function($scope, $http, $urlService, $resource, DTOptionsBuilder, DTColumnBuilder, DTColumnDefBuilder, $modal, $resource, inform, $window, $q){

    /**
     * Order rest entity
     */
    var Config              = $resource($urlService.rest('/config/:id'));
    var Order               = $resource($urlService.rest('/order/:id'));
    var Customer            = $resource($urlService.rest('/customer/:id'));
    var Product             = $resource($urlService.rest('/product/:id'));
    var User                = $resource($urlService.rest('/user/:id'));
    var RepresentedCompany  = $resource($urlService.rest('/represented-company/:id'));
    var PaymentMethod       = $resource($urlService.rest('/payment-method/:id'));
    var PaymentCondition    = $resource($urlService.rest('/payment-condition/:id'));

    /**
     * Global attributes
     */
    $scope.config = {

    };

    $scope.$urlService = $urlService;
    $scope.entityID;
    $scope.listUsers = [];
    $scope.listPaymentMethods = [];
    $scope.listPaymentConditions = [];

    $scope.promiseForm;
    $scope.promiseSearchCustomer;
    $scope.promiseSearchRepresentedCompany;

    $scope.entity = new Order();
    $scope.entity.type = 'p';
    $scope.entity.orderDate = moment();
    $scope.entity.subtotal = 0;
    $scope.entity.discount = 0;
    $scope.entity.total = 0;
    $scope.entity.orderProducts = [];
    $scope.hasRepresentedCompany;

    $scope.selectedProduct = null;
    $scope.selectedItem = {};

    /**
     * Check if user has represented company
     * @param val
     */
    $scope.setHasRepresentedCompany = function(val){
        $scope.hasRepresentedCompany = val;
    };

    /**
     * Watch selected product attribute
     */
    $scope.$watch('selectedProduct', function(val) {
        if(val !== null && typeof val === 'object'){

            // Check if product already exists
            var item = $scope.findOrderProduct(val);
            if(item){

                inform.add("Produto já incluído no pedido", {type:"warning"});
                $scope.selectedItem = item;

            }else{

                // Setup product variants

                // Grid
                var variants = {
                    type: null,
                    data: []
                };
                if(val.colors.length > 0 && val.sizes.length > 0)
                {
                    variants.type = 'grid';
                    _.forEach(val.colors, function(color,k){
                        var variant = {
                            colorId: color.id,
                            description: color.description,
                            sizes: []
                        };
                        _.forEach(val.sizes, function(size,k){
                            variant.sizes.push({
                                sizeId: size.id,
                                description: size.description,
                                amount: null
                            });
                        });
                        variants.data.push(variant);
                    });
                }

                // Only colors
                if(val.colors.length > 0 && val.sizes.length <= 0)
                {
                    variants.type = 'color';
                    _.forEach(val.colors, function(color,k){
                        variants.data.push({
                            colorId: color.id,
                            description: color.description
                        });
                    });
                }

                // Only size
                if(val.colors.length <= 0 && val.sizes.length > 0)
                {
                    variants.type = 'size';
                    _.forEach(val.sizes, function(size,k){
                        variants.data.push({
                            sizeId: size.id,
                            description: size.description
                        });
                    });
                }

                $scope.selectedItem = {
                    product: val,
                    variants: variants,
                    amount: 0,
                    price: val.price,
                    subtotal: 0,
                    discount: 0,
                    total: 0
                };
            }

            $scope.modalProduct.show();
        }
    }, false);

    /**
     * Select product modal
     */
    $scope.modalProduct = $modal({
        animation:"am-slide-top",
        title:"Adicionar produto",
        scope: $scope,
        template:'modal-form-product.html',
        show: false
    });

    /**
     * Datatable items
     * @type {DTOptions}
     */
    $scope.dtOptions = DTOptionsBuilder.newOptions()
                                       .withOption('order', [[1, 'asc']])
                                       .withPaginationType('full_numbers');

    $scope.dtColumnDefs = [
        DTColumnDefBuilder.newColumnDef(0),
        DTColumnDefBuilder.newColumnDef(1),
        DTColumnDefBuilder.newColumnDef(2),
        DTColumnDefBuilder.newColumnDef(3),
        DTColumnDefBuilder.newColumnDef(4),
        DTColumnDefBuilder.newColumnDef(5),
        /*
        DTColumnDefBuilder.newColumnDef(6),

        DTColumnDefBuilder.newColumnDef(7),
        DTColumnDefBuilder.newColumnDef(8),
        DTColumnDefBuilder.newColumnDef(9),

        DTColumnDefBuilder.newColumnDef(10),

        DTColumnDefBuilder.newColumnDef(11).notSortable()
        */
    ];

    /**
     * Form submit
     * @param form
     * @returns {boolean}
     */
    $scope.saveOrder = function(form, confirm){

        $scope.submitted = true;
        if (form.$invalid) {
            inform.add("Erro ao validar formulário, por favor, verifique os campos em destaque.", {type:"danger"});
            return false;
        }

        if($scope.entity.orderProducts.length <= 0){
            inform.add("Por favor, insira pelo menos um item no pedido.", {type:"danger"});
            return false;
        }

        if(!$scope.isObject($scope.entity.customer)){
            inform.add("Por favor, selecione um cliente válido.", {type:"danger"});
            return false;
        }

        var products = [];
        for(var i=0; i < $scope.entity.orderProducts.length; i++){

            var item = $scope.entity.orderProducts[i];
            var variants = null;

            if(_.has(item,'variants') && item.variants.data.length > 0)
            {
                variants = [];
                _.forEach(item.variants.data, function(obj, k){

                    var variant = {};

                    if(item.variants.type == 'color'){
                        variant.id = obj.id;
                        variant.color = obj.colorId;
                        variant.amount = obj.amount;
                        variants.push(variant);
                    }

                    if(item.variants.type == 'size'){
                        variant.id = obj.id;
                        variant.size = obj.sizeId;
                        variant.amount = obj.amount;
                        variants.push(variant);
                    }

                    if(item.variants.type == 'grid'){
                        _.forEach(obj.sizes, function(sizeObj, kk){
                            var variant = {};
                            variant.id = sizeObj.id;
                            variant.color = obj.colorId;
                            variant.size = sizeObj.sizeId;
                            variant.amount = sizeObj.amount;
                            variants.push(variant);
                        })
                    }

                });

            }

            products.push({
                id: item.product.id,
                amount: item.amount,
                price: item.price,
                discount: item.discount,
                subtotal: item.subtotal,
                total: item.total,
                obs: item.obs,
                orderProductVariants: variants,
                variantsType: (item.variants !== undefined ? item.variants.type : '')
            });
        }

        var params = {
            customer: $scope.entity.customer.id,
            subtotal: $scope.entity.subtotal,
            discount: $scope.entity.discount,
            total: $scope.entity.total,
            orderProducts: products,
            info: $scope.entity.info
        };

        if($scope.entity.representedCompany && $scope.isObject($scope.entity.representedCompany)){
            params.representedCompany = $scope.entity.representedCompany.id;
        }

        if($scope.entity.paymentMethod && $scope.isObject($scope.entity.paymentMethod)){
            params.paymentMethod = $scope.entity.paymentMethod.id;
        }

        if($scope.entity.paymentCondition && $scope.isObject($scope.entity.paymentCondition)){
            params.paymentCondition = $scope.entity.paymentCondition.id;
        }

        if(!$scope.entity.id && $scope.entity.user){
            params.user = $scope.entity.user.id;
        }

        if($scope.entity.id){
            params.id = $scope.entity.id;
        }

        if(confirm){
            params.action = "confirm";
        }

        $scope.promiseForm = $http({
            method: "POST",
            url: $urlService.to('/order/save'),
            data: $.param(params),
            headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
        }).success(function (data, status, headers, config) {

            if(data.success){
                $scope.entity.id = data.id;
                $scope.entity.status = data.status;
                $scope.entity = data.entity;
                inform.add("Pedido salvo com sucesso!", {type:"success"});

                if(confirm){
                    //var deferred = $q.defer();
                    //$scope.promiseForm = deferred.promise;
                    //$window.location.reload();
                }

                if ($scope.entity.id > 0)
                    return $window.location.href = '/app/order/view/'+$scope.entity.id;

            }else{
                inform.add(data.message, {type:"danger"});
            }

        }).error(function (data, status, headers, config) {

            inform.add("Ocorreu um erro ao salvar o pedido. Por favor tente novamente mais tarde. Código: " + status, {type:"danger"});

        });

    };

    /**
     * Load Order entity
     * @param entityID
     */
    $scope.loadEntity = function(entityID){

        $scope.entityID = entityID;
        _loadEntity();

    };

    /**
     * Load Config
     */
    function _loadConfig(){
        Config.get({id:1}, function(data){
            $scope.config = data;
        });
    }

    _loadConfig();

    /**
     * Load User
     * @param userID
     */
    $scope.loadUser = function(userID){
        User.get({id:userID}, function(data){
            $scope.entity.user = data;
        });
    };

    /**
     * (Re)load entity Catalog
     * @private
     */
    function _loadEntity(){
        $scope.promiseForm = Order.get({id:$scope.entityID}, function(ent) {

            _.forEach(ent.orderProducts, function(op, k){

                if(_.isArray(op.orderProductVariants) && op.orderProductVariants.length > 0){

                    // Separate colors and sizes
                    // var colors = [];
                    // var sizes = [];

                    var variants = {
                        type: 'grid',
                        data: []
                    };

                    _.forEach(op.orderProductVariants, function(opv, kk){

                        if(_.isObject(opv.color) && _.isObject(opv.size)) {

                            variants.type = 'grid';

                            var existsColor = false;
                            _.forEach(variants.data, function(v, kkk) {
                                if(v.colorId == opv.color.id){
                                    existsColor = true;
                                    v.sizes.push({
                                        id: opv.id,
                                        description: opv.size.description,
                                        sizeId: opv.size.id,
                                        amount: opv.amount
                                    });
                                }
                            })

                            if(!existsColor){
                                variants.data.push({
                                    colorId: opv.color.id,
                                    description: opv.color.description,
                                    amount: opv.amount,
                                    sizes: [{
                                        id: opv.id,
                                        sizeId: opv.size.id,
                                        amount: opv.amount
                                    }]
                                });
                            }

                        }

                        // Only Color
                        if(_.isObject(opv.color) && !_.isObject(opv.size)) {
                            variants.type = 'color';
                            variants.data.push({
                                id: opv.id,
                                colorId: opv.color.id,
                                description: opv.color.description,
                                amount: opv.amount
                            });
                        }

                        // Only Size
                        if(!_.isObject(opv.color) && _.isObject(opv.size)) {
                            variants.type = 'size';
                            variants.data.push({
                                id: opv.id,
                                sizeId: opv.size.id,
                                description: opv.size.description,
                                amount: opv.amount
                            });
                        }

                    });

                    op.variants = variants;

                }

            });

            $scope.entity = ent;

        }).$promise;
    };

    /**
     * Get users
     * @param queryString
     * @returns {$modal.$promise|*|$tooltip.$promise|$promise|u.$promise|F.$promise}
     */
    $scope.getCustomers = function(queryString){

        if(queryString && queryString.length > 0){
            return $scope.promiseSearchCustomer = Customer.query({search: queryString}).$promise;
        }
        return [];

    };

    /**
     * Get users
     * @param queryString
     * @returns {$modal.$promise|*|$tooltip.$promise|$promise|u.$promise|F.$promise}
     */
    $scope.getRepresentedCompanies = function(queryString){

        if(queryString && queryString.length > 0){
            return $scope.promiseSearchRepresentedCompany = RepresentedCompany.query({search: queryString}).$promise;
        }
        return [];

    };

    /**
     * Get users
     * @param queryString
     * @returns {$modal.$promise|*|$tooltip.$promise|$promise|u.$promise|F.$promise}
     */
    $scope.getProducts = function(queryString){

        if(queryString && queryString.length > 0){
            if($scope.hasRepresentedCompany && $scope.entity.representedCompany){
                return $scope.promiseSearchProduct = Product.query({search: queryString, representedCompany: $scope.entity.representedCompany.id}).$promise;
            }else{
                return $scope.promiseSearchProduct = Product.query({search: queryString}).$promise;
            }
        }
        return [];

    };

    /**
     * Search customer
     * @type {Array}
     */
    $scope.getUsers = function(queryString){

        return User.query({query: queryString}, function(data){

            $scope.listUsers = data;

        }, function(err){

            console.log(err);

        }).$promise;

    };

    /**
     * Search payment methods
     * @type {Array}
     */
    $scope.getPaymentMethods = function(queryString){
        return PaymentMethod.query(function(data){
            $scope.listPaymentMethods = data;
        }).$promise;
    };

    /**
     * Search payment methods
     * @type {Array}
     */
    $scope.getPaymentConditions = function(queryString){
        return PaymentCondition.query(function(data){
            $scope.listPaymentConditions = data;
        }).$promise;
    };

    /**
     * Decrease quantity
     * @param qty
     */
    $scope.decreaseQty = function(obj){
        if(obj.amount !== null && obj.amount != 'undefined'){
            if(obj.amount > 1){
                obj.amount--;
            }else{
                obj.amount = 0;
            }
        }else{
            obj.amount = 0;
        }
    };

    /**
     * Increase quantity
     * @param qty
     */
    $scope.increaseQty = function(obj){
        if(obj.amount == null && obj.amount != 'undefined'){
            obj.amount = 1;
        }else{
            obj.amount++;
        }
    };

    /**
     * Remove item
     * @param obj
     */
    $scope.removeItem = function(obj){
        var index = $scope.entity.orderProducts.indexOf(obj);
        $scope.entity.orderProducts.splice(index, 1);
    };

    /**
     * Add product to entity
     */
    $scope.addProduct = function(form){

        $scope.submittedFormProduct = true;
        if (form.$invalid) {
            return false;
        }

        if($scope.selectedItem.amount <= 0){
            return false;
        }

        if($scope.entity.orderProducts.indexOf($scope.selectedItem) == -1){
            $scope.entity.orderProducts.push($scope.selectedItem);
        }

        $scope.modalProduct.hide();

        $scope.submittedFormProduct = false;
        $scope.selectedProduct = null;
    };

    /**
     * Edit orderProduct
     * @param item
     */
    $scope.editItem = function(item){
        if(item){
            $scope.selectedItem = item;
            $scope.modalProduct.show();
        }
    };

    /**
     * Calculate amount
     * @param product
     */
    $scope.calculateAmount = function(){
        var sum = 0;
        _.forEach($scope.selectedItem.variants.data, function(v,k){
            if(_.has(v, 'amount') && v.amount > 0){
                sum += v.amount;
            }
            if(_.has(v, 'sizes') && _.isArray(v.sizes)){
                _.forEach(v.sizes, function(size, kk){
                    sum += size.amount;
                })
            }
        });
        $scope.selectedItem.amount = sum;
    };

    /**
     * Calculate order
     */
    $scope.calculateOrder = function(){

        var subtotal = 0;
        var total = 0;

        if($scope.entity.orderProducts && $scope.entity.orderProducts.length > 0){
            for(var i=0; i < $scope.entity.orderProducts.length; i++){
                var item = $scope.entity.orderProducts[i];
                subtotal += item.total;
            }
            total = subtotal - $scope.entity.discount;
        }

        $scope.entity.subtotal = subtotal;
        $scope.entity.total = total;

    };

    /**
     * Calculate selectedItem property
     */
    $scope.calculateSelectedItem = function(){
        if($scope.selectedItem.amount){
            $scope.selectedItem.subtotal = ($scope.selectedItem.amount * $scope.selectedItem.price);
            $scope.selectedItem.total = ($scope.selectedItem.subtotal - ($scope.selectedItem.discount ? $scope.selectedItem.discount : 0));
        }else{
            $scope.selectedItem.subtotal = 0;
            $scope.selectedItem.total = 0;
        }
    };

    /**
     * Watch selectedItem amount
     */
    $scope.$watch('selectedItem.amount', function(val) {
        $scope.calculateSelectedItem();
    }, false);

    /**
     * Watch selectedItem discount
     */
    $scope.$watch('selectedItem.discount', function(val) {
        $scope.calculateSelectedItem();
    }, false);

    /**
     * Watch selectedItem price
     */
    $scope.$watch('selectedItem.price', function(val) {
        if ($scope.config.enableOrderProductPriceChange == true)
            $scope.calculateSelectedItem();
    }, false);

    /**
     * Watch entity discount
     */
    $scope.$watch('entity.discount', function(val) {
        $scope.calculateOrder();
    }, false);

    /**
     * Watch orderProducts collection
     */
    $scope.$watchCollection('entity.orderProducts', function(val) {
        $scope.calculateOrder();
    });

    /**
     * Find product in entity.orderProducts list
     * @param product
     * @returns {null}
     */
    $scope.findOrderProduct = function(product){
        if($scope.entity.orderProducts && $scope.entity.orderProducts.length > 0){
            for(var i=0; i < $scope.entity.orderProducts.length; i++){
                var item = $scope.entity.orderProducts[i];
                if(item.product.id == product.id){
                    return item;
                }
            }
        }
        return null;
    };

    /**
     * Check if represented company is selected
     * @returns {boolean}
     */
    $scope.isRepresentedCompanySelected = function(){
        return $scope.isObject($scope.entity.representedCompany);
    };

    /**
     * Check if value is a valid Object
     * @param val
     * @returns {boolean}
     */
    $scope.isObject = function(val){
        if(val !== null && typeof val === 'object'){
            return true;
        }
        return false;
    };

}]);