/**
 * Product Unit Controller
 */
angular.module('salestool')
.controller('OrderCtrl', ["$scope", "$http", "$urlService", "$resource", "DTOptionsBuilder", "DTColumnBuilder", "DTColumnDefBuilder", "$modal", "$resource", "store", "$filter", "inform",
function($scope, $http, $urlService, $resource, DTOptionsBuilder, DTColumnBuilder, DTColumnDefBuilder, $modal, $resource, store, $filter, inform){

    //------------------- Order Default -------------------------//

        // Rest Entity
        var Order               = $resource($urlService.rest('/order/:id'));
        var Customer            = $resource($urlService.rest('/customer/:id'));
        var User                = $resource($urlService.rest('/user/:id'));
        var RepresentedCompany  = $resource($urlService.rest('/represented-company/:id'));
        var storage             = store.getNamespacedStore('Order');

        // Query Params
        $scope.params = {
            dateRange: {
                // startDate: (storage.get('startDate') ? storage.get('startDate') : moment().startOf('day').toDate()),
                // endDate: (storage.get('endDate') ? storage.get('endDate') : moment().endOf('day').toDate())
                startDate: moment().startOf('day').toDate(),
                endDate: moment().endOf('day').toDate()
            },
            dateField: 'orderDate',
            customer: null
        };

        // Promises
        $scope.promiseList;

        // Datatable
        $scope.dtOptions = DTOptionsBuilder.newOptions()
            .withPaginationType('full_numbers')
            .withOption('order', [[0, 'desc']])
            .withOption('processing', true);

        $scope.dtColumnDefs = [
            DTColumnDefBuilder.newColumnDef(0),
            DTColumnDefBuilder.newColumnDef(1),
            DTColumnDefBuilder.newColumnDef(2),
            DTColumnDefBuilder.newColumnDef(3),
            DTColumnDefBuilder.newColumnDef(4),
            DTColumnDefBuilder.newColumnDef(5),
            DTColumnDefBuilder.newColumnDef(6),
            DTColumnDefBuilder.newColumnDef(7),
            DTColumnDefBuilder.newColumnDef(8),
            DTColumnDefBuilder.newColumnDef(9),
            DTColumnDefBuilder.newColumnDef(10),
            DTColumnDefBuilder.newColumnDef(11).notSortable()
        ];

        /**
         * Load datatable list
         */
        $scope.totalSum = 0;
        $scope.loadList = function(){

            var qParams = {
                dateField: $scope.params.dateField,
                startDate: $scope.params.dateRange.startDate,
                endDate: $scope.params.dateRange.endDate,
                customer: ($scope.params.customer ? $scope.params.customer.id : null),
                user: ($scope.params.user ? $scope.params.user.id : null),
                status: $scope.params.status,
                representedCompany: $scope.params.representedCompany
            };

            // Set default date range
            // storage.set('startDate', $scope.params.dateRange.startDate);
            // storage.set('endDate', $scope.params.dateRange.endDate);

            // Get data
            $scope.loadingList = true;
            $scope.promiseList = Order.query(qParams, function(data){

                $scope.loadingList = false;
                $scope.list = data;

                var sum = 0;
                angular.forEach($scope.list, function(ent) {
                    //if (sum == 0)
                    //    $scope.showModalAppSync(ent);
                    sum += ent.total;
                });
                $scope.totalSum = sum;

            }, function(err){
                //console.log(err);
            }).$promise;

        };

        /**
         * Search customer
         * @type {Array}
         */
        $scope.listCustomers = [];
        $scope.getCustomers = function(queryString){
            if(queryString && queryString.length > 0){
                return Customer.query({query: queryString}, function(data){
                    $scope.listCustomers = data;
                }, function(err){
                    //console.log(err);
                }).$promise;
            }
        };

        /**
         * Search user
         * @type {Array}
         */
        $scope.listUsers = [];
        $scope.getUsers = function(queryString){
            return User.query({query: queryString}, function(data){
                $scope.listUsers = data;
            }, function(err){
                //console.log(err);
            }).$promise;
        };

        /**
         * List Represented Company for select
         */
        $scope.listRepresentedCompanies = RepresentedCompany.query();

        /**
         * URL Service
         */
        $scope.$urlService = $urlService;

        // Init
        $scope.loadList();

    //------------------- Order Default -------------------------//


    //------------------- APP Custom Sync -------------------------//

        $scope.syncOrderModel = {
            customer: '',
            datetime: ''
        };

        // Setup App Sync Modal
        $scope.modalAppSync = $modal({
            //animation:"am-fade-and-slide-top",
            animation:"am-slide-top",
            title:"Detalhes da Sincronia com o Vendedor",
            scope: $scope,
            template:'modal-app-sync.html',
            show:false
        });

        // Show App Sync Modal
        $scope.showModalAppSync = function(ent){

            $scope.orderAppSync = ent;
            if ($scope.orderAppSync.appSync == undefined || $scope.orderAppSync.appSync == false) { //Order not sync
                $scope.orderAppSync.appSync = false;
                if ($scope.orderAppSync.appSyncDatetime == undefined)
                    $scope.orderAppSync.appSyncDatetime = '';
                if ($scope.orderAppSync.appDatetimeToSync == undefined)
                    $scope.orderAppSync.appDatetimeToSync = '';
            }

            $scope.syncOrderModel = {
                user: $scope.orderAppSync.user !== undefined ?
                    $scope.orderAppSync.user :
                    '',
                datetime: $scope.orderAppSync.appDatetimeToSync !== undefined ?
                    $scope.orderAppSync.appDatetimeToSync :
                    ''
            };

            $scope.modalAppSync.show();
        };

        // Save App Sync Model
        $scope.saveAppSync = function(){

            if(
               $scope.syncOrderModel.user == undefined ||
               $scope.syncOrderModel.user.id == undefined ||
               parseInt($scope.syncOrderModel.user.id) <= 0 ||
               $scope.orderAppSync.appSyncDatetime == undefined ||
               $scope.orderAppSync.appSyncDatetime == ''
            ){
                inform.add('Não foi possível salvar suas informações!', {type:"danger"});
                return false;
            }

            var params = {
                id: $scope.orderAppSync.id,
                user: $scope.syncOrderModel.user.id,
                appSync: false,
                appDatetimeToSync: $scope.orderAppSync.appSyncDatetime
                //appSyncDatetime: ''
            };

            $http({
                method: "POST",
                url: $urlService.rest('/order/update/'+$scope.orderAppSync.id),
                data: $.param(params),
                headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
            }).success(function (data, status, headers, config) {

                if(data.id !== undefined){
                    //$scope.loadList();
                    for (var i in $scope.list) {
                        var item = $scope.list[i];
                        if (item.id == data.id) {
                            $scope.list[i].user = data.user;
                            $scope.list[i].appDatetimeToSync = data.appDatetimeToSync;
                            break;
                        }
                    }
                    $scope.modalAppSync.hide();
                    inform.add("Alterações salvas com sucesso!", {type:"success"});
                }else{
                    inform.add("Não foi possível salvar suas informações!", {type:"danger"});
                }

            }).error(function (data, status, headers, config) {

                inform.add("Ocorreu um erro ao salvar as informações! Por favor tente novamente mais tarde. Código: " + status, {type:"danger"});

            });

        };

        // Update date to sync
        $scope.updateDateAppSync = function ($view, $dates, $leftDate, $upDate, $rightDate) {
            var date = $filter('date')($scope.syncOrderModel.datetime, 'yyyy-MM-dd HH:mm');
            if (date != '')
                $scope.orderAppSync.appSyncDatetime = date+':00';
        };

    //------------------- APP Custom Sync -------------------------//


    //------------------- Order Locations Markers -------------------------//

        // Map object
        $scope.map = {
            center: {
                latitude: 0,
                longitude: 0
            },
            zoom: 10
        };

        // Setup Modal
        $scope.modalMap = $modal({
            //animation:"am-fade-and-slide-top",
            animation:"am-slide-top",
            title:"Local em que o pedido foi feito",
            scope: $scope,
            template:'modal-map.html',
            show:false
        });

        // Show modal map
        $scope.mapMarkers = [];
        $scope.showModalMap = function(ent){
            //console.log('showModalMap');
            if(ent){

                $scope.mapMarkers = [];
                var marker = {
                    id: ent.id,
                    coords: {
                        latitude: ent.latitude,
                        longitude: ent.longitude
                    },
                    show: false,
                    entityObj: ent
                };
                marker.onClick = function() {
                    ret.show = !ret.show;
                };
                $scope.mapMarkers.push(marker);

            }else{
                if(!$scope.list || !$scope.list.length){
                    alert("Nenhum pedido selecionado");
                    return;
                }

                $scope.mapMarkers = [];
                angular.forEach($scope.list, function(value,key){
                    var marker = {
                        id: value.id,
                        coords: {
                            latitude: value.latitude,
                            longitude: value.longitude
                        },
                        show: false,
                        entityObj: value
                    };
                    marker.onClick = function() {
                        ret.show = !ret.show;
                    };
                    $scope.mapMarkers.push(marker);
                });
            }
            //$scope.map.center.latitude  = ent.latitude;
            //$scope.map.center.longitude = ent.longitude;
            $scope.modalMap.show();
        };

    //------------------- Order Locations Markers -------------------------//

}]);