/**
 * Payment Condition Controller
 */
angular.module('salestool').controller('OAuth2ClientCtrl',["$scope", "$http", "$urlService", "$resource", "DTOptionsBuilder", "DTColumnBuilder", "DTColumnDefBuilder", "$modal", "$resource", "$ngBootbox",
    function($scope, $http, $urlService, $resource, DTOptionsBuilder, DTColumnBuilder, DTColumnDefBuilder, $modal, $resource, $ngBootbox){

    // Rest Entity
    var Client = $resource($urlService.rest('/client/:id'));

    // Promises
    $scope.promiseList;
    $scope.promiseForm;
    $scope.promiseUpdateSecret;

    // Setup Modal
    var modalForm = $modal({
        //animation:"am-fade-and-slide-top",
        animation:"am-slide-top",
        title:"Aplicação (API)",
        scope: $scope,
        template:'modal-form.html',
        show:false
    });

    // Datatable
    $scope.dtOptions = DTOptionsBuilder.newOptions()
        .withPaginationType('full_numbers')
        .withOption('processing', true);

    $scope.dtColumnDefs = [
        DTColumnDefBuilder.newColumnDef(0),                 // id
        DTColumnDefBuilder.newColumnDef(1),                 // secret
        DTColumnDefBuilder.newColumnDef(2),                 // descricao
        DTColumnDefBuilder.newColumnDef(3),                 // created_at
        DTColumnDefBuilder.newColumnDef(4),                 // updated_at
        DTColumnDefBuilder.newColumnDef(5).notSortable()    // options
    ];

    /**
     * Show Modal
     * @param entityID
     */
    $scope.showModal = function(obj) {

        if(obj != undefined){

            modalForm.$options.title = 'Alterar Aplicação';
            $scope.editing = true;
            $scope.entity = new Client(obj);
            modalForm.show();

        }else{

            modalForm.$options.title = 'Nova Aplicação';
            $scope.editing = false;
            $scope.entity = new Client();
            $scope.entity.active = true;
            modalForm.show();

        }

    };

    /**
     * Delete entity
     * @param id
     */
    $scope.delete = function(obj){

        $scope.promiseList = Client.delete({id:obj.id}, function(data){

            $scope.loadList();

        }, function(err){

            console.log(err);

        }).$promise;

    };

    /**
     * Load datatable list
     */
    $scope.loadList = function(){

        // Get data
        $scope.loadingList = true;
        $scope.promiseList = Client.query(function(data){

            $scope.loadingList = false;
            $scope.list = data;

        }, function(err){

            console.log(err);

        }).$promise;

    }

    /**
     * Form submit
     * @param form
     * @returns {boolean}
     */
    $scope.submit = function(form){

        $scope.submitted = true;
        if (form.$invalid) {
            return false;
        }

        $scope.sending = true;

        $scope.promiseForm = $scope.entity.$save(function(data){

            $scope.sending = false;
            $scope.submitted = false;
            $scope.loadList();
            modalForm.hide();

        },function(err){

            $scope.sending = false;
            $scope.submitted = false;
            modalForm.hide();

        });

    };

    /**
     * Update entity secret
     * @param entity
     */
    $scope.updateSecret = function(entity){

        if(!entity){
            return false;
        }

        $ngBootbox.confirm('Tem certeza que deseja atualizar o secret desta aplicação ('+entity.clientId+') ?')
            .then(function() {

                $scope.promiseUpdateSecret = $http({
                    method: 'post',
                    url: $urlService.to('/client/update-secret/' + entity.id),
                    headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
                }).success(function (data, status, headers, config) {

                    if(!data.success){
                        inform.add(data.message, {type:"danger"});
                    }

                    entity.secret_plain = data.secret;

                });

            }, function() {

                $ngBootbox.hideAll();

            });

    };

    // Init
    $scope.loadList();

}]);