/**
 * User Controller
 */

angular.module('salestool')
.controller('MapCtrl', ["$scope", "$http", "$urlService", "$resource", "DTOptionsBuilder", "DTColumnBuilder", "DTColumnDefBuilder", "$modal", "inform", "uiGmapGoogleMapApi", "uiGmapIsReady", "$filter",
function($scope, $http, $urlService, $resource, DTOptionsBuilder, DTColumnBuilder, DTColumnDefBuilder, $modal, inform, uiGmapGoogleMapApi, uiGmapIsReady, $filter){

    // Entities
    var UserLocation = $resource($urlService.rest('/user-location/:id'));

    $scope.entity = GLOBAL_USER_ENTITY;

    // Attributes
    $scope.mapMarkers = [];
    $scope.promiseLocations;
    $scope.params = { limit: 10 };
    $scope.dateRange = {
        range: { startDate: moment().startOf('day').toDate(), endDate: moment().endOf('day').toDate() }
    };
    $scope.mapOptions = {
        center: {
            latitude: -23.408607,
            longitude: -51.9370970
        },
        zoom: 8
    };
    $scope.mapRef = false;
    $scope.mapAux = {
        conexMarkers: [],
        conexDirections: []
    };

    $scope.showType = 'markers';
    var directionsService = {};
    var directionsDisplay = {};

    uiGmapGoogleMapApi.then(function(maps) {
        //console.log('uiGmapGoogleMapApi');
        maps.visualRefresh = true;
    });

    uiGmapIsReady.promise().then(function (instances) {
        //console.log('uiGmapIsReady');
        $scope.mapRef = instances[0].map;
        initMap();
    });

    var initMap = function() {
        //console.log('initMap');
        directionsService = new google.maps.DirectionsService();
        directionsDisplay = new google.maps.DirectionsRenderer();
        directionsDisplay.setMap($scope.mapRef);
    };

    var calculateAndDisplayRoute = function(request) {
        //console.log('calculateAndDisplayRoute');
        if ($scope.mapRef === false || $scope.mapObj == false)
            return false;
        directionsService.route(request, function(response, status) {
            if (status === google.maps.DirectionsStatus.OK) {
                directionsDisplay.setDirections(response);
                directionsDisplay.setOptions({
                    suppressMarkers: true
                });
                $scope.mapAux.conexDirections.push(directionsDisplay);
            }
        });
    };

    var cleanMap = function() {
        //console.log('cleanMap');
        directionsDisplay.setMap(null);
        directionsDisplay = null;
        if ($scope.mapAux.conexMarkers.length > 0) {
            for (var i in $scope.mapAux.conexMarkers)
                $scope.mapAux.conexMarkers[i].setMap(null);
        }
        if ($scope.mapAux.conexDirections.length > 0) {
            for (var j in $scope.mapAux.conexDirections) {
                $scope.mapAux.conexDirections[j].setMap(null);
                $scope.mapAux.conexDirections[j] = null;
            }
        }
        $scope.mapAux.conexMarkers = [];
        $scope.mapAux.conexDirections = [];
        directionsDisplay = new google.maps.DirectionsRenderer();
        directionsDisplay.setMap($scope.mapRef);
        google.maps.event.trigger($scope.mapRef, 'resize');
    };

    $scope.changeType = function(type){
        //console.log('changeType');
        $scope.showType = type;
    };

    /**
     * Find locatios for selected entity
     */
    $scope.findLocations = function(){

        if ($scope.mapRef == false)
            return false;

        cleanMap();
        $scope.promiseLocations = UserLocation.query({
            user: $scope.entity.id,
            limit: 0,
            startDate: $scope.dateRange.range.startDate,
            endDate: $scope.dateRange.range.endDate
        }, function(data, responseHeaders){

            if(data && data.length > 0){

                $scope.mapMarkers = [];
                angular.forEach(data, function(value,key){

                    var marker = {
                        id: value.id,
                        coords: {
                            latitude: value.latitude,
                            longitude: value.longitude
                        },
                        show: false,
                        entityObj: value
                    };
                    marker.onClick = function() {
                        marker.show = !marker.show;
                    };
                    $scope.mapMarkers.push(marker);

                    if (
                        ($scope.showType == 'markers' || $scope.showType == 'route-markers') &&
                        value.latitude != '' && value.longitude != '' && value.latitude != null && value.longitude != null
                    ) {
                        var config = {
                            position: new google.maps.LatLng(value.latitude, value.longitude),
                            map: $scope.mapRef,
                            title: value.user.name
                        };
                        var marker = new google.maps.Marker(config);
                        $scope.mapAux.conexMarkers.push(marker);
                        (function (marker, value) {
                            google.maps.event.addListener(marker, "click", function (e) {
                                var infoWindow = new google.maps.InfoWindow();
                                infoWindow.setContent(
                                    "Usuário: "+value.user.name+"<br/>"+
                                    "Coordenadas: "+value.latitude+", "+value.longitude+"<br/>"+
                                    "Data: "+$filter('date')(value.created)+""
                                );
                                infoWindow.open($scope.mapRef, marker);
                            });
                        })(marker, value);
                    }

                });


                //-----------ROUTES------------//
                if (($scope.showType == 'route' || $scope.showType == 'route-markers') && $scope.mapMarkers.length > 0) {

                    var summaryPanel = [];
                    var waypts = [];
                    var origin = '';
                    var destination = '';
                    var lastDestination = '';
                    var counter = 0;
                    var counterInner = 0;
                    for (var m in $scope.mapMarkers) {
                        counter++;
                        counterInner++;
                        var marker = $scope.mapMarkers[m];
                        var point = new google.maps.LatLng({lat: marker.coords.latitude, lng: marker.coords.longitude});
                        if (counterInner == 1)
                            origin = point;
                        else if (lastDestination != '')
                            origin = lastDestination;

                        if (counter > 1 && counter < 10 && counterInner != $scope.mapMarkers.length) {
                            waypts.push({
                                location: point,
                                stopover: true
                            });
                        } else {
                            destination = point;
                        }

                        if (counter == 10 || counterInner == $scope.mapMarkers.length) {
                            lastDestination = destination;
                            var request = {
                                origin: origin,
                                destination: destination,
                                waypoints: waypts,
                                optimizeWaypoints: true,
                                travelMode: google.maps.TravelMode.DRIVING
                            };
                            calculateAndDisplayRoute(request);
                            waypts = [];
                            origin = '';
                            destination = '';
                            counter = 0;
                        }
                    }
                    if ($scope.showType == 'route')
                        $scope.mapMarkers = [];
                }
                //-----------ROUTES------------//

            }

        }).$promise;

    };

}]);
