/**
 * Login Controller
 */

angular.module('salestool').controller('LoginCtrl', ["$scope", "$http", function($scope, $http){
    
    $scope.error = false;
    $scope.sending = false;
    $scope.statusMessage = '';
    $scope.data = {};
    $scope.submit = function(form){
        
        $scope.submitted = true;
        if (form.$invalid) {
            return false;
        }
        
        $scope.statusMessage = 'Autenticando...';
        $scope.sending = true;
        
        var url = _baseUrl + '/login/auth';
        
        $http({
          method: 'post',
          url: url,
          data: $.param($scope.data),
          headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
        }).success(function (data, status, headers, config) {

            if(!data.success){
                $scope.sending = false;
                $scope.error = data.message;
                return;
            }
            
            // Redirect to home
            $scope.statusMessage = 'Redirecionando...';
            window.location.href = _baseUrl;
            
        }).error(function (data, status, headers, config) {
            $scope.sending = false;
            $scope.error = 'Erro ao autenticador usuário. Status: ' + status;
        });
        
    };
    
}]);