/**
 * Product Group Controller
 */
angular.module('salestool').controller('GroupCtrl', ["$scope", "$http", "$urlService", "$resource", "DTOptionsBuilder", "DTColumnBuilder", "DTColumnDefBuilder", "$modal", "$resource",
    function($scope, $http, $urlService, $resource, DTOptionsBuilder, DTColumnBuilder, DTColumnDefBuilder, $modal, $resource){

    // Rest Entity
    var Group = $resource($urlService.rest('/group/:id'));

    // Promises
    $scope.promiseList;
    $scope.promiseForm;

    // Setup Modal
    var modalForm = $modal({
        //animation:"am-fade-and-slide-top",
        animation:"am-slide-top",
        title:"Grupos de Produto",
        scope: $scope,
        template:'modal-form.html',
        show:false
    });

    // Datatable
    $scope.dtOptions = DTOptionsBuilder.newOptions()
        .withPaginationType('full_numbers')
        .withOption('processing', true);

    $scope.dtColumnDefs = [
        DTColumnDefBuilder.newColumnDef(0),
        DTColumnDefBuilder.newColumnDef(1),
        DTColumnDefBuilder.newColumnDef(2),
        DTColumnDefBuilder.newColumnDef(3),
        DTColumnDefBuilder.newColumnDef(4).notSortable()
    ];

    /**
     * Show Modal
     * @param entityID
     */
    $scope.showModal = function(obj) {

        if(obj != undefined){

            $scope.editing = true;
            $scope.entity = new Group(obj);
            modalForm.show();

        }else{

            $scope.editing = false;
            $scope.entity = new Group();
            modalForm.show();

        }

    };

    /**
     * Delete entity
     * @param id
     */
    $scope.delete = function(obj){

        $scope.promiseList = Group.delete({id:obj.id}, function(data){

            $scope.loadList();

        }, function(err){

            console.log(err);

        }).$promise;

    };

    /**
     * Load datatable list
     */
    $scope.loadList = function(){

        // Get data
        $scope.loadingList = true;
        $scope.promiseList = Group.query(function(data){

            $scope.loadingList = false;
            $scope.list = data;

        }, function(err){

            console.log(err);

        }).$promise;

    }

    /**
     * Form submit
     * @param form
     * @returns {boolean}
     */
    $scope.submit = function(form){

        $scope.submitted = true;
        if (form.$invalid) {
            return false;
        }

        $scope.statusMessage = 'Autenticando...';
        $scope.sending = true;

        $scope.promiseForm = $scope.entity.$save(function(data){

            $scope.sending = false;
            $scope.submitted = false;
            $scope.loadList();
            modalForm.hide();

        },function(err){

            $scope.sending = false;
            $scope.submitted = false;
            modalForm.hide();

        });

    };

    // Init
    $scope.loadList();

}]);