/**
 * Device Controller
 */

angular.module('salestool').controller('DeviceCtrl', ["$scope", "$http", "$urlService", "$resource", "DTOptionsBuilder", "DTColumnBuilder", "DTColumnDefBuilder", "$modal", function($scope, $http, $urlService, $resource, DTOptionsBuilder, DTColumnBuilder, DTColumnDefBuilder, $modal){

    // Setup entity
    var Device      = $resource($urlService.rest('/device/:id'));
    var User        = $resource($urlService.rest('/user/:id'));
    var Warehouse   = $resource($urlService.rest('/warehouse/:id'));

    // Setup modal
    var modalEditForm = $modal({
        //animation:"am-fade-and-slide-top",
        animation:"am-slide-top",
        title:"Dispositivos",
        scope: $scope,
        template:'modal-edit-form.html',
        show:false
    });

    $scope.tableState;
    $scope.promiseList;
    $scope.promiseForm;
    $scope.params = {
        limit: 10
    };

    /**
     * Show Modal
     * @param entityID
     */
    $scope.showModalEdit = function(obj) {

        if(obj != undefined){

            $scope.editing = true;
            $scope.entity = new Device(obj);
            modalEditForm.show();

        }else{

            $scope.editing = false;
            $scope.entity = new Device();
            modalEditForm.show();

        }

    };

    /**
     * Delete entity
     * @param id
     */
    $scope.delete = function(obj){

        $scope.promiseList = Device.delete({id:obj.id}, function(data){

            $scope.loadList();

        }, function(err){

            console.log(err);

        }).$promise;

    };

    /**
     * Load list
     * @param tableState
     */
    $scope.loadList = function(tableState){

        if(tableState){
            $scope.tableState = tableState;
        }else{
            tableState = $scope.tableState;
        }

        var pagination = tableState.pagination;
        var sort = tableState.sort;

        $scope.params.page = pagination.start >= 10 ? ((pagination.start/pagination.number)+1) : 0;
        $scope.params.limit = pagination.number || 10;

        if(sort){
            $scope.params.sort = sort.predicate;
            $scope.params.sortOrder = sort.reverse == true ? 'DESC' : 'ASC';
        }else{
            $scope.params.sort = null;
            $scope.params.sortOrder = null;
        }

        if(tableState.search.predicateObject){
            $scope.params.search = tableState.search.predicateObject.$;
        }

        $scope.promiseList = Device.query($scope.params, function(data, responseHeaders){

            var countPages = 0;
            if(responseHeaders('x-count-pages')){
                countPages = parseInt(responseHeaders('x-count-pages'));
            }

            $scope.list = data;
            if(tableState){
                tableState.pagination.numberOfPages = countPages;
            }else{
                $scope.tableState.pagination.numberOfPages = countPages;
            }

        }).$promise;
    }

    /**
     * Form submit
     * @param form
     * @returns {boolean}
     */
    $scope.save = function(form){

        $scope.submitted = true;
        if (form.$invalid) {
            return false;
        }

        if(!$scope.entity.warehouse){
            $scope.entity.warehouse = null;
        }
        
        if(!$scope.entity.user){
            $scope.entity.user = null;
        }

        if ($scope.entity.user.password !== undefined) {
            delete $scope.entity.user.password;
        }

        $scope.sending = true;

        $scope.promiseForm = $scope.entity.$save(function(data){

            $scope.sending = false;
            $scope.submitted = false;
            $scope.loadList();
            modalEditForm.hide();

        },function(err){

            modalEditForm.hide();

        });

    };

    /**
     * Search customer
     * @type {Array}
     */
    $scope.listUsers = [];
    $scope.getUsers = function(queryString){

        return User.query({query: queryString}, function(data){

            $scope.listUsers = data;

        }, function(err){

            console.log(err);

        }).$promise;

    }

    /**
     * Search customer
     * @type {Array}
     */
    $scope.listWarehouses = [];
    $scope.getWarehouses = function(queryString){

        return Warehouse.query({query: queryString}, function(data){

            $scope.listWarehouses = data;

        }, function(err){

            console.log(err);

        }).$promise;

    }

    /**
     * Toggle device status
     * @param ent
     */
    $scope.toggleStatus = function(ent){

        ent.active = !ent.active;

        if (ent.user.password !== undefined) {
            delete ent.user.password;
        }

        $scope.promiseList = ent.$save(function(data){
            // OK
        },function(err){
            console.log(err);
        });

    }


}]);