/**
 * Customer Controller
 */
angular.module('salestool').controller('CustomerCtrl',["$scope", "$timeout", "$http", "$urlService", "$resource", "DTOptionsBuilder", "DTColumnBuilder", "DTColumnDefBuilder", "$modal", "$resource", "Upload", "inform", function($scope, $timeout, $http, $urlService, $resource, DTOptionsBuilder, DTColumnBuilder, DTColumnDefBuilder, $modal, $resource, Upload, inform){

    // Rest Entity
    var Customer = $resource($urlService.rest('/customer/:id'));

    // Promises
    $scope.promiseList;
    $scope.params = {
        limit: 10
    };

    $scope.loadList = function(tableState){

        if(tableState){
            $scope.tableState = tableState;
        }

        var pagination = tableState.pagination;
        var sort = tableState.sort;

        $scope.params.page = pagination.start >= 10 ? ((pagination.start/pagination.number)+1) : 0;
        $scope.params.limit = pagination.number || 10;

        if(sort){
            $scope.params.sort = sort.predicate;
            $scope.params.sortOrder = sort.reverse == true ? 'DESC' : 'ASC';
        }else{
            $scope.params.sort = null;
            $scope.params.sortOrder = null;
        }

        if(tableState.search.predicateObject){
            $scope.params.search = tableState.search.predicateObject.$;
        }

        $scope.promiseList = Customer.query($scope.params, function(data, responseHeaders){

            var countPages = 0;
            if(responseHeaders('x-count-pages')){
                countPages = parseInt(responseHeaders('x-count-pages'));
            }

            $scope.list = data;
            if(tableState){
                tableState.pagination.numberOfPages = countPages;
            }else{
                $scope.tableState.pagination.numberOfPages = countPages;
            }

        }).$promise;
    }

    //-------ngFileUpload
    $scope.importTypeModel = 'change';
    $scope.importIdModel = 'document';
    $scope.uploadFiles = function(file, errFiles) {
        $scope.f = file;
        $scope.errFile = errFiles && errFiles[0];
        if (file && $scope.importTypeModel != '') {
            file.upload = Upload.upload({
                url: '/app/customer/import/'+$scope.importTypeModel+'/'+$scope.importIdModel,
                data: {file: file}
            });
            file.upload.then(function (response) {
                $timeout(function () {
                    file.result = response.data;
                    inform.add((response.data.msg !== undefined ? response.data.msg : 'A importação foi realizada com sucesso!'), {type:(response.data.success?"success":"danger")});
                });
            }, function (response) {
                inform.add((response.data.msg !== undefined ? response.data.msg : 'Não foi possível realizar a importação!'), {type:"danger"});
            }, function (evt) {
                //Do nothing
            });
        }
    };
    //-------ngFileUpload

}]);