/**
 * Catalog Form Controller
 */
angular.module('salestool').controller('CatalogFormCtrl',["$scope", "$http", "$urlService", "$resource", "DTOptionsBuilder", "DTColumnBuilder", "DTColumnDefBuilder", "$modal", "$resource", "inform",
    function($scope, $http, $urlService, $resource, DTOptionsBuilder, DTColumnBuilder, DTColumnDefBuilder, $modal, $resource, inform){

    // Rest Entity
    var CatalogImage = $resource($urlService.rest('/catalog-image/:id'));
    var Catalog = $resource(
        $urlService.rest('/catalog/:id'),
        null,
        {
            save: {
                method: 'POST',
                transformRequest: function(data){
                    var fd = new FormData();
                    angular.forEach(data, function(value, key) {
                        if(key == "file" && angular.isArray(value)){
                            angular.forEach(value, function(v,k){
                                fd.append('file['+k+']', v);
                            });
                        }else{
                            fd.append(key, value);
                        }
                    });
                    return fd;
                },
                headers: {'Content-Type':undefined, enctype:'multipart/form-data'}
            }
        }
    );

    // Promises
    $scope.promiseForm;
    $scope.entityID;
    $scope.entity = new Catalog();
    $scope.entity.active = true;

    /**
     * Form submit
     * @param form
     * @returns {boolean}
     */
    $scope.submit = function(form){

        $scope.submitted = true;
        if (form.$invalid) {
            return false;
        }

        if($scope.filesData.files.length > 0){

            if($scope.entity.type == 'pdf'){

                var flowFile = $scope.filesData.files[0];
                if(!_validatePDF(flowFile)){
                    return;
                }
                $scope.entity.file = flowFile.file;

            }else{
                $scope.entity.file = [];
                angular.forEach($scope.filesData.files, function(value, key){
                    $scope.entity.file.push(value.file);
                });
            }

        }else{
            if(!$scope.entity.id){
                inform.add("Por favor, inclua pelo menos um arquivo.", {type:"danger"});
                return false;
            }
        }

        var action = $scope.entity.id ? 'update' : 'create';
        $scope.sending = true;
        var currentType = $scope.type;
        $scope.promiseForm = $scope.entity.$save(function(data){

            $scope.sending = false;
            $scope.submitted = false;
            if(action == 'create'){
                $scope.entity = new Catalog();
                $scope.entity.active = true;
                $scope.entity.type = currentType;
                $scope.$flow.cancel();
            }
            inform.add("Catálogo salvo com sucesso!", {type:"success"});

        },function(err){

            $scope.sending = false;
            $scope.submitted = false;

        });

    };

    /**
     * Load Catalog entity
     * @param entityID
     */
    $scope.loadEntity = function(entityID){

        $scope.entityID = entityID;
        _loadEntity();

    };

    /**
     * Sortable options (edit gallery only)
     * @type {{update: Function, stop: Function}}
     */
    $scope.hasUpdatedOrder = false;
    $scope.sortableOptions = {
        update: function(e, ui) {
            $scope.hasUpdatedOrder = true;
        },
        stop: function(e, ui) {
            if($scope.hasUpdatedOrder){
                angular.forEach($scope.entity.catalog_images, function(value,key){
                    value.order = key + 1;
                });
                $scope.reorderCatalogImages();
            }
            $scope.hasUpdatedOrder = false;
        }
    };

    /**
     * Reorder images
     */
     $scope.reorderCatalogImages = function(){

        var params = [];
        angular.forEach($scope.entity.catalog_images, function(value,key){
            params.push({
                id: value.id,
                order: value.order
            });
            console.log(value.id + " - " + value.order);
        });

         $scope.promiseForm = $http({
            method: 'post',
            url: $urlService.to('/catalog/reorder-images'),
             data: $.param({images:params}),
            headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
        }).success(function (data, status, headers, config) {

            if(!data.success){
                inform.add(data.message, {type:"danger"});
            }

        });

    };

    /**
     * Files add handler
     * @param $files
     * @param $event
     * @param $flow
     */
    $scope.filesAddedHandler = function( $files, $event, $flow ){

        var ent = {
            file: [],
            catalog: $scope.entity.id
        };

        var message = '';
        angular.forEach($files, function(value, key){
            var size = (value.size/1024);
            if(value.file.type == 'image/jpeg' || value.file.type == 'image/jpg' || value.file.type == 'image/png'){
                if(size <= 1536){
                    ent.file.push(value.file);
                }else{
                    message += "\n'" + value.name + "': arquivo muito grande, o arquivo não pode ser maior que 1,5mb";
                }
            }else{
                message += "\n'" + value.name + "': tipo de arquivo não suportado";
            }
        });

        if(ent.file.length > 0){

            $scope.promiseForm = $http({
                method: 'post',
                url: $urlService.to('/catalog/add-images'),
                data: ent,
                transformRequest: function(data){
                    var fd = new FormData();
                    angular.forEach(data, function(value, key) {
                        if(key == "file" && angular.isArray(value)){
                            angular.forEach(value, function(v,k){
                                fd.append('file['+k+']', v);
                            });
                        }else{
                            fd.append(key, value);
                        }
                    });
                    return fd;
                },
                headers: {'Content-Type': undefined, enctype:'multipart/form-data'}
            }).success(function (data, status, headers, config) {

                if(!data.success){
                    inform.add(data.message, {type:"danger"});
                }
                _loadEntity();

            });

        }else{
            // inform.add("Um ou mais arquivos não possuem uma extensão válida.", {type:"danger"});
        }

        if(message.length > 0){
            inform.add(message, {type:"danger"});
        }

    };

    /**
     * Validate file PDF
     * @param $files
     * @param $event
     * @param $flow
     */
    $scope.validateFilePDF = function( $files, $event, $flow ){
        angular.forEach($files, function(value, key){
            _validatePDF(value);
        });
    };

    /**
     * Remove image
     * @param item
     */
    $scope.removeItem = function(item){

        $scope.promiseForm = CatalogImage.delete({id:item.id}, function(data){

            var index = $scope.entity.catalog_images.indexOf(item);
            if(index > -1){
                $scope.entity.catalog_images.splice(index,1);
            }

        }, function(err){

            console.log(err);

        }).$promise;

    };

    /**
     * (Re)load entity Catalog
     * @private
     */
    function _loadEntity(){
        $scope.promiseForm = Catalog.get({id:$scope.entityID}, function(ent) {
            $scope.entity = ent;
        }).$promise;
    };

    /**
     * Validate PDF file
     * @param value
     * @private
     */
    function _validatePDF(value){
        var returnData = true;
        var size = (value.size/1024);
        if(value.file.type != 'application/pdf'){
            value.cancel();
            inform.add('Tipo de arquivo inválido! Por favor, selecione um arquivo PDF válido.', {type: "danger"});
            returnData = false;
        }
        if(size > 493216){
            value.cancel();
            inform.add('Arquivo muito grande. O arquivo não pode ser maior que 5mb', {type: "danger"});
            returnData = false;
        }
        return returnData;
    }

}]);