/**
 * Catalog Controller
 */
angular.module('salestool').controller('CatalogCtrl',["$scope", "$http", "$urlService", "$resource", "DTOptionsBuilder", "DTColumnBuilder", "DTColumnDefBuilder", "$modal", "$resource",
    function($scope, $http, $urlService, $resource, DTOptionsBuilder, DTColumnBuilder, DTColumnDefBuilder, $modal, $resource){

    // Rest Entity
    var Catalog = $resource($urlService.rest('/catalog/:id'));

    // Promises
    $scope.promiseList;
    $scope.promiseForm;

    // Datatable
    $scope.dtOptions = DTOptionsBuilder.newOptions()
        .withPaginationType('full_numbers')
        .withOption('order', [[2, 'desc']])
        .withOption('processing', true)
        .withOption('fnRowCallback', function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
            var linkObj = $(aData[0]);
            var imgObj = linkObj.children('img');
            imgObj.prop('src', imgObj.attr('data-img-url'));
            imgObj.prop('width', '60');
            imgObj.prop('height', '60');
            linkObj.append(imgObj);
            $('td:eq(0)', nRow).html( linkObj.prop('outerHTML') );
        });

    $scope.dtColumnDefs = [
        DTColumnDefBuilder.newColumnDef(0),                 // id
        DTColumnDefBuilder.newColumnDef(1),                 // descricao
        DTColumnDefBuilder.newColumnDef(2),                 // created_at
        DTColumnDefBuilder.newColumnDef(3),                 // updated_at
        DTColumnDefBuilder.newColumnDef(4),                 // updated_at
        DTColumnDefBuilder.newColumnDef(5).notSortable()    // options
    ];

    /**
     * Delete entity
     * @param id
     */
    $scope.delete = function(obj){

        $scope.promiseList = Catalog.delete({id:obj.id}, function(data){

            $scope.loadList();

        }, function(err){

            console.log(err);

        }).$promise;

    };

    /**
     * Load datatable list
     */
    $scope.loadList = function(){

        // Get data
        $scope.loadingList = true;
        $scope.promiseList = Catalog.query(function(data){

            $scope.loadingList = false;
            $scope.list = data;

        }, function(err){

            console.log(err);

        }).$promise;

    }

    // Init
    $scope.loadList();

}]);