/**
 * Product Unit Controller
 */
angular.module('salestool').controller('CashierCtrl', ["$scope", "$http", "$urlService", "$resource", "DTOptionsBuilder", "DTColumnBuilder", "DTColumnDefBuilder", "$modal", "$resource", "store", function($scope, $http, $urlService, $resource, DTOptionsBuilder, DTColumnBuilder, DTColumnDefBuilder, $modal, $resource, store){

    // Map object
    $scope.map = {
        center: {
            latitude: 0,
            longitude: 0
        },
        zoom: 10
    };

    // Setup Modal
    $scope.modalMap = $modal({
        //animation:"am-fade-and-slide-top",
        animation:"am-slide-top",
        title:"Local em que o pedido foi feito",
        scope: $scope,
        template:'modal-map.html',
        show:false
    });

    // Show modal map
    $scope.mapMarkers = [];
    $scope.showModalMap = function(ent){
        if(ent){

            $scope.mapMarkers = []
            var marker = {
                id: ent.id,
                coords: {
                    latitude: ent.latitude,
                    longitude: ent.longitude
                },
                show: false,
                entityObj: ent
            };
            marker.onClick = function() {
                ret.show = !ret.show;
            };
            $scope.mapMarkers.push(marker);

        }else{
            if(!$scope.list || !$scope.list.length){
                alert("Nenhum pedido selecionado");
                return;
            }

            $scope.mapMarkers = [];
            angular.forEach($scope.list, function(value,key){
                var marker = {
                    id: value.id,
                    coords: {
                        latitude: value.latitude,
                        longitude: value.longitude
                    },
                    show: false,
                    entityObj: value
                };
                marker.onClick = function() {
                    ret.show = !ret.show;
                };
                $scope.mapMarkers.push(marker);
            });
        }
        //$scope.map.center.latitude  = ent.latitude;
        //$scope.map.center.longitude = ent.longitude;
        $scope.modalMap.show();
    };

    // Rest Entity
    var Order               = $resource($urlService.rest('/order/:id'));
    var Customer            = $resource($urlService.rest('/customer/:id'));
    var User                = $resource($urlService.rest('/user/:id'));
    var RepresentedCompany  = $resource($urlService.rest('/represented-company/:id'));
    var storage             = store.getNamespacedStore('Order');

    // Query Params
    $scope.params = {
        dateRange: {
            // startDate: (storage.get('startDate') ? storage.get('startDate') : moment().startOf('day').toDate()),
            // endDate: (storage.get('endDate') ? storage.get('endDate') : moment().endOf('day').toDate())
            startDate: moment().startOf('day').toDate(),
            endDate: moment().endOf('day').toDate()
        },
        dateField: 'orderDate',
        customer: null
    };

    // Promises
    $scope.promiseList;

    // Datatable
    $scope.dtOptions = DTOptionsBuilder.newOptions()
        .withPaginationType('full_numbers')
        .withOption('order', [[0, 'desc']])
        .withOption('processing', true);

    $scope.dtColumnDefs = [
        DTColumnDefBuilder.newColumnDef(0),
        DTColumnDefBuilder.newColumnDef(1),
        DTColumnDefBuilder.newColumnDef(2),
        DTColumnDefBuilder.newColumnDef(3),
        DTColumnDefBuilder.newColumnDef(4),
        DTColumnDefBuilder.newColumnDef(5),
        DTColumnDefBuilder.newColumnDef(6),
        DTColumnDefBuilder.newColumnDef(7),
        DTColumnDefBuilder.newColumnDef(8),
        DTColumnDefBuilder.newColumnDef(9),
        DTColumnDefBuilder.newColumnDef(10),
        DTColumnDefBuilder.newColumnDef(11).notSortable()
    ];

    /**
     * Load datatable list
     */
    $scope.totalSum = 0;
    $scope.loadList = function(){

        var qParams = {
            dateField: $scope.params.dateField,
            startDate: $scope.params.dateRange.startDate,
            endDate: $scope.params.dateRange.endDate,
            customer: ($scope.params.customer ? $scope.params.customer.id : null),
            user: ($scope.params.user ? $scope.params.user.id : null),
            status: $scope.params.status,
            representedCompany: $scope.params.representedCompany
        };

        // Set default date range
        // storage.set('startDate', $scope.params.dateRange.startDate);
        // storage.set('endDate', $scope.params.dateRange.endDate);

        // Get data
        $scope.loadingList = true;
        $scope.promiseList = Order.query(qParams, function(data){

            $scope.loadingList = false;
            $scope.list = data;

            var sum = 0;
            angular.forEach($scope.list, function(ent) {
                sum += ent.total;
            });
            $scope.totalSum = sum;

        }, function(err){

            console.log(err);

        }).$promise;

    };

    /**
     * Search customer
     * @type {Array}
     */
    $scope.listCustomers = [];
    $scope.getCustomers = function(queryString){

        if(queryString && queryString.length > 0){

            return Customer.query({query: queryString}, function(data){

                $scope.listCustomers = data;

            }, function(err){

                console.log(err);

            }).$promise;

        }

    };

    /**
     * Search user
     * @type {Array}
     */
    $scope.listUsers = [];
    $scope.getUsers = function(queryString){

        return User.query({query: queryString}, function(data){

            $scope.listUsers = data;

        }, function(err){

            console.log(err);

        }).$promise;

    };

    /**
     * List Represented Company for select
     */
    $scope.listRepresentedCompanies = RepresentedCompany.query();

    /**
     * URL Service
     */
    $scope.$urlService = $urlService;

    // Init
    $scope.loadList();

}]);