var GLOBAL_USER_ENTITY = {};

angular.module('salestool', [
    'ngAnimate',
    'ngRoute',
    'ngAnimate-animate.css',
    'ngFx',
    'stServices',
    'datatables',
    'ngResource',
    'mgcrea.ngStrap',
    'cgBusy',
    'ngBootbox',
    'flow',
    'ui.utils',
    'inform',
    //'ngNotificationsBar',
    'ngSanitize',
    'daterangepicker',
    'ui.select',
    'angular-storage',
    'xeditable',
    'ui.sortable',
    'smart-table',
    'uiGmapgoogle-maps',
    'ui.bootstrap.showErrors',
    'ui.utils.masks',
    'ngFileUpload',
    'ui.bootstrap.datetimepicker'
])

// Http intereceptor for errors
.factory("appHttpInterceptor", ["$q", "inform" ,function ($q, inform) {
    return {
        'response': function(response) {
            return response || $q.when(response);
        },
        'responseError': function(response) {
            var msg = response.data.message ? response.data.message : response.statusText;
            switch (response.status) {
                case 401:
                    inform.add("Ocorreu um erro ao executar a solicitação: " + msg, {type:"danger"});
                    break;
                case 403:
                    inform.add("Ocorreu um erro ao executar a solicitação: " + msg, {type:"danger"});
                    break;
                case 500:
                    inform.add("Ocorreu um erro ao executar a solicitação: " + msg, {type:"danger"});
                    break;
                default:
                    inform.add("Ocorreu um erro ao executar a solicitação: " + msg, {type:"danger"});
            }

            return $q.reject(response);
        }
    };
}])

.service('StringUtils', function(){

    return {
        isNumber: function(s){
            return !isNaN(parseFloat(s)) && isFinite(s);
        }
    };

})

//_app.config(function($interpolateProvider, $httpProvider, $resourceProvider, $routeProvider, $stateProvider, $urlRouterProvider){
.config(["$interpolateProvider", "$httpProvider", "$resourceProvider", "$routeProvider", "stConfig", "uiGmapGoogleMapApiProvider", function($interpolateProvider, $httpProvider, $resourceProvider, $routeProvider, stConfig, uiGmapGoogleMapApiProvider){

    uiGmapGoogleMapApiProvider.configure({
        china: false,
        //key: 'AIzaSyBaUx0TdLLwTGhLb8OhAp_FqLjpmB6HhWE',
        v: '3.20', //defaults to latest 3.X anyhow
        libraries: ''
    });
    stConfig.pagination.template = 'pagination.tpl.html';

    //$interpolateProvider.startSymbol('{[{').endSymbol('}]}'); // Alternative
    //$interpolateProvider.startSymbol('<%');
    //$interpolateProvider.endSymbol('%>');
    //$httpProvider.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded";

    $httpProvider.interceptors.push('appHttpInterceptor');

    var defaultTransition = {
        enter: 'slide-in-left-fade',
        leave: 'slide-out-right-fade',
        ease: 'sine',
        speed: 400
    };

    // ,'ui.router'
    /*
    $urlRouterProvider.otherwise('/dashboard');

    $stateProvider.
        state('dashboard', {
            url: "/dashboard",
            templateUrl: 'app/index/dashboard',
            controller: 'DashboardCtrl',
        }).
        state('unit', {
            url: "/unit",
            templateUrl: 'app/unit',
            controller: 'UnitCtrl',
        });
        */

    /*
    $routeProvider.
        when('/dashboard', {
            templateUrl: 'app/index/dashboard',
            controller: 'DashboardCtrl'
        }).
        when('/unit', {
            templateUrl: 'app/unit',
            controller: 'UnitCtrl'
        }).
        otherwise({
            redirectTo: '/dashboard'
        });
        */

}])

.factory('DTLoadingTemplate', function() {
    return {
        html: '<div align="center"><img src="'+_baseUrl+'/img/ring.gif"></div>'
    };
})

.value('cgBusyDefaults',{
    message:'Por favor, aguarde...',
    templateUrl: 'loading.tpl.html',
    backdrop: true
})

.run(["DTDefaultOptions", "$ngBootbox", "$rootScope", "editableOptions", function(DTDefaultOptions, $ngBootbox, $rootScope, editableOptions){

    $ngBootbox.setDefaults({
        locale: "pt"
    });

    $rootScope.isRouteLoading = false;

    $rootScope.$on('$routeChangeStart', function(){
        $rootScope.isRouteLoading = true;
    });

    $rootScope.$on('$routeChangeSuccess', function(){
        $rootScope.isRouteLoading = false;
    });

    // Translate for Datatables
    DTDefaultOptions.setLanguage({
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "Mostrando de _START_ até _END_ de _TOTAL_ registros",
            "sInfoEmpty": "Mostrando 0 até 0 de 0 registros",
            "sInfoFiltered": "(Filtrados de _MAX_ registros)",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_ resultados por página",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Pesquisar",
            "oPaginate": {
                "sNext": "Próximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "Último"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            }
        });

    editableOptions.theme = 'bs3';
    
}])

.directive('fileModel', ['$parse', function ($parse) {
    return {
        restrict: 'A',
        link: function(scope, element, attrs) {
            var model = $parse(attrs.fileModel);
            var modelSetter = model.assign;

            element.bind('change', function(){
                scope.$apply(function(){
                    modelSetter(scope, element[0].files[0]);
                });
            });
        }
    };
}])

.directive('repeatDone', function() {
    return function(scope, element, attrs) {
        if (scope.$last) {
            scope.$eval(attrs.repeatDone);
        }
    }
})

// Default date range picker
.value('dateRangePickerConfig', {
    format: 'DD/MM/YYYY',
    separator: ' até ',
    //opens: 'left',
    showDropdowns: true,
    showWeekNumbers: true,
    locale: {
        applyLabel: 'Aplicar',
        cancelLabel: 'Cancelar',
        fromLabel: 'De',
        toLabel: 'à',
        weekLabel: 'S',
        customRangeLabel: 'Customizado',
        daysOfWeek: ['S', 'T', 'Q', 'Q', 'S', 'S', 'D'],
        monthNames: ['Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho', 'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'],
        firstDay: 0
    },
    ranges: {
        'Hoje': [moment().startOf('day'), moment().endOf('day')],
        'Ontem': [moment().subtract(1,'days'), moment().subtract(1,'days')],
        'Últimos 7 Dias': [moment().subtract(6,'days'), moment()],
        'Últimos 30 Dias': [moment().subtract(29,'days'), moment()],
        'Este Mês': [moment().startOf('month'), moment().endOf('month')],
        'Último Mês': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
    }
});