define({ "api": [
  {
    "type": "post",
    "url": "/customer/send",
    "title": "Send",
    "name": "SendCustomer",
    "group": "Customer",
    "description": "<p>Insere um novo cliente</p> ",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "nome",
            "description": "<p>Nome ou Razão Fantasia do cliente</p> "
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "razaoSocial",
            "description": "<p>Razão social do cliente</p> "
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "documentoNacional",
            "description": "<p>Documento federal do cliente (CPF ou CNPJ)</p> "
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "documentoEstadual",
            "description": "<p>Documento estadual do cliente (IE ou RG)</p> "
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "email",
            "description": "<p>Email do cliente</p> "
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "cep",
            "description": "<p>CEP do cliente</p> "
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "endereco",
            "description": "<p>Logradouro</p> "
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "numero",
            "description": "<p>Número do endereço</p> "
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "bairro",
            "description": "<p>Bairro</p> "
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "complemento",
            "description": "<p>Complemento do endereço</p> "
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "estado",
            "description": "<p>Estado (UF)</p> "
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "cidade",
            "description": "<p>Cidade</p> "
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "tipo",
            "description": "<p>Tipo do cliente (pf ou pj)</p> "
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "telefonePrincipal",
            "description": "<p>Telefone principal</p> "
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "telefoneSecundario",
            "description": "<p>Telefone secundário</p> "
          },
          {
            "group": "Parameter",
            "type": "Number",
            "optional": false,
            "field": "latitude",
            "description": "<p>Latitude (localização)</p> "
          },
          {
            "group": "Parameter",
            "type": "Number",
            "optional": false,
            "field": "longitude",
            "description": "<p>Longitude (localização)</p> "
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "success",
            "description": "<p>Indica se o registro foi inserido corretamente</p> "
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "id",
            "description": "<p>ID do cliente inserido</p> "
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n[\n    {\n        \"success\": true,\n        \"id\": 1,\n    }\n]",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "HTTP/1.1 404 Not Found\n{\n    \"error\": true,\n    \"message\": \"NotFound\"\n}",
          "type": "json"
        }
      ]
    },
    "version": "0.0.0",
    "filename": "module/API/src/API/Controller/CustomerController.php",
    "groupTitle": "Customer"
  },
  {
    "type": "get",
    "url": "/data/config",
    "title": "Config",
    "name": "GetConfig",
    "group": "Data",
    "description": "<p>Retorna os parâmetros e configurações da aplicação.</p> ",
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "maxDiscount",
            "description": "<p>Desconto máximo permitido na aplicação</p> "
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n    \"maxDiscount\": 2.00,\n}",
          "type": "json"
        }
      ]
    },
    "error": {
      "fields": {
        "Error 4xx": [
          {
            "group": "Error 4xx",
            "optional": false,
            "field": "NotFound",
            "description": "<p>Caso algum erro ocorra na comunicação</p> "
          }
        ]
      },
      "examples": [
        {
          "title": "Error-Response:",
          "content": "HTTP/1.1 404 Not Found\n{\n    \"error\": true,\n    \"message\": \"NotFound\"\n}",
          "type": "json"
        }
      ]
    },
    "version": "0.0.0",
    "filename": "module/API/src/API/Controller/DataController.php",
    "groupTitle": "Data"
  },
  {
    "type": "get",
    "url": "/data/customer",
    "title": "Customer",
    "name": "GetCustomer",
    "group": "Data",
    "description": "<p>Retorna a lista de clientes cadastrados.</p> ",
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "id",
            "description": "<p>Id do cliente</p> "
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "name",
            "description": "<p>Nome ou Nome fantasia do cliente</p> "
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "companyName",
            "description": "<p>Razão Social do cliente</p> "
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "documentNumber",
            "description": "<p>CNPJ/CPF do cliente</p> "
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "secondaryDocumentNumber",
            "description": "<p>Documento secundário (IE ou RG para clientes Brasileiros)</p> "
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "zip",
            "description": "<p>Código postal (CEP)</p> "
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "address",
            "description": "<p>Logradouro do cliente</p> "
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "addressNumber",
            "description": "<p>Número do endereço</p> "
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "neighbourhood",
            "description": "<p>Bairro</p> "
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "addressComplement",
            "description": "<p>Complemento</p> "
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "state",
            "description": "<p>Estado</p> "
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "city",
            "description": "<p>Cidade</p> "
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "phonePrimary",
            "description": "<p>Telefone principal</p> "
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "phoneSecundary",
            "description": "<p>Telefone secundário</p> "
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "website",
            "description": "<p>Website</p> "
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "email",
            "description": "<p>E-mail do cliente</p> "
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "longitude",
            "description": "<p>Longitude</p> "
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "latitude",
            "description": "<p>Latitude</p> "
          },
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "active",
            "description": "<p>Indica se o usuário está ativo ou não</p> "
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "customerType",
            "description": "<p>Tipo de cliente (pj = pessoa jurídica / pf = pessoa fisíca)</p> "
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "info",
            "description": "<p>Observações</p> "
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "created",
            "description": "<p>Data de criação</p> "
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "updated",
            "description": "<p>Data da última atualização</p> "
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n[\n    {\n        \"id\": 1,\n        \"name\": \"LOS POLLOS HERMANOS\",\n        \"companyName\": \"LOS POLLOS HERMANOS INC.\",\n        \"documentNumber\":\"12.345.678/00001-01\",\n        \"secondaryDocumentNumber\": \"12345678\",\n        \"zip\": \"12345-000\",\n        \"address\": \"Isleta Blvd. SW\",\n        \"addressNumber\": \"123\",\n        \"neighbourhood\": \"\",\n        \"addressComplement\": \"Complement\",\n        \"state\": \"NM\",\n        \"city\": \"Albuquerque\",\n        \"phonePrimary\": \"(44) 1234-1122\",\n        \"phoneSecundary\": \"(44) 1234-1122\",\n        \"website\": \"http://www.lospolloshermanos.com\",\n        \"email\": \"gus@lospolloshermanos.com\",\n        \"longitude\": 35.014781,\n        \"latitude\": -106.686399,\n        \"active\": true,\n        \"customerType\": \"pj\",\n        \"info\": \"\",\n        \"created\": {\n            \"data\": \"2010-11-13 00:00:00\",\n            \"timezone_type\": 3,\n            \"timezone\": \"America/Sao_Paulo\"\n        },\n        \"updated\": null\n    }\n]",
          "type": "json"
        }
      ]
    },
    "version": "0.0.0",
    "filename": "module/API/src/API/Controller/DataController.php",
    "groupTitle": "Data",
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "HTTP/1.1 404 Not Found\n{\n    \"error\": true,\n    \"message\": \"NotFound\"\n}",
          "type": "json"
        }
      ]
    }
  },
  {
    "type": "get",
    "url": "/data/group",
    "title": "Group",
    "name": "GetGroups",
    "group": "Data",
    "description": "<p>Retorna a lista dos grupos primários de produtos cadastros</p> ",
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "id",
            "description": "<p>ID do grupo</p> "
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "description",
            "description": "<p>Descrição/Nome do grupo</p> "
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "created",
            "description": "<p>Data de criação</p> "
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "updated",
            "description": "<p>Data da última atualização</p> "
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n[\n    {\n        id: 11,\n        description: \"ACHOCOLATADOS\",\n        id_group: null,\n        created: {\n            date: \"2015-02-23 08:24:47\",\n            timezone_type: 3,\n            timezone: \"Europe/Berlin\"\n        },\n        updated: null\n    },\n    {\n        id: 12,\n        description: \"ÁGUA\",\n        id_group: null,\n        created: {\n            date: \"2015-02-23 08:24:47\",\n            timezone_type: 3,\n            timezone: \"Europe/Berlin\"\n        },\n        updated: null\n    }\n]",
          "type": "json"
        }
      ]
    },
    "version": "0.0.0",
    "filename": "module/API/src/API/Controller/DataController.php",
    "groupTitle": "Data",
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "HTTP/1.1 404 Not Found\n{\n    \"error\": true,\n    \"message\": \"NotFound\"\n}",
          "type": "json"
        }
      ]
    }
  },
  {
    "type": "get",
    "url": "/data/product",
    "title": "Product",
    "name": "GetProduct",
    "group": "Data",
    "description": "<p>Retorna a lista de produtos cadastrados.</p> ",
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "id",
            "description": "<p>Id do produto</p> "
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "name",
            "description": "<p>Nome do produto</p> "
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "reference",
            "description": "<p>Referência do produto</p> "
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "description",
            "description": "<p>Descrição do produto</p> "
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "barcode",
            "description": "<p>Código de barras</p> "
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "info",
            "description": "<p>Observações</p> "
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "unit",
            "description": "<p>Unidade de Medida</p> "
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "price",
            "description": "<p>Preço</p> "
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "priceMin",
            "description": "<p>Preço Mínimo</p> "
          },
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "active",
            "description": "<p>Indica se o produto está ou não ativo</p> "
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "created",
            "description": "<p>Data de criação</p> "
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "updated",
            "description": "<p>Data da última atualização</p> "
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n[\n    {\n        \"id\": 1,\n        \"name\": \"Product Name\",\n        \"reference\": \"PRO00001\",\n        \"description\": \"This is a description for product\",\n        \"barcode\": \"2000000058214\",\n        \"info\": \"Another relevant info\",\n        \"unit\": \"UN\",\n        \"groupPrimary\": 1,\n        \"groupSecondary\": 2,\n        \"price\": 15,\n        \"priceMin\": 12.98,\n        \"active\": true,\n        \"created\": {\n            \"data\": \"2010-11-13 00:00:00\",\n            \"timezone_type\": 3,\n            \"timezone\": \"America/Sao_Paulo\"\n        },\n        \"updated\": null\n    }\n]",
          "type": "json"
        }
      ]
    },
    "version": "0.0.0",
    "filename": "module/API/src/API/Controller/DataController.php",
    "groupTitle": "Data",
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "HTTP/1.1 404 Not Found\n{\n    \"error\": true,\n    \"message\": \"NotFound\"\n}",
          "type": "json"
        }
      ]
    }
  },
  {
    "type": "get",
    "url": "/data/product-image/:id",
    "title": "Product Image",
    "name": "GetProductImage",
    "group": "Data",
    "description": "<p>Retorna a imagem de um produto</p> ",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "Number",
            "optional": false,
            "field": "id",
            "description": "<p>ID do produto</p> "
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{binary file}",
          "type": "binary"
        }
      ]
    },
    "error": {
      "fields": {
        "Error 4xx": [
          {
            "group": "Error 4xx",
            "optional": false,
            "field": "NotFound",
            "description": "<p>Caso a imagem não seja encontrada</p> "
          }
        ]
      },
      "examples": [
        {
          "title": "Error-Response:",
          "content": "HTTP/1.1 404 Not Found\n{\n    \"error\": true,\n    \"message\": \"NotFound\"\n}",
          "type": "json"
        }
      ]
    },
    "version": "0.0.0",
    "filename": "module/API/src/API/Controller/DataController.php",
    "groupTitle": "Data"
  },
  {
    "type": "post",
    "url": "/data/stock",
    "title": "Stock",
    "name": "GetStock",
    "group": "Data",
    "description": "<p>Retorna as quantidades de um produto em um determinado estoque</p> ",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "Number",
            "optional": false,
            "field": "id",
            "description": "<p>ID do estoque</p> "
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "amount",
            "description": "<p>Quantidade</p> "
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "product_id",
            "description": "<p>ID do produto</p> "
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "warehouse_id",
            "description": "<p>ID do estoque (depósito)</p> "
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "created",
            "description": "<p>Data de criação</p> "
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "updated",
            "description": "<p>Data da última atualização</p> "
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n[\n    {\n        \"amount\": 10,\n        \"product_id\": 1,\n        \"warehouse_id\": 1,\n        \"created\": {\n            \"data\": \"2010-11-13 00:00:00\",\n            \"timezone_type\": 3,\n            \"timezone\": \"America/Sao_Paulo\"\n        },\n        \"updated\": null\n    }\n]",
          "type": "json"
        }
      ]
    },
    "version": "0.0.0",
    "filename": "module/API/src/API/Controller/DataController.php",
    "groupTitle": "Data",
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "HTTP/1.1 404 Not Found\n{\n    \"error\": true,\n    \"message\": \"NotFound\"\n}",
          "type": "json"
        }
      ]
    }
  },
  {
    "type": "get",
    "url": "/data/user",
    "title": "User",
    "name": "GetUser",
    "group": "Data",
    "description": "<p>Retorna a lista de usuários cadastrados para acesso no tablet</p> ",
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "id",
            "description": "<p>Id do usuário</p> "
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "name",
            "description": "<p>Nome do usuário</p> "
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "email",
            "description": "<p>E-mail do usuário</p> "
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "username",
            "description": "<p>Nome de usuário</p> "
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "password",
            "description": "<p>Senha (hash)</p> "
          },
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "active",
            "description": "<p>Indica se o usuário está ativo</p> "
          },
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "admin",
            "description": "<p>Indica se o usuário é administrador</p> "
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "sellerId",
            "description": "<p>Campo utilizado em integrações para vincular um código de vendedor (ERP) ao usuário</p> "
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "created",
            "description": "<p>Data de criação</p> "
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "updated",
            "description": "<p>Data da última atualização</p> "
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n[\n    {\n        \"id\": 1,\n        \"name\": \"Walter White\",\n        \"email\": \"me@savewalterwhite.com\",\n        \"username\": \"heisenberg\",\n        \"password\": \"$2y$10$5HuY8E9RqqRvnAIdZL12093RUGg3GmlJkQxlIW3Ql1a3F6MALKKc3y\",\n        \"active\": true,\n        \"admin\": true,\n        \"sellerId\": null,\n        \"created\": {\n            \"data\": \"2010-11-13 00:00:00\",\n            \"timezone_type\": 3,\n            \"timezone\": \"America/Sao_Paulo\"\n        },\n        \"updated\": null\n    }\n]",
          "type": "json"
        }
      ]
    },
    "version": "0.0.0",
    "filename": "module/API/src/API/Controller/DataController.php",
    "groupTitle": "Data",
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "HTTP/1.1 404 Not Found\n{\n    \"error\": true,\n    \"message\": \"NotFound\"\n}",
          "type": "json"
        }
      ]
    }
  },
  {
    "type": "post",
    "url": "/order/send",
    "title": "Send",
    "name": "SendOrder",
    "group": "Order",
    "description": "<p>Envia um pedido</p> ",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "dataPedido",
            "description": "<p>Data do pedido (dd/mm/yyyy HH:ii)</p> "
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "tipo",
            "description": "<p>Tipo do pedido (p = pedido / v = venda (Pronta Entrega))</p> "
          },
          {
            "group": "Parameter",
            "type": "Number",
            "optional": false,
            "field": "usuario",
            "description": "<p>ID do usuário</p> "
          },
          {
            "group": "Parameter",
            "type": "Number",
            "optional": false,
            "field": "estoque",
            "description": "<p>ID do estoque (warehouse)</p> "
          },
          {
            "group": "Parameter",
            "type": "Number",
            "optional": false,
            "field": "subtotal",
            "description": "<p>Subtotal</p> "
          },
          {
            "group": "Parameter",
            "type": "Number",
            "optional": false,
            "field": "desconto",
            "description": "<p>Valor do desconto</p> "
          },
          {
            "group": "Parameter",
            "type": "Number",
            "optional": false,
            "field": "total",
            "description": "<p>Total do pedido</p> "
          },
          {
            "group": "Parameter",
            "type": "Number",
            "optional": false,
            "field": "obs",
            "description": "<p>Observações do pedido</p> "
          },
          {
            "group": "Parameter",
            "type": "Object",
            "optional": false,
            "field": "cliente",
            "description": "<p>Cliente (Caso o cliente exista na base dados apenas o id é enviado)</p> "
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "cliente.nome",
            "description": "<p>Nome ou Razão Fantasia do cliente</p> "
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "cliente.razaoSocial",
            "description": "<p>Razão social do cliente</p> "
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "cliente.documentoNacional",
            "description": "<p>Documento federal do cliente (CPF ou CNPJ)</p> "
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "cliente.documentoEstadual",
            "description": "<p>Documento estadual do cliente (IE ou RG)</p> "
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "cliente.email",
            "description": "<p>Email do cliente</p> "
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "cliente.cep",
            "description": "<p>CEP do cliente</p> "
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "cliente.endereco",
            "description": "<p>Logradouro</p> "
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "cliente.numero",
            "description": "<p>Número do endereço</p> "
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "cliente.bairro",
            "description": "<p>Bairro</p> "
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "cliente.complemento",
            "description": "<p>Complemento do endereço</p> "
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "cliente.estado",
            "description": "<p>Estado (UF)</p> "
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "cliente.cidade",
            "description": "<p>Cidade</p> "
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "cliente.tipo",
            "description": "<p>Tipo do cliente (pf ou pj)</p> "
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "cliente.telefonePrincipal",
            "description": "<p>Telefone principal</p> "
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "cliente.telefoneSecundario",
            "description": "<p>Telefone secundário</p> "
          },
          {
            "group": "Parameter",
            "type": "Number",
            "optional": false,
            "field": "cliente.latitude",
            "description": "<p>Latitude (localização)</p> "
          },
          {
            "group": "Parameter",
            "type": "Number",
            "optional": false,
            "field": "cliente.longitude",
            "description": "<p>Longitude (localização)</p> "
          },
          {
            "group": "Parameter",
            "type": "Object[]",
            "optional": false,
            "field": "produtos",
            "description": "<p>Lista de produtos</p> "
          },
          {
            "group": "Parameter",
            "type": "Number",
            "optional": false,
            "field": "produtos.codigo",
            "description": "<p>Código do produto</p> "
          },
          {
            "group": "Parameter",
            "type": "Number",
            "optional": false,
            "field": "produtos.quantidade",
            "description": "<p>Quantidade do produto</p> "
          },
          {
            "group": "Parameter",
            "type": "Number",
            "optional": false,
            "field": "produtos.preco",
            "description": "<p>Preço do produto</p> "
          },
          {
            "group": "Parameter",
            "type": "Number",
            "optional": false,
            "field": "produtos.subtotal",
            "description": "<p>Subtotal</p> "
          },
          {
            "group": "Parameter",
            "type": "Number",
            "optional": false,
            "field": "produtos.desconto",
            "description": "<p>Valor de desconto</p> "
          },
          {
            "group": "Parameter",
            "type": "Number",
            "optional": false,
            "field": "produtos.total",
            "description": "<p>Total</p> "
          }
        ]
      }
    },
    "header": {
      "examples": [
        {
          "title": "Content-Type:",
          "content": "{\n  \"Content-Type\": \"Content-Type: application/json; charset=utf-8\"\n}",
          "type": "json"
        }
      ]
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "success",
            "description": "<p>Indica se o registro foi inserido corretamente</p> "
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "id",
            "description": "<p>ID do pedido inserido</p> "
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "customerId",
            "description": "<p>ID do cliente inserido</p> "
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n[\n    {\n        \"success\": true,\n        \"id\": 1,\n        \"customerId\": 1\n    }\n]",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "HTTP/1.1 404 Not Found\n{\n    \"error\": true,\n    \"message\": \"NotFound\"\n}",
          "type": "json"
        }
      ]
    },
    "version": "0.0.0",
    "filename": "module/API/src/API/Controller/OrderController.php",
    "groupTitle": "Order"
  },
  {
    "type": "post",
    "url": "/user/auth",
    "title": "Auth",
    "name": "AuthUser",
    "group": "User",
    "description": "<p>Autentica o usuário</p> ",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "username",
            "description": "<p>Nome de usuário</p> "
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "password",
            "description": "<p>Senha</p> "
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "success",
            "description": "<p>Indica se o registro foi inserido corretamente</p> "
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "id",
            "description": "<p>ID do cliente inserido</p> "
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n[\n    {\n        \"success\": true,\n        \"data\": {\n            \"id\": 1,\n            \"name\": \"Walter White\",\n            \"email\": \"me@savewalterwhite.com\",\n            \"username\": \"heisenberg\",\n            \"password\": \"$2y$10$5HuY8E9RqqRvnAIdZL12093RUGg3GmlJkQxlIW3Ql1a3F6MALKKc3y\",\n            \"active\": true,\n            \"admin\": true,\n            \"sellerId\": null,\n            \"created\": {\n                \"data\": \"2010-11-13 00:00:00\",\n                \"timezone_type\": 3,\n                \"timezone\": \"America/Sao_Paulo\"\n            },\n            \"updated\": null\n        }\n    }\n]",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "HTTP/1.1 404 Not Found\n{\n    \"error\": true,\n    \"message\": \"NotFound\"\n}",
          "type": "json"
        }
      ]
    },
    "version": "0.0.0",
    "filename": "module/API/src/API/Controller/UserController.php",
    "groupTitle": "User"
  }
] });