// Override jquery validate plugin defaults
$.validator.setDefaults({
    highlight: function(element) {
        $(element).closest('.form-group').addClass('has-error');
        //$('#emptyErrorAlert').slideDown();
    },
    unhighlight: function(element) {
        $(element).closest('.form-group').removeClass('has-error');
        //$('#emptyErrorAlert').slideUp();
    },
    errorElement: 'span',
    errorClass: 'help-block text-center',
    errorPlacement: function(error, element) {
        //$('#emptyErrorAlert').html(error);
        if(element.parent('.input-group').length) {
            error.insertAfter(element.parent());
        } else {
            error.insertAfter(element);
        }
    }
});

// Init
$(document).ready(function(){
   
    $('#form-signin').validate({
        rules:{
            username:{
                required:true,
            },
            password:{
                required:true,
            },
        },
        messages:{
            username: {
                required: "Informe um usuário válido",
            },
            password: {
                required: "Informe uma senha válida",
            }
        }
    });
    $('.form-validate').validate({
        rules:{
            senhaconfirm:{
                required:true,
                equalTo:"#password",
            },
        },
        messages:{
            senhaconfirm: {
                equalTo: "Os valores não conferem. Forneça a mesma senha novamente.",
            }
        }
    });
    
});