com.gestaoconex.Validator = (function() {

    var _remove = function(str, sub) {
        i = str.indexOf(sub);
        r = "";
        if (i == -1)
            return str;
        r += str.substring(0, i) + _remove(str.substring(i + sub.length), sub);
        return r;
    }

    return {
        cnpj: function(valor) {
            CNPJ = valor;
            erro = new String;
            if (CNPJ.length < 14)
                erro += "É necessario preencher corretamente o numero do CNPJ! \n\n";
            /*
            if ((CNPJ.charAt(2) != ".") || (CNPJ.charAt(6) != ".") || (CNPJ.charAt(10) != "/") || (CNPJ.charAt(15) != "-")) {
                if (erro.length == 0)
                    erro += "É necessarios preencher corretamente o numero do CNPJ! \n\n";
            }
            */
           
            //substituir os caracteres que nao sao numeros
            if (document.layers && parseInt(navigator.appVersion) == 4) {
                x = CNPJ.substring(0, 2);
                x += CNPJ.substring(3, 6);
                x += CNPJ.substring(7, 10);
                x += CNPJ.substring(11, 15);
                x += CNPJ.substring(16, 18);
                CNPJ = x;
            } else {
                CNPJ = CNPJ.replace(".", "");
                CNPJ = CNPJ.replace(".", "");
                CNPJ = CNPJ.replace("-", "");
                CNPJ = CNPJ.replace("/", "");
            }
            var nonNumbers = /\D/;
            if (nonNumbers.test(CNPJ))
                erro += "A verificacao de CNPJ suporta apenas numeros! \n\n";
            var a = [];
            var b = new Number;
            var c = [6, 5, 4, 3, 2, 9, 8, 7, 6, 5, 4, 3, 2];
            for (i = 0; i < 12; i++) {
                a[i] = CNPJ.charAt(i);
                b += a[i] * c[i + 1];
            }
            if ((x = b % 11) < 2) {
                a[12] = 0
            } else {
                a[12] = 11 - x
            }
            b = 0;
            for (y = 0; y < 13; y++) {
                b += (a[y] * c[y]);
            }
            if ((x = b % 11) < 2) {
                a[13] = 0;
            } else {
                a[13] = 11 - x;
            }
            if ((CNPJ.charAt(12) != a[12]) || (CNPJ.charAt(13) != a[13])) {
                erro += "Digito verificador com problema!";
            }
            if (erro.length > 0) {
                console.log(erro);
                return false;
            } else {
                // alert("CNPJ valido!");
            }
            return true;

        },
        cpf: function(value) {

            var cpf = value;
            
            cpf = _remove(cpf, ".");
            cpf = _remove(cpf, "-");

            if (cpf.length != 11 || cpf == "00000000000" || cpf == "11111111111" ||
                    cpf == "22222222222" || cpf == "33333333333" || cpf == "44444444444" ||
                    cpf == "55555555555" || cpf == "66666666666" || cpf == "77777777777" ||
                    cpf == "88888888888" || cpf == "99999999999") {

                return false;

            }

            soma = 0;

            for (i = 0; i < 9; i++)
                soma += parseInt(cpf.charAt(i)) * (10 - i);

            resto = 11 - (soma % 11);

            if (resto == 10 || resto == 11)
                resto = 0;
            if (resto != parseInt(cpf.charAt(9))) {
                return false;
            }

            soma = 0;
            for (i = 0; i < 10; i ++)
                soma += parseInt(cpf.charAt(i)) * (11 - i);

            resto = 11 - (soma % 11);
            if (resto == 10 || resto == 11)
                resto = 0;

            if (resto != parseInt(cpf.charAt(10))) {
                return false;
            }

            return true;

        },
        email: function(mail)
        {
            var er = new RegExp(/^[A-Za-z0-9_\-\.]+@[A-Za-z0-9_\-\.]{2,}\.[A-Za-z0-9]{2,}(\.[A-Za-z0-9])?/);
            if (typeof(mail) == "string") {
                if (er.test(mail)) {
                    return true;
                }
            } else if (typeof(mail) == "object") {
                if (er.test(mail.value)) {
                    return true;
                }
            } else {
                return false;
            }
        }
    }

});