// Fix for conflict between JQuery.UI and Bootstrap Tooltip
$.widget.bridge('uitooltip', $.ui.tooltip);
$.widget.bridge('uibutton', $.ui.button);
// $.widget.bridge('uitooltip', $.ui.tooltip);

var $datatable = null;

// Initialization
$(document).ready(function(){
   
   $( ".form-validate" ).validate(
           /* Example Rules
            {
                 rules: {
                     email:{
                         email: true
                     },
                     passwordconfirm: {
                         equalTo: "#password"
                     },
                     cnpj:{
                         cnpj:true // Custom function to validate cnpj
                     },
                     cpf:{
                         cpf:true // Custom function to validate cpf
                     }

                 }
             }
             */
    );
    
    $('.select2').select2();
    
    
//    $('.datatable thead th').each( function () {
//        var title = $('#example tfoot th').eq( $(this).index() ).text();
//        $(this).html( '<input type="text" class="form-control" style="width:auto" placeholder="Buscar '+title+'" />' );
//    } );
    
    $datatable = $('.datatable').DataTable({
        /*
        initComplete: function(){
            var r = $('.datatable tfoot tr');
            r.find('th').each(function() {
                $(this).css('padding', 8);
            });
            $('.datatable thead').append(r);
            $('#search_0').css('text-align', 'center');
        },*/
        "language":{
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "Mostrando de _START_ até _END_ de _TOTAL_ registros",
            "sInfoEmpty": "Mostrando 0 até 0 de 0 registros",
            "sInfoFiltered": "(Filtrados de _MAX_ registros)",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_ resultados por página",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Pesquisar",
            "oPaginate": {
                "sNext": "Próximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "Último"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            }
        }
    });
 
//    table.columns().eq( 0 ).each( function ( colIdx ) {
//        $( 'input', table.column( colIdx ).header() ).on( 'keyup change', function () {
//            table
//                .column( colIdx )
//                .search( this.value )
//                .draw();
//        } );
//    } );
    
    $(".fancybox").fancybox({
        type: 'image',
        openEffect: 'fade',
        closeEffect: 'fade',
        helpers: {
            media: {}
        }
    });
    
    $(".date-picker").datepicker({
        format: "dd/mm/yyyy",
        language: "pt-BR"
    });
    
    $(".date-time-picker").datetimepicker({
        format: "dd/mm/yyyy",
        timeFormat: "HH:mm",
        language: "pt-BR"
    });
    
    tinymce.init({
        selector: ".tinymce",
        convert_urls: false,
        relative_urls: false,
        plugins:["code fullscreen paste table image media"]
     });
     
    createMasks();
    
    $(function() {
        $("[data-toggle='tooltip']").tooltip();
        $('[data-toggle="popover"]').popover()
     });

    function createMasks(){
        $('.mask-number').mask('000000');
        //$('.mask-number').mask('0#');
        $('.mask-phone').mask('(00) 9999-99999');
        $(".mask-date").mask('##/##/####');
        $('.mask-datetime').mask('00/00/0000 00:00');
        $('.mask-cep').mask('#####-###');
        $('.mask-cpf').mask('000.000.000-00', {reverse: false});
        $('.mask-cnpj').mask('00.000.000/0000-00');
        $('.mask-money').mask("#.##0,00", {reverse: true, maxlength: false});
        //$('.mask-money').mask("###0.00", {reverse: true, maxlength: false});
    }
    
});

function _stringToFloat(str){
    if(str.indexOf(".") != -1){
        str = str.replace(/\./g, '');
        str = str.replace(",", '.');
    }
    return parseFloat(str.replace(",", '.'));
}

function _floatToString(valor){
    return valor.toFixed(2).toString().replace(".", ",");
}

// Noty

var _noty = {
    
    defaultOptions: {
        layout: 'topCenter',
        //theme: 'defaultTheme',
        timeout: 4000,
        animation: {
            open: {height: 'toggle'},
            close: {height: 'toggle'},
            easing: 'swing',
            speed: 500
        }
    },
    
    show: function(msg, type){
        var opts = _noty.defaultOptions;
        opts.type = type;
        opts.text = msg;
        return noty(opts);
    },
    
    success: function(msg){
        return _noty.show(msg, 'success');
    },
    
    alert: function(msg){
        return _noty.show(msg, 'alert');
    },
    
    error: function(msg){
        return _noty.show(msg, 'error');
    },
    
    warning: function(msg){
        return _noty.show(msg, 'warning');
    },
    
    information: function(msg){
        return _noty.show(msg, 'information');
    }
    
};

// Services

var _services = {
    
    getAddress: function(cep, success){
        return $.post(_baseUrl + '/app/services-location/get-address', {cep:cep}, success).fail(function(data, textStatus, errorThrown){
            _noty.error("Ocorreu um erro ao buscar o cep, por favor, tente novamente mais tarde. Err: " + textStatus + " (" + errorThrown + ")");
        });
    },

    /**
     *
     * @param address|addressNumber|zip|city
     * @returns {*}
     */
    getCoordinates: function(params, success){
        return $.post(_baseUrl + '/app/services-location/get-coordinates', params, success).fail(function(data, textStatus, errorThrown){
            _noty.error("Ocorreu um erro ao buscar a localização, por favor, tente novamente mais tarde. Err: " + textStatus + " (" + errorThrown + ")");
        });
    }
    
};