var map;
var markersArray = [];
var _userLocation;
var _defaultMarker;
var _directionsRenderer;
var _directionsService;
var _defaultLocation = new google.maps.LatLng(-23.421457, -51.936791); // Maringa

/**
 * Initialize maps
 */
function initialize() {

    var mapOptions = {
        zoom: 14,
        center: _defaultLocation,
        disableDefaultUI: false
    }

    map = new google.maps.Map(document.getElementById('mapCanvas'), mapOptions);

    // Directions
    _directionsRenderer = new google.maps.DirectionsRenderer( {'draggable':true} );
    _directionsRenderer.setMap(map);
    _directionsRenderer.setPanel(document.getElementById("directionsPanel"));
    _directionsService = new google.maps.DirectionsService();

    var lat = $('input[name=latitude]').val();
    var lon = $('input[name=longitude]').val();
    if(lat && lon){
        var location = new google.maps.LatLng(lat, lon);
        addMarker(location);
        map.setCenter(location);
    }

    /*
     var image = 'imagens/pin-mapa.png';
     var myLatLng = _shoppingLocation;
     var beachMarker = new google.maps.Marker({
     position: myLatLng,
     map: map,
     icon: image
     });
     */

}
google.maps.event.addDomListener(window, 'load', initialize);

function getCoordinates(){

    if(!$('input[name=address]').val() || !$('input[name=city]').val()){
        _noty.error("Forneça o logradouro e cidade para buscar a localização");
        return;
    }

    var params = {
        address: $('input[name=address]').val(),
        addressNumber: $('input[name=addressNumber]').val(),
        city: $('input[name=city]').val(),
        zip: $('input[name=zip]').val()
    };

    _services.getCoordinates(params,function(res){
        if(res.data){

            var coord = res.data;
            $('input[name=latitude]').val(coord.latitude);
            $('input[name=longitude]').val(coord.longitude);

            var latlng = new google.maps.LatLng(coord.latitude, coord.longitude);
            addMarker(latlng);
            map.setCenter(latlng);

        }
    });

}

function refreshLocation(){

    if(!$('input[name=latitude]').val() || !$('input[name=longitude]').val()){
        _noty.error("Forneça a latitude e longitude para atualizar a localização");
        return;
    }

    removeDefaultMarker();
    var location = new google.maps.LatLng($('input[name=latitude]').val(), $('input[name=longitude]').val());
    addMarker(location);
}

function addMarker(latlng){
    removeDefaultMarker();
    _defaultMarker = new google.maps.Marker({
        position: latlng,
        map: map
    });
}

/**
 * Trace Route
 * @private
 */
function _traceRoute(){

    _directionsService.route({
            'origin': _shoppingLocation,
            'destination':  _defaultMarker.getPosition(),
            'travelMode': google.maps.DirectionsTravelMode.DRIVING},
        function(res,sts) {
            if(sts=='OK')_directionsRenderer.setDirections(res);
        }
    );
}

/**
 * Remove user marker
 * @private
 */
function removeDefaultMarker(){
    if(_defaultMarker){
        _defaultMarker.setMap(null);
    }
}