<?php

/**
 * Represented Company restful controller
 * @author Renato Peterman <renato.pet@gmail.com>
 */

namespace Rest\Controller;

use API\Exceptions\ApiBadRequestException;
use API\Exceptions\ApiException;
use API\Exceptions\ApiNotFoundException;
use Doctrine\ORM\Query;
use Zend\View\Model\JsonModel;
use DoctrineModule\Stdlib\Hydrator\DoctrineObject as DoctrineHydrator;

class UserRepresentedCompanyController extends AbstractApplicationRestfulController {

    /**
     * Get entity list
     * @return mixed|JsonModel
     * @override
     */
    public function getList()
    {
        try{

            $qb = $this->getEntityManager()->createQueryBuilder()
                ->select('obj')
                ->from($this->getEntityClass(),'obj');

            $userID = $this->params()->fromQuery('user', false);
            if($userID){
                $user = $this->getEntityManager()->find("Model\\Entity\\User", $userID);
                if($user){
                    $qb->andWhere("obj.user = :user");
                    $qb->setParameter("user", $user);
                }
            }

            return $this->createResponse($qb);

        }catch (ApiException $ex){

            return $this->createApiExceptionResponse($ex);

        }catch (\Exception $ex){

            return $this->createGenericApiExceptionResponse($ex);

        }

        return $this->createResponse($qb);
    }

}