<?php

/**
 * User location restful controller
 * @author Renato Peterman <renato.pet@gmail.com>
 */

namespace Rest\Controller;

use API\Exceptions\ApiBadRequestException;
use API\Exceptions\ApiException;
use API\Exceptions\ApiNotFoundException;
use Doctrine\ORM\Query;
use Zend\View\Model\JsonModel;
use DoctrineModule\Stdlib\Hydrator\DoctrineObject as DoctrineHydrator;

class UserLocationController extends AbstractApplicationRestfulController {

    /**
     * Get entity list
     * @override
     * @return mixed|JsonModel
     */
    public function getList()
    {
        try{

            $qb = $this->getEntityManager()->createQueryBuilder()
                ->select('obj')
                ->from($this->getEntityClass(),'obj');

            $userId     = $this->params()->fromQuery('user', false);
            $startDate  = $this->params()->fromQuery('startDate', false);
            $endDate    = $this->params()->fromQuery('endDate', false);

            if($startDate && $endDate){
                $dtStart    = new \DateTime($startDate);
                $dtEnd      = new \DateTime($endDate);
                $qb->where('obj.created BETWEEN :startDate AND :endDate');
                $qb->setParameter('startDate', $dtStart);
                $qb->setParameter('endDate', $dtEnd);
            }

            if($userId){
                $user = $this->getEntityManager()->find('Model\\Entity\\User', $userId);
                if($user){
                    $qb->andWhere('obj.user = :user');
                    $qb->setParameter('user', $user);
                }
            }

            return $this->createResponse($qb);

        }catch (ApiException $ex){

            return $this->createApiExceptionResponse($ex);

        }catch (\Exception $ex){

            return $this->createGenericApiExceptionResponse($ex);

        }

        return $this->createResponse($qb);
    }

}