<?php

/**
 * Customer restful controller
 * @author Renato Peterman <renato.pet@gmail.com>
 */

namespace Rest\Controller;

use API\Exceptions\ApiBadRequestException;
use API\Exceptions\ApiException;
use API\Exceptions\ApiNotFoundException;
use Doctrine\ORM\Query;
use Zend\View\Model\JsonModel;
use DoctrineModule\Stdlib\Hydrator\DoctrineObject as DoctrineHydrator;

class SellerMapController extends AbstractApplicationRestfulController {

    /**
     * Get entity list
     * @override
     * @return mixed|JsonModel
     */
    public function getList()
    {
        try{

            $query = $this->getEntityManager()->createQueryBuilder('Model\Entity\UserCustomer');
            $query->select(array('cus.id as idCus', 'cus.city', 'cus.state', 'usr.id as idUsr', 'usr.name', 'usr.username', 'usr.code'))
                ->from('Model\Entity\UserCustomer', 'obj')
                ->innerJoin('obj.customer', 'cus')
                ->innerJoin('obj.user', 'usr')
                ->andWhere($query->expr()->andX(
                    $query->expr()->neq('obj.active', 0),
                    $query->expr()->neq('usr.active', 0),
                    $query->expr()->neq('cus.active', 0),
                    $query->expr()->isNotNull('cus.city'),
                    $query->expr()->isNotNull('cus.state')
                ))
                ->orderBy('usr.name', 'ASC');

            $result = $query->getQuery()->getResult();

            $data = [];
            foreach ($result as $item) {
                if (isset($data[$item['idUsr']]) === false)
                    $data[$item['idUsr']] = array(
                        'code' => $item['code'],
                        'name' => $item['name'],
                        'username' => $item['username'],
                        'states' => array(),
                    );

                $customState = $this->getCustomData($item['state']);

                if (isset($data[$item['idUsr']]['states'][$customState]) === false)
                    $data[$item['idUsr']]['states'][$customState] = array();

                $customCity = $this->getCustomData($item['city']);

                if (isset($data[$item['idUsr']]['states'][$customState][$customCity]) === false)
                    $data[$item['idUsr']]['states'][$customState][$customCity] = true;
            }

            //usort($data, function($a, $b) {
            //    return $b['name'] - $a['name'];
            //});

            return $this->createResponse($data);

        }catch (ApiException $ex){

            return $this->createApiExceptionResponse($ex);

        }catch (\Exception $ex){

            return $this->createGenericApiExceptionResponse($ex);

        }
    }

    private function getCustomData($data)
    {
        $data = preg_replace(
            array("/(á|à|ã|â|ä)/","/(Á|À|Ã|Â|Ä)/","/(é|è|ê|ë)/","/(É|È|Ê|Ë)/","/(í|ì|î|ï)/","/(Í|Ì|Î|Ï)/","/(ó|ò|õ|ô|ö)/","/(Ó|Ò|Õ|Ô|Ö)/","/(ú|ù|û|ü)/","/(Ú|Ù|Û|Ü)/","/(ñ)/","/(Ñ)/"),
            explode(" ","a A e E i I o O u U n N"),
            $data
        );
        $data = str_replace(array("  "), array(" "), $data);
        $data = strtolower($data);
        return $data;
    }
}