<?php

/**
 * Profile restful controller
 * Get and update user profile
 * @author Renato Peterman <renato.pet@gmail.com>
 */

namespace Rest\Controller;

use API\Exceptions\ApiBadRequestException;
use API\Exceptions\ApiException;
use API\Exceptions\ApiNotFoundException;
use API\Exceptions\ApiUnauthorizedException;
use Doctrine\ORM\Query;
use Model\Entity\User;
use Zend\View\Model\JsonModel;
use DoctrineModule\Stdlib\Hydrator\DoctrineObject as DoctrineHydrator;

class ProfileController extends AbstractApplicationRestfulController {

    /**
     * Get entity list
     * @override
     * @return mixed|JsonModel
     */
    public function getList()
    {
        try{

            $entityArr = $this->identity()->getArrayCopy();

            unset($entityArr['password']);
            unset($entityArr['created']);
            unset($entityArr['updated']);

            $data = array( $entityArr );

        }catch (ApiException $ex){

            return $this->createApiExceptionResponse($ex);

        }catch (\Exception $ex){

            return $this->createGenericApiExceptionResponse($ex);

        }

        return $this->createResponse($data);
    }

    /**
     * Get user profile
     * @override
     * @param mixed $id
     * @return mixed|JsonModel
     */
    public function get($id)
    {
        return $this->createMethodNotAllowedResponse();
    }

    /**
     * Update user profile
     * @override
     * @param mixed $data
     * @return JsonModel
     * @throws \ApiBadRequestException
     */
    public function create($data)
    {
        try{

            if (!$data){
                throw new ApiBadRequestException('Nenhuma informação enviada');
            }

            $password = $this->params()->fromPost('password', false);
            $entity = $this->getEntityManager()->find("Model\\Entity\\User", $this->identity()->getId());

            if($password){ // Change password - else update profile

                $newPassword = $this->params()->fromPost('passwordNew',false);
                if(!$newPassword){
                    throw new ApiBadRequestException('Nova senha não informada');
                }

                if(!User::hashPassword($entity, $password)){
                    throw new ApiUnauthorizedException("A senha atual informada não confere com a sua senha, por favor, tente novamente");
                }

                $entity->setPassword($newPassword);

                $this->getEntityManager()->merge($entity);
                $this->getEntityManager()->flush();

                return $this->createResponse( $entity );

            }else{

                $data = array(
                    'name' => $this->params()->fromPost('name', false),
                    'email' => $this->params()->fromPost('email', false),
                    'username' => $this->params()->fromPost('username', false)
                );

                $image = $this->params()->fromFiles('image', false);
                if($image && $image['error'] == UPLOAD_ERR_OK){

                    $imageData = getimagesize($image['tmp_name']);
                    $extension = image_type_to_extension($imageData[2]);
                    $filename = $entity->getId() . $extension;
                    move_uploaded_file($image['tmp_name'], User::getPathForFile($filename));
                    $entity->setImage($filename);

                }

                $hydrator = new DoctrineHydrator($this->getEntityManager(), "Model\\Entity\\User");
                $hydrator->hydrate($data, $entity);

                $this->getEntityManager()->merge($entity);
                $this->getEntityManager()->flush();

                return $this->createResponse( $entity );

            }

        }catch (ApiException $ex){

            return $this->createApiExceptionResponse($ex);

        }catch (\Exception $ex) {

            return $this->createGenericApiExceptionResponse($ex);

        }
    }

    /**
     * Update entity (not used)
     * @override
     * @param mixed $id
     * @param mixed $data
     * @return JsonModel
     * @throws \ApiBadRequestException
     */
    public function update($id, $data)
    {
        return $this->createMethodNotAllowedResponse();
    }

    /**
     * Delete profile picture image
     * @override
     * @param mixed $id
     * @return mixed|JsonModel
     */
    public function delete($id)
    {
        return $this->createMethodNotAllowedResponse();
    }

}