<?php

/**
 * Product Warehouse restful controller
 * @author Renato Peterman <renato.pet@gmail.com>
 */

namespace Rest\Controller;

use API\Exceptions\ApiBadRequestException;
use API\Exceptions\ApiException;
use API\Exceptions\ApiNotFoundException;
use Doctrine\ORM\Query;
use Zend\View\Model\JsonModel;
use DoctrineModule\Stdlib\Hydrator\DoctrineObject as DoctrineHydrator;

class ProductWarehouseController extends AbstractApplicationRestfulController {

    /**
     * Get entity list
     * @return mixed|JsonModel
     */
    public function getList()
    {
        try{

            $qb = $this->getEntityManager()->createQueryBuilder()
                ->select('obj')
                ->from($this->getEntityClass(),'obj');

            $warehouse = $this->params()->fromQuery('warehouse',false);
            if($warehouse){
                $qb->andWhere('obj.warehouse = :warehouse');
                $qb->setParameter('warehouse', $warehouse);
            }

            $product = $this->params()->fromQuery('product',false);
            if($product){
                $qb->andWhere('obj.product = :product');
                $qb->setParameter('product', $product);
            }

            $filter = $this->params()->fromQuery('filter', false);
            if($filter){
                switch($filter){
                    case 'all':
                        // Nothing to do here
                        break;
                    case 'stock':
                        $qb->andWhere('obj.amount > 0');
                        break;
                    case 'nostock':
                        $qb->andWhere('obj.amount <= 0');
                        break;
                }
            }

            $firstResult = $this->params()->fromQuery('offset',false);
            if($firstResult){
                $qb->setFirstResult($firstResult);
            }

            $maxResults = $this->params()->fromQuery('limit',false);
            if($maxResults){
                $qb->setMaxResults($maxResults);
            }

            $data = $qb->getQuery()->getResult();

        }catch (ApiException $ex){

            return $this->createApiExceptionResponse($ex);

        }catch (\Exception $ex){

            return $this->createGenericApiExceptionResponse($ex);

        }

        return $this->createResponse($data);
    }

    /**
     * Create and update entity
     * @param mixed $data
     * @return JsonModel
     * @throws \ApiBadRequestException
     */
    public function create($data)
    {
        try{

            if (!$data){
                throw new ApiBadRequestException('Nenhuma informação enviada');
            }

            if(!array_key_exists('product', $data) || !array_key_exists('warehouse', $data)){
                throw new ApiBadRequestException('Nenhum produto ou estoque enviado');
            }

            if(!array_key_exists('id', $data['product']) || !array_key_exists('id', $data['warehouse'])){
                throw new ApiBadRequestException('Nenhum produto ou estoque enviado');
            }

            $entity = $this->getEntityManager()->find($this->getEntityClass(), array('product' => $data['product']['id'], 'warehouse' => $data['warehouse']['id']));
            if(!$entity){
                // $entity = new $this->entityClass;
                throw new \Exception("Estoque não encontrado");
            }

            // Remove dates
            unset($data['created']);
            unset($data['updated']);

            $entity->setAmount($data['amount']);

            //$this->getEntityManager()->persist($entity);
            $this->getEntityManager()->merge($entity);
            $this->getEntityManager()->flush();

            return $this->createResponse( $entity );

        }catch (ApiException $ex){

            return $this->createApiExceptionResponse($ex);

        }catch (\Exception $ex) {

            error_log($ex->getTraceAsString());
            return $this->createGenericApiExceptionResponse($ex);

        }
    }

}