<?php

/**
 * Product restful controller
 * @author Renato Peterman <renato.pet@gmail.com>
 */

namespace Rest\Controller;

use Doctrine\ORM\Query;

class ProductController extends AbstractApplicationRestfulController {

    /**
     * Get entity list
     * @override
     * @return mixed|JsonModel
     */
    public function getList()
    {
        try{

            $qb = $this->getEntityManager()->createQueryBuilder()
                ->select('obj')
                ->from($this->getEntityClass(),'obj');

            $query = $this->params()->fromQuery('search', false);
            if($query){
                $qb->andWhere('obj.name LIKE :query OR obj.description LIKE :query');
                $qb->setParameter('query', '%' . $query . '%');
            }

            $representedCompany = $this->params()->fromQuery('representedCompany', false);
            if($representedCompany){
                $representedCompanyObj = $this->getEntityManager()->find("Model\\Entity\\RepresentedCompany", $representedCompany);
                if($representedCompanyObj){
                    //$qb->andWhere("SIZE(obj.representedCompanies) == 0 OR :representedCompany MEMBER OF obj.representedCompanies");
                    $qb->andWhere("SIZE(obj.representedCompanies) = 0 OR :representedCompany MEMBER OF obj.representedCompanies");
                    $qb->setParameter('representedCompany', $representedCompanyObj);
                }
            }

            $qb->orderBy('obj.name', 'ASC');

        }catch (ApiException $ex){

            return $this->createApiExceptionResponse($ex);

        }catch (\Exception $ex){

            return $this->createGenericApiExceptionResponse($ex);

        }

        return $this->createResponse($qb);
    }

}