<?php

/**
 * Order restful controller
 * @author Renato Peterman <renato.pet@gmail.com>
 */

namespace Rest\Controller;

use API\Exceptions\ApiBadRequestException;
use API\Exceptions\ApiException;
use API\Exceptions\ApiNotFoundException;
use Doctrine\ORM\Query;
use Zend\View\Model\JsonModel;
use DoctrineModule\Stdlib\Hydrator\DoctrineObject as DoctrineHydrator;

class OrderController extends AbstractApplicationRestfulController {

    /**
     * Get entity list
     * @override
     * @return mixed|JsonModel
     */
    public function getList()
    {
        try{

            $qb = $this->getEntityManager()->createQueryBuilder()
                ->select('obj')
                ->from($this->getEntityClass(),'obj');

            $firstResult = $this->params()->fromQuery('offset',false);
            if($firstResult){
                $qb->setFirstResult($firstResult);
            }

            $maxResults = $this->params()->fromQuery('limit',false);
            if($maxResults){
                $qb->setMaxResults($maxResults);
            }

            $filterField = $this->params()->fromQuery('dateField', 'orderDate');

            $startDate = $this->params()->fromQuery('startDate',false);
            if($startDate){
                $qb->andWhere('obj.'.$filterField.' >= :startDate');
                $qb->setParameter('startDate', new \DateTime($startDate));
            }

            $endDate = $this->params()->fromQuery('endDate',false);
            if($endDate){
                $qb->andWhere('obj.'.$filterField.' <= :endDate');
                $qb->setParameter('endDate', new \DateTime($endDate));
            }

            $customer = $this->params()->fromQuery('customer',false);
            if($customer){
                $qb->andWhere('obj.customer = :customer');
                $qb->setParameter('customer', $this->getEntityManager()->find('Model\Entity\Customer', $customer) );
            }

            $representedCompany = $this->params()->fromQuery('representedCompany',false);
            if($representedCompany){
                $qb->andWhere('obj.representedCompany = :rc');
                $qb->setParameter('rc', $this->getEntityManager()->find('Model\Entity\RepresentedCompany', $representedCompany) );
            }

            if($this->identity()->isAdmin()){
                $user = $this->params()->fromQuery('user',false);
            }else{
                $user = $this->identity()->getId();
            }

            if($user){
                $qb->andWhere('obj.user = :user');
                $qb->setParameter('user', $this->getEntityManager()->find('Model\Entity\User', $user) );
            }

            $status = $this->params()->fromQuery('status',false);
            if($status){
                $qb->andWhere('obj.status = :status');
                $qb->setParameter('status', $status);
            }

            $qb->andWhere('obj.active != :active');
            $qb->setParameter('active', 0);

            $data = $qb->getQuery()->getResult();

        }catch (ApiException $ex){

            return $this->createApiExceptionResponse($ex);

        }catch (\Exception $ex){

            return $this->createGenericApiExceptionResponse($ex);

        }

        return $this->createResponse($data);
    }

}