<?php

/**
 * Customer restful controller
 * @author Renato Peterman <renato.pet@gmail.com>
 */

namespace Rest\Controller;

use API\Exceptions\ApiBadRequestException;
use API\Exceptions\ApiException;
use API\Exceptions\ApiNotFoundException;
use Doctrine\ORM\Query;
use Zend\View\Model\JsonModel;
use DoctrineModule\Stdlib\Hydrator\DoctrineObject as DoctrineHydrator;

class CustomerController extends AbstractApplicationRestfulController {

    /**
     * Get entity list
     * @override
     * @return mixed|JsonModel
     */
    public function getList()
    {
        try{
            $qb = $this->getEntityManager()->createQueryBuilder()
                ->select('obj')
                ->from($this->getEntityClass(),'obj');

            /*
            $firstResult = $this->params()->fromQuery('offset',false);
            if($firstResult){
                $qb->setFirstResult($firstResult);
            }

            $maxResults = $this->params()->fromQuery('limit',false);
            if($maxResults){
                $qb->setMaxResults($maxResults);
            }
            */

            $query = $this->params()->fromQuery('query', false);
            if ($query === false)
                $query = $this->params()->fromQuery('search', false);

            //==========DOCUMENT PARSE============//

                $setMask = function ($val, $mask) {
                    $maskared = '';
                    $k = 0;
                    for($i = 0; $i<=strlen($mask)-1; $i++) {
                        if($mask[$i] == '#') {
                            if(isset($val[$k]))
                                $maskared .= $val[$k++];
                            if ($k == strlen($val))
                                break;
                        } else {
                            if(isset($mask[$i]))
                                $maskared .= $mask[$i];
                        }
                    }
                    return $maskared;
                };

                $document1 = preg_replace('/\D/', '', $query);
                $document2 = $setMask($document1, "###.###.###-##"); //639.536.823-00
                $document3 = $setMask($document1, "##.###.###/####-##"); //78.171.987/0001-02

                $sqlCustom = "";
                if (empty($document1) === false || empty($document2) === false || empty($document3) === false) {
                    $sqlCustom = "
                    obj.documentNumber LIKE :document1 OR
                    obj.documentNumber LIKE :document2 OR
                    obj.documentNumber LIKE :document3 OR
                ";
                }

            //==========DOCUMENT PARSE============//

            if($query){
                $qb->andWhere('
                    obj.name LIKE :query OR
                    obj.companyName LIKE :query OR
                    obj.city LIKE :query OR
                    '.$sqlCustom.'
                    obj.id = :query'
                );
                $qb->setParameter('query', '%' . $query . '%');
                if (empty($document1) === false || empty($document2) === false || empty($document3) === false) {
                    $qb->setParameter('document1', '%' . $document1 . '%');
                    $qb->setParameter('document2', '%' . $document2 . '%');
                    $qb->setParameter('document3', '%' . $document3 . '%');
                }
            }

            $qb->orderBy('obj.name', 'ASC');

            // $data = $qb->getQuery()->getResult();

        }catch (ApiException $ex){

            return $this->createApiExceptionResponse($ex);

        }catch (\Exception $ex){

            return $this->createGenericApiExceptionResponse($ex);

        }

        return $this->createResponse($qb);
    }

}