<?php

/**
 * OAuth2 Client restful controller
 * @author Renato Peterman <renato.pet@gmail.com>
 */

namespace Rest\Controller;

use API\Exceptions\ApiBadRequestException;
use API\Exceptions\ApiException;
use API\Exceptions\ApiNotFoundException;
use Doctrine\ORM\Query;
use Zend\View\Model\JsonModel;
use DoctrineModule\Stdlib\Hydrator\DoctrineObject as DoctrineHydrator;

class ClientController extends AbstractApplicationRestfulController {

    /**
     * @override
     *
     * Return the controller default class name based on controller name
     * @return string
     */
    public function getEntityClass(){
        return "Model\\Entity\\OAuth2\\Client";
    }


    /**
     * Get entity list
     * @return mixed|JsonModel
     */
    public function getList()
    {
        try{

            $qb = $this->getEntityManager()->createQueryBuilder()
                ->select('obj')
                ->from($this->getEntityClass(),'obj');

            $firstResult = $this->params()->fromQuery('offset',false);
            if($firstResult){
                $qb->setFirstResult($firstResult);
            }

            $maxResults = $this->params()->fromQuery('limit',false);
            if($maxResults){
                $qb->setMaxResults($maxResults);
            }

            $data = $qb->getQuery()->getResult();

        }catch (ApiException $ex){

            return $this->createApiExceptionResponse($ex);

        }catch (\Exception $ex){

            return $this->createGenericApiExceptionResponse($ex);

        }

        return $this->createResponse($data);
    }

    /**
     * Get entity
     * @param mixed $id
     * @return mixed|JsonModel
     */
    public function get($id)
    {
        try{

            $data = $this->getEntityManager()->createQueryBuilder()
                ->select('obj')
                ->from($this->getEntityClass(),'obj')
                ->where('obj.id = :objId AND obj.user = :user')
                ->setParameter("objId",$id)
                ->setParameter("user", $this->identity())
                ->getQuery()->getOneOrNullResult();

        }catch (ApiException $ex){

            return $this->createApiExceptionResponse($ex);

        }catch (\Exception $ex){

            return $this->createGenericApiExceptionResponse($ex);

        }

        return $this->createResponse($data);
    }

    /**
     * Create and update entity
     * @param mixed $data
     * @return JsonModel
     * @throws \ApiBadRequestException
     */
    public function create($data)
    {
        try{

            if (!$data){
                throw new ApiBadRequestException('Nenhuma informação enviada');
            }

            $entity = array_key_exists('id', $data) && $data['id'] ? $this->getEntityManager()->find($this->getEntityClass(), $data['id']) : null;
            if(!$entity){
                $entity = new $this->entityClass;
            }

            // Remove dates
            unset($data['created']);
            unset($data['updated']);

            // Remove to avoid override
            if($entity->getId()){
                unset($data['user']);
                unset($data['scope']);
                unset($data['secret']);
                unset($data['secret_plain']);
                unset($data['client_id']);
            }

            $hydrator = new DoctrineHydrator($this->getEntityManager(), $this->getEntityClass());
            $hydrator->hydrate($data, $entity);
            $entity->setUser($this->identity());

            $this->getEntityManager()->persist($entity);
            $this->getEntityManager()->flush();

            return $this->createResponse( $entity );

        }catch (ApiException $ex){

            return $this->createApiExceptionResponse($ex);

        }catch (\Exception $ex) {

            return $this->createGenericApiExceptionResponse($ex);

        }
    }

    /**
     * Update entity (not used)
     * @param mixed $id
     * @param mixed $data
     * @return JsonModel
     * @throws \ApiBadRequestException
     */
    public function update($id, $data)
    {
        try{

            if (!$data){
                throw new ApiBadRequestException('Nenhuma informação enviada');
            }

            if (!$id){
                throw new ApiBadRequestException('Código inválido');
            }

            $entity = $this->getEntityManager()->find($this->getEntityClass(), $id);
            if(!$entity){
                throw new ApiNotFoundException('Registro não encontrado');
            }

            // Remove dates
            unset($data['created']);
            unset($data['updated']);

            // Remove to avoid override
            unset($data['user']);
            unset($data['scope']);
            unset($data['secret']);
            unset($data['secret_plain']);
            unset($data['client_id']);

            $hydrator = new DoctrineHydrator($this->getEntityManager(), $this->getEntityClass());
            $hydrator->hydrate($data, $entity);

            $this->getEntityManager()->merge($entity);
            $this->getEntityManager()->flush();

            return $this->createResponse( $entity );

        }catch (ApiException $ex){

            return $this->createApiExceptionResponse($ex);

        }catch (\Exception $ex) {

            return $this->createGenericApiExceptionResponse($ex);

        }

    }

}