<?php
namespace Rest;

use Rest\Service\DateTimeLocaleHandler;
use Zend\Mvc\MvcEvent;
use Zend\View\Model\JsonModel;
use Zend\View\Model\ModelInterface;
use Zend\Http\Request as HttpRequest;


class Module
{
    /*
    public function onBootstrap(MvcEvent $e)
    {
        $application = $e->getApplication();
        $em = $application->getEventManager();
        //handle the dispatch error (exception)
        $em->attach(\Zend\Mvc\MvcEvent::EVENT_DISPATCH_ERROR, array($this, 'handleError'));
        //handle the view render error (exception)
        $em->attach(\Zend\Mvc\MvcEvent::EVENT_RENDER_ERROR, array($this, 'handleError'));
    }

    public function handleError(MvcEvent $e)
    {
        $exception = $e->getParam('exception');
        return new JsonModel(array(
            'error' => true,
            'exception' => get_class($exception),
            'message' => $exception->getMessage(),
        ));
    }
    */

    public function getServiceConfig()
    {
        return array(
            'factories' => array(
                'DateTimeLocaleHandler' => function ($sm) {
                    return new DateTimeLocaleHandler($sm);
                },
            )
        );
    }

    public function getConfig()
    {
        return include __DIR__ . '/config/module.config.php';
    }
    
    public function getAutoloaderConfig()
    {
        return array(
            /*
            'Zend\Loader\StandardAutoloader' => array(
                'namespaces' => array(
                    __NAMESPACE__ => __DIR__ . '/src/' . __NAMESPACE__,
                ),
            ),
            */
            'Zend\Loader\ClassMapAutoloader' => array(
                __DIR__ . '/autoload_classmap.php',
            ),
        );
    }
}
