<?php

namespace Model\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation as JMS;
use Zend\Form\Annotation;
use ZF\OAuth2\Doctrine\Entity\UserInterface;

/**
 * @ORM\Entity
 * @ORM\Table(name="user_location")
 */
class UserLocation extends AbstractEntity {

    /**
     * @ORM\Id
     * @ORM\Column(name="id", type="bigint")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @ORM\Column(type="decimal", precision=19, scale=8, nullable=true)
     *
     * @JMS\Type("double")
     */
    protected $longitude;

    /**
     * @ORM\Column(type="decimal", precision=19, scale=8, nullable=true)
     *
     * @JMS\Type("double")
     */
    protected $latitude;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="locations")
     * @ORM\JoinColumn(name="id_user", referencedColumnName="id")
     *
     * @JMS\Type("Model\Entity\User")
     */
    protected $user;

    /**
     * @ORM\Column(type="datetime", nullable=true)
     */
    protected $locationDate;

    
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * @return mixed
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * @param mixed $user
     */
    public function setUser($user)
    {
        $this->user = $user;
    }

    /**
     * @return mixed
     */
    public function getLatitude()
    {
        return $this->latitude;
    }

    /**
     * @param mixed $latitude
     */
    public function setLatitude($latitude)
    {
        $this->latitude = $latitude;
    }

    /**
     * @return mixed
     */
    public function getLongitude()
    {
        return $this->longitude;
    }

    /**
     * @param mixed $longitude
     */
    public function setLongitude($longitude)
    {
        $this->longitude = $longitude;
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * Set the value of locationDate.
     *
     * @param datetime $locationDate
     * @return \Model\Entity\UserLocation
     */
    public function setLocationDate($locationDate)
    {
        $this->locationDate = $locationDate;

        return $this;
    }

    /**
     * Get the value of locationDate.
     *
     * @return datetime
     */
    public function getLocationDate()
    {
        return $this->locationDate;
    }

    /**
     * Set location object array
     * @param $obj
     */
    public function setLocation($obj){
        $this->setLatitude($obj['latitude']);
        $this->setLongitude($obj['longitude']);
        if (isset($obj['datetime']))
            $this->setLocationDate($obj['datetime']);
    }

    /**
     * __toString()
     * @return string
     */
    public function __toString() {
        return $this->getLatitude() . ',' . $this->getLongitude();
    }

}   

?>
