<?php

namespace Model\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation as JMS;
use Zend\Form\Annotation;
use Zend\Stdlib\ArraySerializableInterface;

// {"access_token":"5bcbf2c58ce7b498b1e417916c47ec91f27a48eb","expires_in":3600,"token_type":"Bearer","scope":"","refresh_token":"4d8298a9415c73f2cbeb2c37ad985ac423b410ee"}

/**
 * @ORM\Entity
 * @ORM\Table(name="user_access_token")
 * @ORM\HasLifecycleCallbacks
 */
class UserAccessToken extends AbstractEntity implements ArraySerializableInterface {

    const EXPIRATION_TIME = 32140800; //(32140800) 1 year

    /**
     * @ORM\Id
     * @ORM\Column(name="id", type="bigint")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;
    
    /** 
     * @ORM\Column(name="access_token", type="string", unique=true)
     */
    protected $accessToken;

    /**
     * @ORM\Column(name="expires", type="datetime")
     */
    protected $expires;

    /**
     * @ORM\ManyToOne(targetEntity="Model\Entity\User", inversedBy="userAccessToken")
     * @ORM\JoinColumn(name="user_id", referencedColumnName="id", nullable=true)
     */
    protected $user;

    /**
     * @ORM\PrePersist
     */
    public function prePersist()
    {
        parent::prePersist();
        $this->setAccessToken( md5(uniqid(rand(), true)) ); // Generate new access token

        $date = new \DateTime();
        $date->add(new \DateInterval("PT".self::EXPIRATION_TIME."S"));
        $this->setExpires( $date );
    }

    public function __construct($user) {
        $this->setUser($user);
    }

    /**
     * @return mixed
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * @param mixed $user
     */
    public function setUser($user)
    {
        $this->user = $user;
    }

    /**
     * @return mixed
     */
    public function getExpires()
    {
        return $this->expires;
    }

    /**
     * @param mixed $expires
     */
    public function setExpires($expires)
    {
        $this->expires = $expires;
    }

    /**
     * @return mixed
     */
    public function getAccessToken()
    {
        return $this->accessToken;
    }

    /**
     * @param mixed $accessToken
     */
    public function setAccessToken($accessToken)
    {
        $this->accessToken = $accessToken;
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * Exchange array
     * @param array $array
     */
    public function exchangeArray(array $array)
    {
        foreach($array as $key => $value){
            $this->__set($key, $value);
        }
    }

    /**
     * Get array copy
     * @return array
     */
    public function getArrayCopy()
    {
        return get_object_vars($this);
    }

}   

?>
