<?php

namespace Model\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation as JMS;
use Doctrine\Common\Collections\ArrayCollection;
use Zend\Form\Annotation;

/**
 * Model\Entity\Size
 *
 * @ORM\Entity()
 * @ORM\Table(name="`unit_amount`")
 */
class UnitAmount extends AbstractEntity
{
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @ORM\Column(name="code", type="string", length=40, nullable=true)
     */
    protected $code;

    /**
     * @ORM\Column(type="string", length=100)
     */
    protected $description;

    /**
     * @ORM\Column(type="decimal", precision=19, scale=2)
     *
     * @JMS\Type("double")
     */
    protected $amount;    
    
    
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Set the value of id.
     *
     * @param integer $id
     * @return \Model\Entity\UnitAmount
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * Get the value of id.
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set the value of code.
     *
     * @param string $code
     * @return \Model\Entity\UnitAmount
     */
    public function setCode($code)
    {
        $this->code = $code;

        return $this;
    }

    /**
     * Get the value of code.
     *
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * Set the value of description.
     * @param string $description
     * @return \Model\Entity\UnitAmount
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * Get the value of description.
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Set the value of amount.
     *
     * @param float $amount
     * @return \Model\Entity\UnitAmount
     */
    public function setAmount($amount)
    {
        $this->amount = $amount;

        return $this;
    }

    /**
     * Get the value of amount.
     *
     * @return float
     */
    public function getAmount()
    {
        return $this->amount;
    }


    public function getAmountRound()
    {
        return number_format($this->amount, 0);
    }
    
    /**
     * To string
     * @return string
     */
    public function __toString() {
        return $this->getDescription();
    }
}
