<?php

/**
 * Auto generated by MySQL Workbench Schema Exporter.
 * Version 2.1.5-dev (doctrine2-annotation) on 2014-10-22 00:16:27.
 * Goto https://github.com/johmue/mysql-workbench-schema-exporter for more
 * information.
 */

namespace Model\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation as JMS;

/**
 * Model\Entity\PriceListProduct
 *
 * @ORM\Entity()
 * @ORM\Table(name="`price_list_product`", uniqueConstraints={@ORM\UniqueConstraint(name="price_list_product_unique", columns={"id_product", "id_price_list"})}, indexes={@ORM\Index(name="fk_price_list_product_price_list1_idx", columns={"id_price_list"}), @ORM\Index(name="fk_price_list_product_product1_idx", columns={"id_product"})})
 */
class PriceListProduct extends AbstractEntity
{
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @ORM\Column(name="code", type="string", length=40, nullable=true)
     */
    protected $code;

    /**
     * @ORM\Column(name="`code_product`", type="string", length=40, nullable=true)
     */
    protected $codeProduct;

    /**
     * @ORM\Column(name="`reference_product`", type="string", length=100, nullable=true)
     */
    protected $referenceProduct;

    /**
     * @ORM\ManyToOne(targetEntity="PriceList", inversedBy="priceListProducts", cascade={"persist", "merge"})
     * @ORM\JoinColumn(name="id_price_list", referencedColumnName="id", nullable=false)
     *
     * @JMS\Exclude()
     */
    protected $priceList;

    /**
     * @ORM\ManyToOne(targetEntity="Product", inversedBy="priceListProducts", cascade={"persist", "merge"})
     * @ORM\JoinColumn(name="id_product", referencedColumnName="id", nullable=false)
     *
     * @JMS\Exclude()
     */
    protected $product;

    /**
     * @ORM\Column(type="decimal", precision=19, scale=2)
     *
     * @JMS\Type("double")
     */
    protected $price;

    /**
     * @ORM\Column(name="`price_minimum`", type="decimal", precision=19, scale=2)
     *
     * @JMS\Type("double")
     */
    protected $priceMinimum;

    /**
     * @ORM\Column(type="datetime", nullable=true)
     */
    protected $priceChangeDate;


    public function __construct()
    {
        parent::__construct();
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * Set the value of code.
     *
     * @param string $code
     * @return \Model\Entity\Customer
     */
    public function setCode($code)
    {
        $this->code = $code;

        return $this;
    }

    /**
     * Get the value of code.
     *
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * Set the value of codeProduct.
     *
     * @param string $codeProduct
     * @return \Model\Entity\PricelistProduct
     */
    public function setCodeProduct($codeProduct)
    {
        $this->codeProduct = $codeProduct;

        return $this;
    }

    /**
     * Get the value of codeProduct.
     *
     * @return string
     */
    public function getCodeProduct()
    {
        return $this->codeProduct;
    }

    /**
     * Set the value of referenceProduct.
     *
     * @param string $referenceProduct
     * @return \Model\Entity\PricelistProduct
     */
    public function setReferenceProduct($referenceProduct)
    {
        $this->referenceProduct = $referenceProduct;

        return $this;
    }

    /**
     * Get the value of referenceProduct.
     *
     * @return string
     */
    public function getReferenceProduct()
    {
        return $this->referenceProduct;
    }

    /**
     * Set PriceList entity (many to one).
     *
     * @param \Model\Entity\PriceList $priceList
     * @return \Model\Entity\PriceListProduct
     */
    public function setPriceList(PriceList $priceList = null)
    {
        $this->priceList = $priceList;

        return $this;
    }

    /**
     * Get PriceList entity (many to one).
     *
     * @return \Model\Entity\PriceList
     */
    public function getPriceList()
    {
        return $this->priceList;
    }

    /**
     * Set Product entity (many to one).
     *
     * @param \Model\Entity\Product $product
     * @return \Model\Entity\PriceListProduct
     */
    public function setProduct(Product $product = null)
    {
        $this->product = $product;

        return $this;
    }

    /**
     * Get Product entity (many to one).
     *
     * @return \Model\Entity\Product
     */
    public function getProduct()
    {
        return $this->product;
    }

    /**
     * Set the value of price.
     *
     * @param float $price
     * @return \Model\Entity\PriceListProduct
     */
    public function setPrice($price)
    {
        $this->price = $price;

        return $this;
    }

    /**
     * Get the value of price.
     *
     * @return float
     */
    public function getPrice()
    {
        return $this->price;
    }

    public function getPriceCurrency()
    {
        return \Commons\Util\StringUtils::formatMoney($this->price);
    }

    public function getPriceCurrencyBRL()
    {
        return \Commons\Util\StringUtils::formatMoneyBRL($this->price);
    }

    /**
     * Set the value of priceMinimum.
     *
     * @param float $priceMinimum
     * @return \Model\Entity\PricelistProduct
     */
    public function setPriceMinimum($priceMinimum)
    {
        $this->priceMinimum = $priceMinimum;

        return $this;
    }

    /**
     * Get the value of priceMinimum.
     *
     * @return float
     */
    public function getPriceMinimum()
    {
        return $this->priceMinimum;
    }

    public function getPriceMinimumCurrency()
    {
        return \Commons\Util\StringUtils::formatMoney($this->priceMinimum);
    }

    public function getPriceMinimumCurrencyBRL()
    {
        return \Commons\Util\StringUtils::formatMoneyBRL($this->priceMinimum);
    }

    /**
     * Set the value of priceChangeDate.
     *
     * @param datetime $priceChangeDate
     * @return \Model\Entity\PriceListProduct
     */
    public function setPriceChangeDate($priceChangeDate)
    {
        $this->priceChangeDate = $priceChangeDate;

        return $this;
    }

    /**
     * Get the value of priceChangeDate.
     *
     * @return datetime
     */
    public function getPriceChangeDate()
    {
        return $this->priceChangeDate;
    }

    /**
     * Get the value of priceChangeDate.
     *
     * @return datetime
     */
    public function getPriceChangeDateFormatted()
    {
        return $this->priceChangeDate ? $this->priceChangeDate->format('d/m/Y') : "";
    }


    public function getArrayCopy(){
        $arr = parent::getArrayCopy();
        return $arr;
    }

    public function __sleep()
    {
        return array('id', 'code', 'codeProduct', 'referenceProduct', 'price', 'priceMinimum', 'priceChangeDate');
    }
}
