<?php

namespace Model\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation as JMS;
use Doctrine\Common\Collections\ArrayCollection;
use Zend\Form\Annotation;

/**
 * Model\Entity\PaymentCondition
 * Payment Condition
 *
 * @ORM\Entity()
 * @ORM\Table(name="payment_condition")
 * @Annotation\Name("payment_condition")
 * @Annotation\Attributes({"class":"form-horizontal form-validate"})
 */
class PaymentCondition extends AbstractEntity
{
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     * @Annotation\Exclude()
     */
    protected $id;

    /**
     * @ORM\Column(name="code", type="string", length=40, nullable=true)
     */
    protected $code;

    /**
     * @ORM\Column(type="string", length=100)
     * @Annotation\Type("Zend\Form\Element\Text")
     * @Annotation\Required({"required":"true" })
     * @Annotation\Attributes({"type":"text", "class":"form-control", "placeholder":"Obrigatório"})
     * @Annotation\Options({"label":"Descrição:"})
     */
    protected $description;

    public function __construct()
    {
        parent::__construct();
        $this->active = false;
    }

    /**
     * Set the value of id.
     *
     * @param integer $id
     * @return \Model\Entity\Unit
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * Get the value of id.
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set the value of code.
     *
     * @param string $code
     * @return \Model\Entity\Customer
     */
    public function setCode($code)
    {
        $this->code = $code;

        return $this;
    }

    /**
     * Get the value of code.
     *
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * Set the value of description.
     *
     * @param string $description
     * @return \Model\Entity\Unit
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * Get the value of description.
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    public function __sleep()
    {
        return array('id', 'description');
    }
    
    public function __toString() {
        return $this->getId() . ' - ' .  $this->getDescription();
    }

    /**
     * Get array copy for datatable
     * @return array
     */
    public function getArrayCopyDT(){
        $array = parent::getArrayCopy();
        $array['created'] = $this->getCreatedDatetimeStr();
        $array['updated'] = $this->getCreatedDatetimeStr();
        return $array;
    }
}