<?php

namespace Model\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation as JMS;

/**
 * Model\Entity\OrderProductVariant
 *
 * @ORM\Entity()
 * @ORM\Table(name="order_product_variant")
 */
class OrderProductVariant extends AbstractEntity
{
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @ORM\Column(name="code", type="string", length=40, nullable=true)
     */
    protected $code;

    /**
     * @ORM\ManyToOne(targetEntity="OrderProduct", inversedBy="orderProductVariant")
     * @ORM\JoinColumn(name="id_order_product", referencedColumnName="id")
     *
     * @JMS\Exclude()
     */
    protected $orderProduct;

    /**
     * @ORM\ManyToOne(targetEntity="Color")
     * @ORM\JoinColumn(name="id_color", referencedColumnName="id")
     *
     * @JMS\Type("Model\Entity\Color")
     */
    protected $color;

    /**
     * @ORM\ManyToOne(targetEntity="Size")
     * @ORM\JoinColumn(name="id_size", referencedColumnName="id")
     *
     * @JMS\Type("Model\Entity\Size")
     */
    protected $size;

    /**
     * @ORM\Column(type="decimal", precision=19, scale=2)
     *
     * @JMS\Type("double")
     */
    protected $amount;

    /**
     * @ORM\Column(name="value_ini", type="decimal", precision=19, scale=3, nullable=true)
     *
     * @JMS\Type("double")
     */
    protected $valueIni;

    /**
     * @ORM\Column(name="value_end", type="decimal", precision=19, scale=3, nullable=true)
     *
     * @JMS\Type("double")
     */
    protected $valueEnd;

    /**
     * @ORM\Column(type="decimal", precision=19, scale=2, nullable=true)
     *
     * @JMS\Type("double")
     */
    protected $price;

    public function __construct()
    {
        parent::__construct();
    }

    /**
     * @return mixed
     */
    public function getAmount()
    {
        return $this->amount;
    }

    public function getAmountRound()
    {
        return number_format($this->amount, 0);
    }

    /**
     * @param mixed $amount
     */
    public function setAmount($amount)
    {
        $this->amount = $amount;
    }

    /**
     * @return mixed
     */
    public function getSize()
    {
        return $this->size;
    }

    /**
     * @param mixed $size
     */
    public function setSize($size)
    {
        $this->size = $size;
    }

    /**
     * @return mixed
     */
    public function getColor()
    {
        return $this->color;
    }

    /**
     * @param mixed $color
     */
    public function setColor($color)
    {
        $this->color = $color;
    }

    /**
     * @return mixed
     */
    public function getOrderProduct()
    {
        return $this->orderProduct;
    }



    /**
     * @param mixed $orderProduct
     */
    public function setOrderProduct($orderProduct)
    {
        $this->orderProduct = $orderProduct;
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * Set the value of code.
     *
     * @param string $code
     * @return \Model\Entity\Customer
     */
    public function setCode($code)
    {
        $this->code = $code;

        return $this;
    }

    /**
     * Get the value of code.
     *
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }


    /**
     * @return mixed
     */
    public function getValueIni()
    {
        return $this->valueIni;
    }

    public function getValueIniRound()
    {
        return number_format($this->valueIni, 0);
    }

    /**
     * @param mixed $valueIni
     */
    public function setValueIni($valueIni)
    {
        $this->valueIni = $valueIni;
    }


    /**
     * @return mixed
     */
    public function getValueEnd()
    {
        return $this->valueEnd;
    }

    public function getValueEndRound()
    {
        return number_format($this->valueEnd, 0);
    }

    /**
     * @param mixed $valueEnd
     */
    public function setValueEnd($valueEnd)
    {
        $this->valueEnd = $valueEnd;
    }


    /**
     * Set the value of price.
     *
     * @param float $price
     * @return \Model\Entity\OrderProductProductVariant
     */
    public function setPrice($price)
    {
        $this->price = $price;

        return $this;
    }

    /**
     * Get the value of price.
     *
     * @return float
     */
    public function getPrice()
    {
        return $this->price;
    }

    public function getPriceCurrency()
    {
        return \Commons\Util\StringUtils::formatMoney($this->price);
    }

    public function getPriceCurrencyBRL()
    {
        return \Commons\Util\StringUtils::formatMoneyBRL($this->price);
    }

}