<?php

/**
 * Auto generated by MySQL Workbench Schema Exporter.
 * Version 2.1.5-dev (doctrine2-annotation) on 2014-10-22 00:16:27.
 * Goto https://github.com/johmue/mysql-workbench-schema-exporter for more
 * information.
 */

namespace Model\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation as JMS;

/**
 * Model\Entity\OrderProduct
 *
 * @ORM\Entity()
 * @ORM\Table(name="order_product",
    * indexes={
        * @ORM\Index(name="fk_order_has_product_product1_idx", columns={"id_product"}), 
        * @ORM\Index(name="fk_order_has_product_order1_idx", columns={"id_order"}), 
        * @ORM\Index(name="fk_order_product_warehouse1_idx", columns={"id_warehouse"})
    * }
 * )
 */
class OrderProduct extends AbstractEntity
{
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @ORM\Column(name="code", type="string", length=40, nullable=true)
     */
    protected $code;

    /**
     * @ORM\Column(name="`code_product`", type="string", length=40, nullable=true)
     */
    protected $codeProduct;

    /**
     * @ORM\Column(name="`reference_product`", type="string", length=100, nullable=true)
     */
    protected $referenceProduct;

    /**
     * @ORM\ManyToOne(targetEntity="Order", inversedBy="orderProducts", cascade={"persist", "merge"})
     * @ORM\JoinColumn(name="id_order", referencedColumnName="id")
     *
     * @JMS\Exclude()
     */
    protected $order;

    /**
     * @ORM\ManyToOne(targetEntity="Product", inversedBy="orderProducts")
     * @ORM\JoinColumn(name="id_product", referencedColumnName="id")
     *
     * @JMS\Type("Model\Entity\Product")
     */
    protected $product;

    /**
     * @ORM\ManyToOne(targetEntity="Warehouse", inversedBy="orderProducts")
     * @ORM\JoinColumn(name="id_warehouse", referencedColumnName="id")
     *
     * @JMS\Type("Model\Entity\Warehouse")
     */
    protected $warehouse;

    /**
     * @ORM\Column(type="decimal", precision=19, scale=2)
     *
     * @JMS\Type("double")
     */
    protected $amount;

    /**
     * @ORM\Column(name="amount_unit", type="decimal", precision=19, scale=2, nullable=true)
     *
     * @JMS\Type("double")
     */
    protected $amountUnit;

    /**
     * @ORM\Column(name="amount_unit_code", type="string", length=40, nullable=true)
     */
    protected $amountUnitCode;

    /**
     * @ORM\Column(name="`amount_devolution`", type="decimal", precision=19, scale=2, nullable=true)
     *
     * @JMS\Type("double")
     */
    protected $amountDevolution;

    /**
     * @ORM\Column(name="`amount_devolution_invoice`", type="decimal", precision=19, scale=2, nullable=true)
     *
     * @JMS\Type("double")
     */
    protected $amountDevolutionInvoice;

    /**
     * @ORM\Column(type="decimal", precision=19, scale=2)
     *
     * @JMS\Type("double")
     */
    protected $price;

    /**
     * @ORM\Column(type="decimal", precision=19, scale=2)
     *
     * @JMS\Type("double")
     */
    protected $subtotal;

    /**
     * @ORM\Column(type="decimal", precision=19, scale=2)
     *
     * @JMS\Type("double")
     */
    protected $discount;
    
    /**
     * @ORM\Column(name="discount_percent1", type="decimal", precision=19, scale=3, nullable=true)
     *
     * @JMS\Type("double")
     */
    protected $discountPercent1;
    /**
     * @ORM\Column(name="discount_percent2", type="decimal", precision=19, scale=3, nullable=true)
     *
     * @JMS\Type("double")
     */
    protected $discountPercent2;
    /**
     * @ORM\Column(name="discount_percent3", type="decimal", precision=19, scale=3, nullable=true)
     *
     * @JMS\Type("double")
     */
    protected $discountPercent3;
    /**
     * @ORM\Column(name="discount_percent4", type="decimal", precision=19, scale=3, nullable=true)
     *
     * @JMS\Type("double")
     */
    protected $discountPercent4;
    /**
     * @ORM\Column(name="discount_percent5", type="decimal", precision=19, scale=3, nullable=true)
     *
     * @JMS\Type("double")
     */
    protected $discountPercent5;

    /**
     * @ORM\Column(type="decimal", precision=19, scale=2)
     *
     * @JMS\Type("double")
     */
    protected $total;

    /**
     * @ORM\Column(name="obs", type="string", nullable=true)
     */
    protected $obs;

    /**
     * @ORM\Column(name="commission", type="decimal", precision=19, scale=2)
     *
     * @JMS\Type("double")
     */
    protected $commission;


    /* CUSTO, IPT, ICMSST  */
    /* CUSTO, IPT, ICMSST  */
    /**
     * @ORM\Column(type="decimal", precision=19, scale=4)
     *
     * @JMS\Type("double")
     */
    protected $icmsst;
    
    
    /**
     * @ORM\Column(type="decimal", precision=19, scale=4)
     *
     * @JMS\Type("double")
     */
    protected $ipi;
    
    /**
     * @ORM\Column(type="decimal", precision=19, scale=4)
     *
     * @JMS\Type("double")
     */
    protected $cost;    

    

    /**
     * @ORM\OneToMany(targetEntity="OrderProductVariant", mappedBy="orderProduct", cascade={"persist", "merge", "remove"})
     * @ORM\JoinColumn(name="id", referencedColumnName="id_order_product")
     *
     * @JMS\Type("Model\Entity\OrderProductVariant")
     */
    protected $orderProductVariants;

    public function __construct()
    {
        parent::__construct();
        $this->setCommission(0);
        $this->orderProductVariants = new ArrayCollection();
    }

    /**
     * @return mixed
     */
    public function getOrderProductVariants()
    {
        return $this->orderProductVariants;
    }

    /**
     * @param mixed $orderProductVariants
     */
    public function setOrderProductVariants($orderProductVariants)
    {
        $this->orderProductVariants = $orderProductVariants;
    }

    /**
     * @return mixed
     */
    public function getCommission()
    {
        return $this->commission;
    }

    /**
     * @param mixed $commission
     */
    public function setCommission($commission)
    {
        $this->commission = $commission;
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * Set the value of code.
     *
     * @param string $code
     * @return \Model\Entity\Customer
     */
    public function setCode($code)
    {
        $this->code = $code;

        return $this;
    }

    /**
     * Get the value of code.
     *
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * Set the value of referenceProduct.
     *
     * @param string $referenceProduct
     * @return \Model\Entity\OrderProductProduct
     */
    public function setReferenceProduct($referenceProduct)
    {
        $this->referenceProduct = $referenceProduct;

        return $this;
    }

    /**
     * Get the value of referenceProduct.
     *
     * @return string
     */
    public function getReferenceProduct()
    {
        return $this->referenceProduct;
    }

    /**
     * Set the value of codeProduct.
     *
     * @param string $codeProduct
     * @return \Model\Entity\OrderProductProduct
     */
    public function setCodeProduct($codeProduct)
    {
        $this->codeProduct = $codeProduct;

        return $this;
    }

    /**
     * Get the value of codeProduct.
     *
     * @return string
     */
    public function getCodeProduct()
    {
        return $this->codeProduct;
    }

    /**
     * Set the value of amount.
     *
     * @param float $amount
     * @return \Model\Entity\OrderProductProduct
     */
    public function setAmount($amount)
    {
        $this->amount = $amount;

        return $this;
    }

    /**
     * Get the value of amount.
     *
     * @return float
     */
    public function getAmount()
    {
        return $this->amount;
    }

    public function getAmountRound()
    {
        return number_format($this->amount, 0);
    }


    /**
     * Set the value of unit amount.
     *
     * @param float $amountUnit
     * @return \Model\Entity\OrderProductProduct
     */
    public function setAmountUnit($amountUnit)
    {
        $this->amountUnit = $amountUnit;

        return $this;
    }

    /**
     * Get the value of unit amount.
     *
     * @return float
     */
    public function getAmountUnit()
    {
        return $this->amountUnit;
    }

    /**
     * Set the value of unit amount code.
     *
     * @param string $amountUnitCode
     * @return \Model\Entity\OrderProductProduct
     */
    public function setAmountUnitCode($amountUnitCode)
    {
        $this->amountUnitCode = $amountUnitCode;

        return $this;
    }

    /**
     * Get the value of code.
     *
     * @return string
     */
    public function getAmountUnitCode()
    {
        return $this->amountUnitCode;
    }


    /**
     * Set the value of amountDevolution.
     *
     * @param float $amountDevolution
     * @return \Model\Entity\OrderProductProduct
     */
    public function setAmountDevolution($amountDevolution)
    {
        $this->amountDevolution = $amountDevolution;

        return $this;
    }

    /**
     * Get the value of amountDevolution.
     *
     * @return float
     */
    public function getAmountDevolution()
    {
        return $this->amountDevolution;
    }


    public function getAmountDevolutionRound()
    {
        return number_format($this->amountDevolution, 0);
    }

    /**
     * Set the value of amountDevolutionInvoice.
     *
     * @param float $amountDevolutionInvoice
     * @return \Model\Entity\OrderProductProduct
     */
    public function setAmountDevolutionInvoice($amountDevolutionInvoice)
    {
        $this->amountDevolutionInvoice = $amountDevolutionInvoice;

        return $this;
    }

    /**
     * Get the value of amountDevolutionInvoice.
     *
     * @return float
     */
    public function getAmountDevolutionInvoice()
    {
        return $this->amountDevolutionInvoice;
    }

    public function getAmountDevolutionInvoiceRound()
    {
        return number_format($this->amountDevolutionInvoice, 0);
    }


    /**
     * Set the value of price.
     *
     * @param float $price
     * @return \Model\Entity\OrderProductProduct
     */
    public function setPrice($price)
    {
        $this->price = $price;

        return $this;
    }

    /**
     * Get the value of price.
     *
     * @return float
     */
    public function getPrice()
    {
        return $this->price;
    }

    public function getPriceCurrency()
    {
        return \Commons\Util\StringUtils::formatMoney($this->price);
    }

    public function getPriceCurrencyBRL()
    {
        return \Commons\Util\StringUtils::formatMoneyBRL($this->price);
    }

    /**
     * Set the value of subtotal.
     *
     * @param float $subtotal
     * @return \Model\Entity\OrderProductProduct
     */
    public function setSubtotal($subtotal)
    {
        $this->subtotal = $subtotal;

        return $this;
    }

    /**
     * Get the value of subtotal.
     *
     * @return float
     */
    public function getSubtotal()
    {
        return $this->subtotal;
    }

    public function getSubtotalCurrency()
    {
        return \Commons\Util\StringUtils::formatMoney($this->subtotal);
    }

    public function getSubtotalCurrencyBRL()
    {
        return \Commons\Util\StringUtils::formatMoneyBRL($this->subtotal);
    }

    /**
     * Set the value of discount.
     *
     * @param float $discount
     * @return \Model\Entity\OrderProductProduct
     */
    public function setDiscount($discount)
    {
        $this->discount = $discount;

        return $this;
    }

    /**
     * Get the value of discount.
     *
     * @return float
     */
    public function getDiscount()
    {
        return $this->discount;
    }

    public function getDiscountCurrency()
    {
        return \Commons\Util\StringUtils::formatMoney($this->discount);
    }

    public function getDiscountCurrencyBRL()
    {
        return \Commons\Util\StringUtils::formatMoneyBRL($this->discount);
    }
    
    /**
     * Set the value of discountPercent1.
     *
     * @param float $discountPercent1
     * @return \Model\Entity\OrderProduct
     */
    public function setDiscountPercent1($discountPercent1)
    {
        $this->discountPercent1 = $discountPercent1;
        
        return $this;
    }
    /**
     * Get the value of discountPercent1.
     *
     * @return float
     */
    public function getDiscountPercent1()
    {
        return $this->discountPercent1;
    }
    
    /**
     * Set the value of discountPercent2.
     *
     * @param float $discountPercent2
     * @return \Model\Entity\OrderProduct
     */
    public function setDiscountPercent2($discountPercent2)
    {
        $this->discountPercent2 = $discountPercent2;
        
        return $this;
    }
    /**
     * Get the value of discountPercent2.
     *
     * @return float
     */
    public function getDiscountPercent2()
    {
        return $this->discountPercent2;
    }
    
    /**
     * Set the value of discountPercent3.
     *
     * @param float $discountPercent3
     * @return \Model\Entity\OrderProduct
     */
    public function setDiscountPercent3($discountPercent3)
    {
        $this->discountPercent3 = $discountPercent3;
        
        return $this;
    }
    /**
     * Get the value of discountPercent3.
     *
     * @return float
     */
    public function getDiscountPercent3()
    {
        return $this->discountPercent3;
    }
    
    
    /**
     * Set the value of discountPercent4.
     *
     * @param float $discountPercent4
     * @return \Model\Entity\OrderProduct
     */
    public function setDiscountPercent4($discountPercent4)
    {
        $this->discountPercent4 = $discountPercent4;
        
        return $this;
    }
    /**
     * Get the value of discountPercent4.
     *
     * @return float
     */
    public function getDiscountPercent4()
    {
        return $this->discountPercent4;
    }
    
    /**
     * Set the value of discountPercent5.
     *
     * @param float $discountPercent5
     * @return \Model\Entity\OrderProduct
     */
    public function setDiscountPercent5($discountPercent5)
    {
        $this->discountPercent5 = $discountPercent5;
        
        return $this;
    }
    /**
     * Get the value of discountPercent5.
     *
     * @return float
     */
    public function getDiscountPercent5()
    {
        return $this->discountPercent5;
    }

    /**
     * Set the value of total.
     *
     * @param float $total
     * @return \Model\Entity\OrderProductProduct
     */
    public function setTotal($total)
    {
        $this->total = $total;

        return $this;
    }

    /**
     * Get the value of total.
     *
     * @return float
     */
    public function getTotal()
    {
        return $this->total;
    }

    public function getTotalCurrency()
    {
        return \Commons\Util\StringUtils::formatMoney($this->total);
    }

    public function getTotalCurrencyBRL()
    {
        return \Commons\Util\StringUtils::formatMoneyBRL($this->total);
    }

    /**
     * Set Order entity (many to one).
     *
     * @param \Model\Entity\Order $order
     * @return \Model\Entity\OrderProductProduct
     */
    public function setOrder(Order $order = null)
    {
        $this->order = $order;

        return $this;
    }

    /**
     * Get Order entity (many to one).
     *
     * @return \Model\Entity\OrderProduct
     */
    public function getOrder()
    {
        return $this->order;
    }

    /**
     * Set Product entity (many to one).
     *
     * @param \Model\Entity\Product $product
     * @return \Model\Entity\OrderProductProduct
     */
    public function setProduct(Product $product = null)
    {
        $this->product = $product;

        return $this;
    }

    /**
     * Get Product entity (many to one).
     *
     * @return \Model\Entity\Product
     */
    public function getProduct()
    {
        return $this->product;
    }

    /**
     * Set Warehouse entity (many to one).
     *
     * @param \Model\Entity\Warehouse $warehouse
     * @return \Model\Entity\OrderProductProduct
     */
    public function setWarehouse(Warehouse $warehouse = null)
    {
        $this->warehouse = $warehouse;

        return $this;
    }

    /**
     * Get Warehouse entity (many to one).
     *
     * @return \Model\Entity\Warehouse
     */
    public function getWarehouse()
    {
        return $this->warehouse;
    }

    /**
     * @return mixed
     */
    public function getObs()
    {
        return $this->obs;
    }

    /**
     * @param mixed $obs
     */
    public function setObs($obs)
    {
        $this->obs = $obs;
    }



  /* get e set icmsst */	
  /**
     * Set the value of icmsst.
     *
     * @param float $icmsst
     * @return \Model\Entity\OrderProductProduct
     */
    public function setIcmsst($icmsst)
    {
        $this->icmsst = $icmsst;

        return $this;
    }

    /**
     * Get the value of icmsst.
     *
     * @return float
     */
    public function getIcmsst()
    {
        return $this->icmsst;
    }

    public function getIcmsstCurrency()
    {
        return \Commons\Util\StringUtils::formatMoney($this->icmsst);
    }

    public function getIcmsstCurrencyBRL()
    {
        return \Commons\Util\StringUtils::formatMoneyBRL($this->icmsst);
    }
	
	
  /* get e set ipi */	
  /**
     * Set the value of ipi.
     *
     * @param float $ipi
     * @return \Model\Entity\OrderProductProduct
     */
    public function setIpi($ipi)
    {
        $this->ipi = $ipi;

        return $this;
    }

    /**
     * Get the value of ipi.
     *
     * @return float
     */
    public function getIpi()
    {
        return $this->ipi;
    }

    public function getIpiCurrency()
    {
        return \Commons\Util\StringUtils::formatMoney($this->ipi);
    }

    public function getIpiCurrencyBRL()
    {
        return \Commons\Util\StringUtils::formatMoneyBRL($this->ipi);
    }	
	
	
  /* get e set cost */	
  /**
     * Set the value of cost.
     *
     * @param float $cost
     * @return \Model\Entity\OrderProductProduct
     */
    public function setCost($cost)
    {
        $this->cost = $cost;

        return $this;
    }

    /**
     * Get the value of cost.
     *
     * @return float
     */
    public function getCost()
    {
        return $this->cost;
    }

    public function getCostCurrency()
    {
        return \Commons\Util\StringUtils::formatMoney($this->cost);
    }

    public function getCostCurrencyBRL()
    {
        return \Commons\Util\StringUtils::formatMoneyBRL($this->cost);
    }		    

    public function getArrayCopy(){
        $arr = parent::getArrayCopy();

        /*
        codigo
        descricao
        referencia
        reduzido
        grupo
        linha
        preco
        quantidade
        subTotal
        desconto
        total
        pedido
        obs
        */

        return $arr;
    }

    public function __sleep()
    {
        return array('order', 'product', 'warehouse', 'amount', 'price', 'subtotal', 'discount', 'total');
    }
}
