<?php

/**
 * Auto generated by MySQL Workbench Schema Exporter.
 * Version 2.1.5-dev (doctrine2-annotation) on 26042024-163903-1.
 * Goto https://github.com/johmue/mysql-workbench-schema-exporter for more
 * information.
 */

namespace Model\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation as JMS;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Model\Entity\Order
 *
 * @ORM\Entity()
 * @ORM\Table(name="`order`", indexes={ @ORM\Index(name="filter_idx", columns={"orderDate", "status", "type"}) })
 */
class Order extends AbstractEntity
{

    const PEDIDO = "p";
    const VENDA = "v";
    const ATUALIZACAO = "a";

    const STATUS_WAITING = 1; //Aguardando aprovacao
    const STATUS_CANCELED = 2; // Cancelado
    const STATUS_OK = 3; // Confirmado
    const STATUS_TO_UPDATE = 4; // Aguardando atualizacao
    const STATUS_UPDATED = 5; // Atualizado

    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @ORM\Column(name="code", type="string", length=40, nullable=true)
     */
    protected $code;

    /**
     * @ORM\Column(name="reference", type="string", length=80, nullable=true)
     */
    protected $reference;

    /**
     * @ORM\Column(name="`type`", type="string", length=45)
     */
    protected $type;

    /**
     * @ORM\Column(type="datetime")
     */
    protected $orderDate;

    /**
     * @ORM\Column(type="datetime", nullable=true)
     */
    protected $expectedDelivery;

    /**
     * @ORM\Column(name="app_datetime_to_sync", type="datetime", nullable=true)
     *
     * @JMS\Type("DateTime")
     */
    protected $appDatetimeToSync;

    /**
     * @ORM\Column(name="app_sync", type="boolean", nullable=true)
     *
     * @JMS\Type("boolean")
     */
    protected $appSync;

    /**
     * @ORM\Column(name="app_sync_datetime", type="datetime", nullable=true)
     *
     * @JMS\Type("DateTime")
     */
    protected $appSyncDatetime;

    /**
     * @ORM\Column(type="decimal", precision=19, scale=2)
     *
     * @JMS\Type("double")
     */
    protected $subtotal;

    /**
     * @ORM\Column(type="decimal", precision=19, scale=2)
     *
     * @JMS\Type("double")
     */
    protected $discount;

    /**
     * @ORM\Column(name="discount_percent1", type="decimal", precision=19, scale=3, nullable=true)
     *
     * @JMS\Type("double")
     */
    protected $discountPercent1;
    /**
     * @ORM\Column(name="discount_percent2", type="decimal", precision=19, scale=3, nullable=true)
     *
     * @JMS\Type("double")
     */
    protected $discountPercent2;
    /**
     * @ORM\Column(name="discount_percent3", type="decimal", precision=19, scale=3, nullable=true)
     *
     * @JMS\Type("double")
     */
    protected $discountPercent3;
    /**
     * @ORM\Column(name="discount_percent4", type="decimal", precision=19, scale=3, nullable=true)
     *
     * @JMS\Type("double")
     */
    protected $discountPercent4;
    /**
     * @ORM\Column(name="discount_percent5", type="decimal", precision=19, scale=3, nullable=true)
     *
     * @JMS\Type("double")
     */
    protected $discountPercent5;

    /**
     * @ORM\Column(type="decimal", precision=19, scale=2)
     *
     * @JMS\Type("double")
     */
    protected $total;

    /**
     * @ORM\Column(name="commission", type="decimal", precision=19, scale=2)
     *
     * @JMS\Type("double")
     */
    protected $commission;

    /**
     * @ORM\Column(name="status", type="integer", nullable=true)
     */
    protected $status;

    /**
     * @ORM\Column(name="info", type="text", nullable=true)
     */
    protected $info;

    /**
     * @ORM\OneToMany(targetEntity="OrderProduct", mappedBy="order", cascade={"persist", "merge", "remove"})
     * @ORM\JoinColumn(name="id", referencedColumnName="id_order")
     *
     * @JMS\Type("Model\Entity\OrderProduct")
     */
    protected $orderProducts;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="orders")
     * @ORM\JoinColumn(name="id_user", referencedColumnName="id")
     *
     * @JMS\Type("Model\Entity\User")
     */
    protected $user;

    /**
     * @ORM\ManyToOne(targetEntity="Model\Entity\Device")
     * @ORM\JoinColumn(name="id_device", referencedColumnName="id", nullable=true)
     *
     * @JMS\Type("Model\Entity\Device")
     */
    protected $device;

    /**
     * @ORM\ManyToOne(targetEntity="Customer", inversedBy="orders")
     * @ORM\JoinColumn(name="id_customer", referencedColumnName="id")
     *
     * @JMS\Type("Model\Entity\Customer")
     */
    protected $customer;

    /**
     * @ORM\ManyToOne(targetEntity="Model\Entity\Warehouse")
     * @ORM\JoinColumn(name="id_warehouse", referencedColumnName="id", nullable=true)
     *
     * @JMS\Type("Model\Entity\Warehouse")
     */
    protected $warehouse;

    /**
     * @ORM\ManyToOne(targetEntity="Model\Entity\RepresentedCompany", inversedBy="orders")
     * @ORM\JoinColumn(name="id_represented_company", referencedColumnName="id")
     *
     * @JMS\Type("Model\Entity\RepresentedCompany")
     */
    protected $representedCompany;

    /**
     * @ORM\ManyToOne(targetEntity="Model\Entity\PaymentMethod")
     * @ORM\JoinColumn(name="id_payment_method", referencedColumnName="id", nullable=true)
     *
     * @JMS\Type("Model\Entity\PaymentMethod")
     */
    protected $paymentMethod;

    /**
     * @ORM\ManyToOne(targetEntity="Model\Entity\PaymentCondition")
     * @ORM\JoinColumn(name="id_payment_condition", referencedColumnName="id", nullable=true)
     *
     * @JMS\Type("Model\Entity\PaymentCondition")
     */
    protected $paymentCondition;

    /**
     * @ORM\ManyToOne(targetEntity="Model\Entity\OrderType")
     * @ORM\JoinColumn(name="id_order_type", referencedColumnName="id", nullable=true)
     *
     * @JMS\Type("Model\Entity\OrderType")
     */
    protected $orderType;

    /**
     * @ORM\ManyToOne(targetEntity="Model\Entity\OrderClassification")
     * @ORM\JoinColumn(name="id_order_classification", referencedColumnName="id", nullable=true)
     *
     * @JMS\Type("Model\Entity\OrderClassification")
     */
    protected $orderClassification;

    /**
     * @ORM\ManyToOne(targetEntity="Model\Entity\OrderCustomerType")
     * @ORM\JoinColumn(name="id_order_customer_type", referencedColumnName="id", nullable=true)
     *
     * @JMS\Type("Model\Entity\OrderCustomerType")
     */
    protected $orderCustomerType;

    /**
     * @ORM\Column(name="longitude", type="decimal", precision=19, scale=8, nullable=true)
     *
     * @JMS\Type("double")
     */
    protected $longitude;

    /**
     * @ORM\Column(name="latitude", type="decimal", precision=19, scale=8, nullable=true)
     *
     * @JMS\Type("double")
     */
    protected $latitude;


    /**
    * @ORM\Column(name="json", type="text", nullable=true)
    */
    protected $json;

    /**
     * @ORM\Column(type="datetime")
     */
    protected $date_delivery;


     /**
     * @ORM\Column(name="cod_filial", type="string", length=40, nullable=true)
     */
    protected $cod_filial;


    /**
     * @ORM\Column(name="statusorder", type="string", length=40, nullable=true)
     */
    protected $statusorder;  


    /**
     * @ORM\Column(name="tipo_frete1", type="string", length=50, nullable=true)
     */
    protected $tipo_frete1;  

    /**
     * @ORM\Column(name="tipotransportadora", type="string", length=50, nullable=true)
     */
    protected $tipotransportadora;  


    public function __construct()
    {
        parent::__construct();
        $this->orderProducts = new ArrayCollection();
        $this->setCommission(0);
    }


    public function getJson() {
        return $this->json;
    }
        
    public function setJson($json) {
        $this->json = $json;
    }

    public function getInfo() {
        return $this->info;
    }

    public function setInfo($info) {
        $this->info = $info;
    }

    public function getDevice() {
        return $this->device;
    }

    public function setDevice($device) {
        $this->device = $device;
    }

    public function getWarehouse() {
        return $this->warehouse;
    }

    public function setWarehouse($warehouse) {
        $this->warehouse = $warehouse;
    }


    /**
     * Set the value of id.
     *
     * @param integer $id
     * @return \Model\Entity\Order
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * Get the value of id.
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set the value of code.
     *
     * @param string $code
     * @return \Model\Entity\Order
     */
    public function setCode($code)
    {
        $this->code = $code;

        return $this;
    }

    /**
     * Get the value of code.
     *
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * Set the value of reference.
     *
     * @param string $reference
     * @return \Model\Entity\Order
     */
    public function setReference($reference)
    {
        $this->reference = $reference;

        return $this;
    }

    /**
     * Get the value of reference.
     *
     * @return string
     */
    public function getReference()
    {
        return $this->reference;
    }

    /**
     * Set the value of type.
     *
     * @param string $type
     * @return \Model\Entity\Order
     */
    public function setType($type)
    {
        $this->type = $type;

        return $this;
    }

    /**
     * Get the value of type.
     *
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Set the value of orderDate.
     *
     * @param datetime $orderDate
     * @return \Model\Entity\Order
     */
    public function setOrderDate($orderDate)
    {
        $this->orderDate = $orderDate;

        return $this;
    }

    /**
     * Get the value of orderDate.
     *
     * @return datetime
     */
    public function getOrderDate()
    {
        return $this->orderDate;
    }

    /**
     * Get the value of orderDate.
     *
     * @return date
     */
    public function getOrderDateFormatted()
    {
        return $this->orderDate ? $this->orderDate->format('d/m/Y') : "";
    }

    /**
     * Set the value of expectedDelivery.
     *
     * @param datetime $expectedDelivery
     * @return \Model\Entity\Order
     */
    public function setExpectedDelivery($expectedDelivery)
    {
        $this->expectedDelivery = $expectedDelivery;

        return $this;
    }

    /**
     * Get the value of expectedDelivery.
     *
     * @return datetime
     */
    public function getExpectedDelivery()
    {
        return $this->expectedDelivery;
    }

    public function getAppDatetimeToSync() {
        return $this->appDatetimeToSync;
    }

    public function setAppDatetimeToSync($appDatetimeToSync) {
        $this->appDatetimeToSync = $appDatetimeToSync;
    }

    public function getAppSync() {
        return $this->appSync;
    }

    public function setAppSync($appSync) {
        $this->appSync = $appSync;
    }

    public function getAppSyncDatetime() {
        return $this->appSyncDatetime;
    }

    public function setAppSyncDatetime($appSyncDatetime) {
        $this->appSyncDatetime = $appSyncDatetime;
    }

    /**
     * Set the value of subtotal.
     *
     * @param float $subtotal
     * @return \Model\Entity\Order
     */
    public function setSubtotal($subtotal)
    {
        $this->subtotal = $subtotal;

        return $this;
    }

    /**
     * Get the value of subtotal.
     *
     * @return float
     */
    public function getSubtotal()
    {
        return $this->subtotal;
    }

    public function getSubtotalCurrency()
    {
        return \Commons\Util\StringUtils::formatMoney($this->subtotal);
    }

    public function getSubtotalCurrencyBRL()
    {
        return \Commons\Util\StringUtils::formatMoneyBRL($this->subtotal);
    }


    /**
     * Get the value of discount.
     *
     * @return float
     */
    public function getDiscount()
    {
        return $this->discount;
    }

    /**
     * Set the value of discount.
     *
     * @param float $discount
     * @return \Model\Entity\Order
     */
    public function setDiscount($discount)
    {
        $this->discount = $discount;

        return $this;
    }

    public function getDiscountCurrency()
    {
        return \Commons\Util\StringUtils::formatMoney($this->discount);
    }

    public function getDiscountCurrencyBRL()
    {
        return \Commons\Util\StringUtils::formatMoneyBRL($this->discount);
    }

    public function getDiscountPercent()
    {
        if($this->getDiscount() > 0){
            return ($this->getDiscount() * 100)/$this->getSubtotal();
        }
        return 0;
    }

    /**
     * Set the value of discountPercent1.
     *
     * @param float $discountPercent1
     * @return \Model\Entity\Order
     */
    public function setDiscountPercent1($discountPercent1)
    {
        $this->discountPercent1 = $discountPercent1;

        return $this;
    }
    /**
     * Get the value of discountPercent1.
     *
     * @return float
     */
    public function getDiscountPercent1()
    {
        return $this->discountPercent1;
    }

    /**
     * Set the value of discountPercent2.
     *
     * @param float $discountPercent2
     * @return \Model\Entity\Order
     */
    public function setDiscountPercent2($discountPercent2)
    {
        $this->discountPercent2 = $discountPercent2;

        return $this;
    }
    /**
     * Get the value of discountPercent2.
     *
     * @return float
     */
    public function getDiscountPercent2()
    {
        return $this->discountPercent2;
    }

    /**
     * Set the value of discountPercent3.
     *
     * @param float $discountPercent3
     * @return \Model\Entity\Order
     */
    public function setDiscountPercent3($discountPercent3)
    {
        $this->discountPercent3 = $discountPercent3;

        return $this;
    }
    /**
     * Get the value of discountPercent3.
     *
     * @return float
     */
    public function getDiscountPercent3()
    {
        return $this->discountPercent3;
    }


    /**
     * Set the value of discountPercent4.
     *
     * @param float $discountPercent4
     * @return \Model\Entity\Order
     */
    public function setDiscountPercent4($discountPercent4)
    {
        $this->discountPercent4 = $discountPercent4;

        return $this;
    }
    /**
     * Get the value of discountPercent4.
     *
     * @return float
     */
    public function getDiscountPercent4()
    {
        return $this->discountPercent4;
    }

    /**
     * Set the value of discountPercent5.
     *
     * @param float $discountPercent5
     * @return \Model\Entity\Order
     */
    public function setDiscountPercent5($discountPercent5)
    {
        $this->discountPercent5 = $discountPercent5;

        return $this;
    }
    /**
     * Get the value of discountPercent5.
     *
     * @return float
     */
    public function getDiscountPercent5()
    {
        return $this->discountPercent5;
    }


    /**
     * Set the value of total.
     *
     * @param float $total
     * @return \Model\Entity\Order
     */
    public function setTotal($total)
    {
        $this->total = $total;

        return $this;
    }

    /**
     * Get the value of total.
     *
     * @return float
     */
    public function getTotal()
    {
        return $this->total;
    }

    public function getTotalCurrency()
    {
        return \Commons\Util\StringUtils::formatMoney($this->total);
    }

    public function getTotalCurrencyBRL()
    {
        return \Commons\Util\StringUtils::formatMoneyBRL($this->total);
    }

    /**
     * Set the value of status.
     *
     * @param string $status
     * @return \Model\Entity\Order
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * Get the value of status.
     *
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Set the value of id_customer.
     *
     * @param integer $id_customer
     * @return \Model\Entity\Order
     */
    public function setIdCustomer($id_customer)
    {
        $this->id_customer = $id_customer;

        return $this;
    }

    /**
     * Get the value of id_customer.
     *
     * @return integer
     */
    public function getIdCustomer()
    {
        return $this->id_customer;
    }

    /**
     * Add OrderProduct entity to collection (one to many).
     *
     * @param \Model\Entity\OrderProduct $orderProduct
     * @return \Model\Entity\Order
     */
    public function addOrderProduct(OrderProduct $orderProduct)
    {
        $this->orderProducts[] = $orderProduct;

        return $this;
    }

    /**
     * Remove OrderProduct entity from collection (one to many).
     *
     * @param \Model\Entity\OrderProduct $orderProduct
     * @return \Model\Entity\Order
     */
    public function removeOrderProduct(OrderProduct $orderProduct)
    {
        $this->orderProducts->removeElement($orderProduct);

        return $this;
    }

    /**
     * Get OrderProduct entity collection (one to many).
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getOrderProducts()
    {
        return $this->orderProducts;
    }

    /**
     * Set User entity (many to one).
     *
     * @param \Model\Entity\User $user
     * @return \Model\Entity\Order
     */
    public function setUser(User $user = null)
    {
        $this->user = $user;

        return $this;
    }

    /**
     * Get User entity (many to one).
     *
     * @return \Model\Entity\User
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Set Customer entity (many to one).
     *
     * @param \Model\Entity\Customer $customer
     * @return \Model\Entity\Order
     */
    public function setCustomer(Customer $customer = null)
    {
        $this->customer = $customer;

        return $this;
    }

    /**
     * Get Customer entity (many to one).
     *
     * @return \Model\Entity\Customer
     */
    public function getCustomer()
    {
        return $this->customer;
    }

    /**
     * @return mixed
     */
    public function getRepresentedCompany()
    {
        return $this->representedCompany;
    }

    /**
     * @param mixed $representedCompany
     */
    public function setRepresentedCompany($representedCompany)
    {
        $this->representedCompany = $representedCompany;
    }

    /**
     * @return mixed
     */
    public function getPaymentMethod()
    {
        return $this->paymentMethod;
    }

    /**
     * @param mixed $paymentMethod
     */
    public function setPaymentMethod($paymentMethod)
    {
        $this->paymentMethod = $paymentMethod;
    }

    /**
     * @return mixed
     */
    public function getPaymentCondition()
    {
        return $this->paymentCondition;
    }

    /**
     * @param mixed $paymentCondition
     */
    public function setPaymentCondition($paymentCondition)
    {
        $this->paymentCondition = $paymentCondition;
    }

    /**
     * @return mixed
     */
    public function getOrderType()
    {
        return $this->orderType;
    }

    /**
     * @param mixed $orderType
     */
    public function setOrderType($orderType)
    {
        $this->orderType = $orderType;
    }

    /**
     * @return mixed
     */
    public function getOrderClassification()
    {
        return $this->orderClassification;
    }

    /**
     * @param mixed $orderClassification
     */
    public function setOrderClassification($orderClassification)
    {
        $this->orderClassification = $orderClassification;
    }

    /**
     * @return mixed
     */
    public function getOrderCustomerType()
    {
        return $this->orderCustomerType;
    }

    /**
     * @param mixed $orderCustomerType
     */
    public function setOrderCustomerType($orderCustomerType)
    {
        $this->orderCustomerType = $orderCustomerType;
    }

    /**
     * @return mixed
     */
    public function getLatitude()
    {
        return $this->latitude;
    }

    /**
     * @param mixed $latitude
     */
    public function setLatitude($latitude)
    {
        $this->latitude = $latitude;
    }

    /**
     * @return mixed
     */
    public function getLongitude()
    {
        return $this->longitude;
    }

    /**
     * @param mixed $longitude
     */
    public function setLongitude($longitude)
    {
        $this->longitude = $longitude;
    }

    /**
     * @return mixed
     */
    public function getCommission()
    {
        return $this->commission;
    }

    /**
     * @param mixed $commission
     */
    public function setCommission($commission)
    {
        $this->commission = $commission;
    }

	//TODO Data de Entrega nova
    /**
     * Set the value of date_delivery.
     *
     * @param datetime $date_delivery
     * @return \Model\Entity\Order
     */
    public function setDate_delivery($date_delivery)
    {
        $this->date_delivery = $date_delivery;

        return $this;
    }

    /**
     * Get the value of date_delivery.
     *
     * @return datetime
     */
    public function getDate_delivery()
    {
        return $this->date_delivery;
    }

    /**
     * Get the value of orderDate.
     *
     * @return date
     */
    public function getDate_deliveryDateFormatted()
    {
        return $this->date_delivery ? $this->date_delivery->format('d/m/Y') : "";
    }
	//Fim data entrega	

/**
     * Set the value of cod_filial.
     *
     * @param string $cod_filial
     * @return \Model\Entity\Order
     */
    public function setCod_filial($cod_filial)
    {
        $this->cod_filial = $cod_filial;

        return $this;
    }

    /**
     * Get the value of cod_filial.
     *
     * @return string
     */
    public function getCod_filial()
    {
        return $this->cod_filial;
    }

    //statusorder
    /**
     * Set the value of statusorder.
     *
     * @param string $statusorder
     * @return \Model\Entity\Order
     */
    public function setStatusorder($statusorder)
    {
        $this->statusorder = $statusorder;

        return $this;
    }

    /**
     * Get the value of statusorder.
     *
     * @return string
     */
    public function getStatusorder()
    {
        return $this->statusorder;
    }




    //tipo_frete1
    /**
     * Set the value of tipo_frete1.
     *
     * @param string $tipo_frete1
     * @return \Model\Entity\Order
     */
    public function setTipo_frete1($tipo_frete1)
    {
        $this->tipo_frete1 = $tipo_frete1;

        return $this;
    }

    /**
     * Get the value of tipo_frete1.
     *
     * @return string 
     */
    public function getTipo_frete1()
    {
        return $this->tipo_frete1;
    }



   //tipotransportadora
    /**
     * Set the value of tipotransportadora.
     *
     * @param string $tipotransportadora
     * @return \Model\Entity\Order
     */
    public function setTipotransportadora($tipotransportadora)
    {
        $this->tipotransportadora = $tipotransportadora;

        return $this;
    }

    /**
     * Get the value of tipotransportadora.
     *
     * @return string 
     */
    public function getTipotransportadora()
    {
        return $this->tipotransportadora;
    }




    public static function types(){
        return array(
            Order::PEDIDO => 'Pedido',
            Order::VENDA => 'Pronta Entrega',
            Order::ATUALIZACAO => 'Atualização'
        );
    }

    public static function statusList(){
        return array(
            Order::STATUS_WAITING   => 'Aguardando Aprovação',
            Order::STATUS_CANCELED  => 'Cancelado',
            Order::STATUS_OK        => 'Aprovado',
            Order::STATUS_TO_UPDATE => 'Aguardando Atualização',
            Order::STATUS_UPDATED   => 'Atualizado',
        );
    }

    public function getTypeDescription(){
        switch ($this->getType()) {
            case Order::PEDIDO:
                return "Pedido";
                break;
            case Order::VENDA:
                return "Pronta Entrega";
                break;
            case Order::ATUALIZACAO:
                return "Atualização";
                break;
            default:
                break;
        }
        return "";
    }

    public function getArrayCopy(){
        $arr = parent::getArrayCopy();

        /*
        codigo
        dataPedido
        subTotal
        desconto
        total
        estoque
        estoqueDescription
        obs
        usuarioId
        usuarioNome
        usuarioCodigo
        status
        tipo

        clienteObjectId
        clienteCodigo
        clienteRazaoSocial
        clienteNomeFantasia
        clienteNome
        clienteCnpj
        clienteIE
        clienteEmail
        clienteEndereco
        clienteBairro
        clienteCep
        clienteNumero
        clienteComplemento
        clienteCidade
        clienteEstado
        clienteTelefonePrincipal
        clienteTelefoneSecundario
        clienteAtivo
        clienteTipoPessoa
        clienteLongitude
        clienteLatitude
        clienteOnline
        clienteRepresentadas

        rascunho
        dataSync

        representadaCodigo
        representadaRazaoSocial
        representadaNomeFantasia
        representadaCnpj

        formaPagamentoCodigo
        formaPagamentoDescricao

        condicaoPagamentoCodigo
        condicaoPagamentoDescricao

        latitude
        longitude;
        */

        return $arr;
    }

    public function __sleep()
    {
        return array('id', 'type', 'orderDate', 'expectedDelivery', 'subtotal', 'discount', 'total', 'status');
    }
}
