<?php

/**
 * Auto generated by MySQL Workbench Schema Exporter.
 * Version 2.1.5-dev (doctrine2-annotation) on 2014-10-22 00:16:27.
 * Goto https://github.com/johmue/mysql-workbench-schema-exporter for more
 * information.
 */

namespace Model\Entity;

use Commons\Util\FileUtil;
use Commons\Util\ImageUtil;
use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation as JMS;
use Doctrine\Common\Collections\ArrayCollection;
use Zend\Form\Annotation;

/**
 * Model\Entity\Group
 *
 * @ORM\Entity()
 * @ORM\Table(name="`group`")
 * @Annotation\Name("group")
 * @Annotation\Attributes({"class":"form-horizontal form-validate"})
 */
class Group extends AbstractEntity
{
    const NO_PICTURE_PATH = "./data/images/no-photo.jpg";
    const DEFAULT_PATH = './data/images/product-group';

    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     * @Annotation\Exclude()
     */
    protected $id;

    /**
     * @ORM\Column(name="image", type="string", nullable=true)
     * @Annotation\Exclude()
     */
    protected $image;

    /**
     * @Annotation\Type("Zend\Form\Element\File")
     * @Annotation\Attributes({"id":"imageFile"})
     * @Annotation\Options({"label":"Imagem:"})
     */
    protected $imageFile;

    /**
     * @ORM\Column(name="code", type="string", length=40, nullable=true)
     */
    protected $code;

    /**
     * @ORM\Column(name="level", type="string", length=40, nullable=true)
     */
    protected $level;

    /**
     * @ORM\Column(type="string", length=100)
     * @Annotation\Type("Zend\Form\Element\Text")
     * @Annotation\Required({"required":"true" })
     * @Annotation\Attributes({"type":"text", "class":"form-control", "placeholder":"Obrigatório"})
     * @Annotation\Options({"label":"Descrição:"})
     */
    protected $description;

    /**
     * @ORM\OneToMany(targetEntity="Product", mappedBy="groupRelatedByIdGroupPrimary")
     * @ORM\JoinColumn(name="id", referencedColumnName="id_group_primary")
     * @Annotation\Exclude()
     *
     * @JMS\Exclude()
     */
    protected $productRelatedByIdGroupPrimaries;

    /**
     * @ORM\OneToMany(targetEntity="Product", mappedBy="groupRelatedByIdGroupSecondary")
     * @ORM\JoinColumn(name="id", referencedColumnName="id_group_secondary")
     * @Annotation\Exclude()
     *
     * @JMS\Exclude()
     */
    protected $productRelatedByIdGroupSecondaries;

    /**
     * @ORM\Column(name="blocked", type="boolean", nullable=true, options={"default" = 0})
     * @JMS\Type("boolean")
     */
    protected $blocked;

    /**
     * @ORM\PreRemove()
     */
    public function preDelete() {
        if(file_exists($this->getFullImagePath())){
            unlink($this->getFullImagePath());
        }
        if(file_exists($this->getFullThumbPath())){
            unlink($this->getFullThumbPath());
        }
    }

    public function __construct()
    {
        parent::__construct();
        $this->groups = new ArrayCollection();
        $this->productRelatedByIdGroupPrimaries = new ArrayCollection();
        $this->productRelatedByIdGroupSecondaries = new ArrayCollection();
    }

    /**
     * Set the value of id.
     *
     * @param integer $id
     * @return \Model\Entity\Group
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * Get the value of id.
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    public function getImage() {
        return $this->image;
    }

    public function setImage($image) {
        $this->image = $image;
    }

    public function getImageFile() {
        return $this->imageFile;
    }

    public function setImageFile($imageFile) {
        $this->imageFile = $imageFile;
    }

    /**
     * Set the value of code.
     *
     * @param string $code
     * @return \Model\Entity\Group
     */
    public function setCode($code)
    {
        $this->code = $code;

        return $this;
    }

    /**
     * Get the value of code.
     *
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * Set the value of level.
     *
     * @param string $level
     * @return \Model\Entity\Group
     */
    public function setLevel($level)
    {
        $this->level = $level;

        return $this;
    }

    /**
     * Get the value of level.
     *
     * @return string
     */
    public function getLevel()
    {
        return $this->level;
    }

    /**
     * Set the value of description.
     *
     * @param string $description
     * @return \Model\Entity\Group
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * Get the value of description.
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    public function setBlocked($blocked)
    {
        $this->blocked = $blocked;

        return $this;
    }

    public function getBlocked()
    {
        return $this->blocked;
    }

    /**
     * Add Product entity related by `id_group_primary` to collection (one to many).
     *
     * @param \Model\Entity\Product $product
     * @return \Model\Entity\Group
     */
    public function addProductRelatedByIdGroupPrimary(Product $product)
    {
        $this->productRelatedByIdGroupPrimaries[] = $product;

        return $this;
    }

    /**
     * Remove Product entity related by `id_group_primary` from collection (one to many).
     *
     * @param \Model\Entity\Product $product
     * @return \Model\Entity\Group
     */
    public function removeProductRelatedByIdGroupPrimary(Product $product)
    {
        $this->productRelatedByIdGroupPrimaries->removeElement($product);

        return $this;
    }

    /**
     * Get Product entity related by `id_group_primary` collection (one to many).
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getProductRelatedByIdGroupPrimaries()
    {
        return $this->productRelatedByIdGroupPrimaries;
    }

    /**
     * Add Product entity related by `id_group_secondary` to collection (one to many).
     *
     * @param \Model\Entity\Product $product
     * @return \Model\Entity\Group
     */
    public function addProductRelatedByIdGroupSecondary(Product $product)
    {
        $this->productRelatedByIdGroupSecondaries[] = $product;

        return $this;
    }

    /**
     * Remove Product entity related by `id_group_secondary` from collection (one to many).
     *
     * @param \Model\Entity\Product $product
     * @return \Model\Entity\Group
     */
    public function removeProductRelatedByIdGroupSecondary(Product $product)
    {
        $this->productRelatedByIdGroupSecondaries->removeElement($product);

        return $this;
    }

    /**
     * Get Product entity related by `id_group_secondary` collection (one to many).
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getProductRelatedByIdGroupSecondaries()
    {
        return $this->productRelatedByIdGroupSecondaries;
    }


    /**
     * Get full path for image
     * @return string
     */
    public function getFullImagePath(){
        return static::DEFAULT_PATH . "/" . $this->getImage();
    }

    public function getFullImagePathExtension(){
        return pathinfo($this->getFullImagePath(), PATHINFO_EXTENSION);
    }

    public function getFullImagePathMimeType(){
        return FileUtil::getMimeTypeForExtension($this->getFullImagePathExtension());
    }

    /**
     * Get full path for thumb image
     * @return string
     */
    public function getFullThumbPath(){
        //return static::DEFAULT_PATH . "/product_" . $this->getId() . '_thumb.jpg';
        return static::DEFAULT_PATH . "/" . $this->getId() . '_thumb.' . $this->getFullImagePathExtension();
    }

    public function getFullThumbPathExtension(){
        return pathinfo($this->getFullImagePath(), PATHINFO_EXTENSION);
    }

    public function getFullThumbPathMimeType(){
        return FileUtil::getMimeTypeForExtension($this->getFullImagePathExtension());
    }

    /**
     * Set file resource
     * @param $file
     * @throws \Exception
     */
    public function setFileResource($file){
        if(!$file) throw new \Exception("Invalid file");

        if(!file_exists(static::DEFAULT_PATH)){
            mkdir(static::DEFAULT_PATH, 0777, true);
        }

        switch($file['type']){
            case "image/jpeg":
            case "image/jpg":
                $extension = "jpg";
                break;
            case "image/png":
                $extension = "png";
                break;
            case "image/gif":
                $extension = "gif";
                break;
            default:
                throw new \Exception("Formato de arquivo inválido");
        }

        //$imageName = 'product_' . $this->getId() . '.jpg';
        //$imageName = $this->getId() . '.jpg';
        $imageName = $this->getId() . '.' . $extension;
        rename($file['tmp_name'], $this->getPathForFile($imageName));
        $this->setImage($imageName);

        // Resize image
        ImageUtil::resize($this->getFullImagePath(), $this->getFullImagePath(), $extension, 800, 900, 80);

        // Generate thumb
        ImageUtil::resize($this->getFullImagePath(), $this->getFullThumbPath(), $extension, 160, 240, 50);
    }

    /**
     * Get path for file
     * @param $file
     * @return string
     */
    public function getPathForFile($file = ''){
        return static::DEFAULT_PATH . '/' . $file;
    }

    public function __sleep()
    {
        return array('id', 'description', 'image', 'code');
    }

    public function __toString() {
        return $this->getDescription();
    }
}
