<?php

/**
 * Auto generated by MySQL Workbench Schema Exporter.
 * Version 2.1.5-dev (doctrine2-annotation) on 2014-10-22 00:16:27.
 * Goto https://github.com/johmue/mysql-workbench-schema-exporter for more
 * information.
 */

namespace Model\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation as JMS;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Model\Entity\FinancialPending
 *
 * @ORM\Entity()
 * @ORM\Table(name="`financial_pending`", indexes={ @ORM\Index(name="filter_pending_idx", columns={"date", "status"}) })
 */
class FinancialPending extends AbstractEntity
{
    const STATUS_PENDING = 1; //Pendente
    const STATUS_CANCELED = 2; // Cancelado
    const STATUS_OK = 3; // Resolvido
    
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

     /**
     * @ORM\Column(name="code", type="string", length=40, nullable=true)
     */
    protected $code;

    /**
     * @ORM\Column(name="description", type="text", nullable=false)
     */
    protected $description;

    /**
     * @ORM\Column(type="datetime")
     */
    protected $date;

    /**
     * @ORM\Column(type="decimal", precision=19, scale=2)
     *
     * @JMS\Type("double")
     */
    protected $total;

    /**
     * @ORM\Column(name="status", type="integer", nullable=false)
     */
    protected $status;

    /**
     * @ORM\ManyToOne(targetEntity="Customer", inversedBy="financialPending")
     * @ORM\JoinColumn(name="id_customer", referencedColumnName="id", nullable=false)
     *
     * @JMS\Type("Model\Entity\Customer")
     */
    protected $customer;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="orders")
     * @ORM\JoinColumn(name="id_user", referencedColumnName="id")
     *
     * @JMS\Type("Model\Entity\User")
     */
    protected $user;


    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Set the value of id.
     *
     * @param integer $id
     * @return \Model\Entity\FinancialPending
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * Get the value of id.
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set the value of code.
     *
     * @param string $code
     * @return \Model\Entity\Customer
     */
    public function setCode($code)
    {
        $this->code = $code;

        return $this;
    }

    /**
     * Get the value of code.
     *
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    public function getDescription() {
        return $this->description;
    }

    public function setDescription($description) {
        $this->description = $description;
    }

    public function setDate($date)
    {
        $this->date = $date;

        return $this;
    }

    public function getDate()
    {
        return $this->date;
    }

    public function getDateFormatted()
    {
        return $this->date ? $this->date->format('d/m/Y') : "";
    }

    public function setTotal($total)
    {
        $this->total = $total;

        return $this;
    }

    public function getTotal()
    {
        return $this->total;
    }

    public function getTotalCurrency()
    {
        return \Commons\Util\StringUtils::formatMoney($this->total);
    }

    public function getTotalCurrencyBRL()
    {
        return \Commons\Util\StringUtils::formatMoneyBRL($this->total);
    }

    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Set Customer entity (many to one).
     *
     * @param \Model\Entity\Customer $customer
     * @return \Model\Entity\Order
     */
    public function setCustomer(Customer $customer = null)
    {
        $this->customer = $customer;

        return $this;
    }

    /**
     * Get Customer entity (many to one).
     *
     * @return \Model\Entity\Customer
     */
    public function getCustomer()
    {
        return $this->customer;
    }

    /**
     * Set User entity (many to one).
     *
     * @param \Model\Entity\User $user
     * @return \Model\Entity\FinancialPending
     */
    public function setUser(User $user = null)
    {
        $this->user = $user;

        return $this;
    }

    /**
     * Get User entity (many to one).
     *
     * @return \Model\Entity\User
     */
    public function getUser()
    {
        return $this->user;
    }

    public function getStatusDescription(){
        if ($this->getStatus() == FinancialPending::STATUS_PENDING)
            return 'Pendente';
        if ($this->getStatus() == FinancialPending::STATUS_CANCELED)
            return 'Cancelado';
        if ($this->getStatus() == FinancialPending::STATUS_OK)
            return 'Resolvido';
    }

    public static function statusList(){
        return array(
            FinancialPending::STATUS_PENDING   => 'Pendente',
            FinancialPending::STATUS_CANCELED  => 'Cancelado',
            FinancialPending::STATUS_OK        => 'Resolvido',
        );
    }

    public function getArrayCopy() {
        $arr = array();

        $arr['id'] = $this->getId();

        $customer = $this->getCustomer();
        if (is_object($customer))
            $arr['customer'] = array(
                "id" => $customer->getId(),
                "name" => $customer->getName(),
                "companyName" => $customer->getCompanyName(),
                "documentNumber" => $customer->getDocumentNumber()
            );

        $user= $this->getUser();
        if (is_object($user))
            $arr['user'] = array(
                "id" => $user->getId(),
                "name" => $user->getName(),
                "code" => $user->getSellerId()
            );

        $arr['description'] = $this->getDescription();
        $arr['date'] = $this->getDate();
        $arr['total'] = (double) $this->getTotal();
        $arr['statusId'] = $this->getStatus();
        $arr['status'] = $this->getStatusDescription();
        $arr['created'] = $this->getCreated();
        $arr['updated'] = $this->getUpdated();

        return $arr;
    }

    public function __sleep()
    {
        return array('id', 'date', 'description', 'total', 'status');
    }
}