<?php

namespace Model\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation as JMS;
use Doctrine\Common\Collections\ArrayCollection;
use Zend\Form\Annotation;

/**
 * Model\Entity\FilialVendedor
 * Filial Vendedor
 *
 * @ORM\Entity()
 * @ORM\Table(name="filialvendedor")
 * @Annotation\Name("filialvendedor")
 * @Annotation\Attributes({"class":"form-horizontal form-validate"})
 */
class FilialVendedor extends AbstractEntity  
{
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     * @Annotation\Exclude()
     */
    protected $id;

    /**
     * @ORM\Column(name="cod_usuario", type="string", length=40, nullable=true)
     */
    protected $cod_usuario;

    /**
     * @ORM\Column(name="cod_cadastro", type="text", nullable=false)
     */
    protected $cod_cadastro;

    /**
     * @ORM\Column(name="cod_filial", type="text", nullable=false)
     */
    protected $cod_filial;

    




    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Set the value of id.
     *
     * @param integer $id
     * @return \Model\Entity\Filial
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * Get the value of id.
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }


    public function getCod_usuario() {
        return $this->cod_usuario;
    }

    public function setCod_usuario($cod_usuario) {
        $this->cod_usuario = $cod_usuario;
    }

    public function getCod_cadastro() {
        return $this->cod_cadastro;
    }

    public function setCod_cadastro($cod_cadastro) {
        $this->cod_cadastro = $cod_cadastro;
    }

    public function getCod_filial() {
        return $this->cod_filial;
    }

    public function setCod_filial($cod_filial) {
        $this->cod_filial = $cod_filial;
    }




}