<?php

namespace Model\Entity; 

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation as JMS;
use Doctrine\Common\Collections\ArrayCollection;
use Zend\Form\Annotation;

/**
 * Model\Entity\Filial
 * Filial
 *
 * @ORM\Entity()
 * @ORM\Table(name="filial")
 * @Annotation\Name("filial") 
 * @Annotation\Attributes({"class":"form-horizontal form-validate"})
 */
class Filial extends AbstractEntity
{
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     * @Annotation\Exclude()
     */
    protected $id;

    /**
     * @ORM\Column(name="cod_filial", type="string", length=40, nullable=true)
     */
    protected $cod_filial;

    /**
     * @ORM\Column(name="uf", type="text", nullable=false)
     */
    protected $uf; 

    /**
     * @ORM\Column(name="nome_filial", type="text", nullable=false)
     */
    protected $nome_filial;

    /**
     * @ORM\Column(name="cpf_cgc", type="text", nullable=false)
     */
    protected $cpf_cgc;

    /**
     * @ORM\Column(name="email", type="text", nullable=false)
     */
    protected $email;

    /**
     * @ORM\Column(name="fone", type="text", nullable=false)
     */
    protected $fone;  




    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Set the value of id.
     *
     * @param integer $id
     * @return \Model\Entity\Filial
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * Get the value of id.
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    public function getCod_filial() {
        return $this->cod_filial;
    }

    public function setCod_filial($cod_filial) {
        $this->cod_filial = $cod_filial;
    }

    public function getUf() {
        return $this->uf;
    }

    public function setUf($uf) {
        $this->uf = $uf;
    }

    public function getNome_filial() {
        return $this->nome_filial;
    }

    public function setNome_filial($nome_filial) {
        $this->nome_filial = $nome_filial;
    }

    public function getCpf_cgc() {
        return $this->cpf_cgc;
    }

    public function setCpf_cgc($cpf_cgc) {
        $this->cpf_cgc = $cpf_cgc;
    }

    public function getEmail() {
        return $this->email;
    }

    public function setEmail($email) {
        $this->email = $email; 
    }

    public function getFone() {
        return $this->fone;
    }

    public function setFone($fone) {
        $this->fone = $fone; 
    }    

 
/**
     * Get array copy
     * @return array
     */
    public function getArrayCopy($entityConfig = null) {

        $arr = array();
        $arr['id'] = $this->getId();
        $arr['cod_filial'] = $this->getFilial() ? $this->getFilial() : "";
        $arr['uf'] = $this->getUf() ? $this->getUf() : "";
        $arr['nome_filial'] = $this->getNome_filial() ? $this->getNome_filial() : "";
       $arr['filial'] = $this->getFilial() ? $this->getFilial() : "";

    }  
    
        /**
     * toString method
     * @return string
     */
    public function __toString() {
        return $this->getId() . ' - ' . $this->getCod_filial();
    }



}