<?php

/**
 * Auto generated by MySQL Workbench Schema Exporter.
 * Version 2.1.5-dev (doctrine2-annotation) on 2014-10-22 00:16:27.
 * Goto https://github.com/johmue/mysql-workbench-schema-exporter for more
 * information.
 */

namespace Model\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation as JMS;
use Doctrine\Common\Collections\ArrayCollection;
use Zend\Form\Annotation;

/**
 * Model\Entity\Customer
 *
 * @ORM\Entity()
 * @ORM\Table(name="customer")
 */
class Customer extends AbstractEntity
{

    const PESSOA_FISICA = 'pf';
    const PESSOA_JURIDICA = 'pj';

    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @ORM\Column(name="code", type="string", length=40, nullable=true)
     */
    protected $code;

    /**
     * @ORM\Column(name="name", type="string", length=255)
     */
    protected $name;

    /**
     * @ORM\Column(name="nickname", type="string", length=255, nullable=true)
     */
    protected $nickname;

    /**
     * @ORM\Column(name="company_name", type="string", length=255, nullable=true)
     */
    protected $companyName;

    /**
     * @ORM\Column(name="contact", type="string", length=255, nullable=true)
     */
    protected $contact;

    /**
     * @ORM\Column(name="document_number", type="string", length=45, nullable=true)
     */
    protected $documentNumber;

    /**
     * @ORM\Column(name="secondary_document_number",type="string", length=45, nullable=true)
     */
    protected $secondaryDocumentNumber;

    /**
     * @ORM\Column(name="zip", type="string", length=30, nullable=true)
     */
    protected $zip;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     */
    protected $address;

    /**
     * @ORM\Column(name="addressNumber", type="string", length=45, nullable=true)
     */
    protected $addressNumber;

    /**
     * @ORM\Column(type="string", length=45, nullable=true)
     */
    protected $neighbourhood;

    /**
     * @ORM\Column(name="address_complement", type="string", length=45, nullable=true)
     */
    protected $addressComplement;

    /**
     * @ORM\Column(name="`state`", type="string", length=45, nullable=true)
     */
    protected $state;

    /**
     * @ORM\Column(type="string", length=45, nullable=true)
     */
    protected $city;

    /**
     * @ORM\Column(name="phone_primary",type="string", length=45, nullable=true)
     */
    protected $phonePrimary;

    /**
     * @ORM\Column(name="phone_secondary", type="string", length=45, nullable=true)
     */
    protected $phoneSecondary;

    /**
     * @ORM\Column(type="string", length=45, nullable=true)
     */
    protected $website;

    /**
     * @ORM\Column(type="string", length=45, nullable=true)
     */
    protected $email;

    /**
     * @ORM\Column(type="decimal", precision=19, scale=8, nullable=true)
     *
     * @JMS\Type("double")
     */
    protected $longitude;

    /**
     * @ORM\Column(type="decimal", precision=19, scale=8, nullable=true)
     *
     * @JMS\Type("double")
     */
    protected $latitude;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     */
    protected $blocked;

    /**
     * @ORM\OneToMany(targetEntity="Order", mappedBy="customer")
     * @ORM\JoinColumn(name="id", referencedColumnName="id_customer")
     *
     * @JMS\Exclude()
     */
    protected $orders;

    /**
     * @ORM\Column(type="string", length=10, nullable=false)
     */
    protected $customerType;

    /**
     * @ORM\Column(name="info", type="text", nullable=true)
     */
    protected $info;

    /**
     * @ORM\Column(type="datetime", nullable=true)
     */
    protected $lastOrderDate;

    /**
     * @ORM\Column(type="decimal", precision=19, scale=2, nullable=true)
     *
     * @JMS\Type("double")
     */
    protected $discount;

    /**
     * @ORM\ManyToMany(targetEntity="Model\Entity\RepresentedCompany", cascade={"persist", "merge"})
     * @ORM\JoinTable(name="customer_represented_company",
     *      joinColumns={@ORM\JoinColumn(name="id_customer", referencedColumnName="id")},
     *      inverseJoinColumns={@ORM\JoinColumn(name="id_represented_company", referencedColumnName="id")}
     *      )
     */
    protected $representedCompanies;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="customer")
     * @ORM\JoinColumn(name="id_user", referencedColumnName="id", nullable=true)
     *
     * @JMS\Type("Model\Entity\User")
     */
    protected $user;

    /**
     * @ORM\OneToMany(targetEntity="Model\Entity\UserCustomer", mappedBy="customer", cascade={"all"})
     * @ORM\JoinColumn(name="id", referencedColumnName="id_customer")
     * @Annotation\Exclude()
     *
     * @JMS\Exclude()
     */
    protected $userCustomers;

    /**
     * @ORM\ManyToOne(targetEntity="PriceList")
     * @ORM\JoinColumn(name="id_price_list", referencedColumnName="id", nullable=true)
     *
     * @JMS\Exclude()
     */
    protected $priceList;    

    /**
     * @ORM\Column(name="ramo_atividade", type="integer", nullable=true)
     */
     protected $ramoAtividade;  

     /**
     * @ORM\Column(name="cod_categoria", type="string", nullable=true)
     */
    protected $categoria;  


    public function __construct()
    {
        parent::__construct();
        $this->orders = new ArrayCollection();
        $this->representedCompanies = new ArrayCollection();
        $this->userCustomers = new ArrayCollection();
        $this->latitude = 0.0;
        $this->longitude = 0.0;
    }

    public function getInfo() {
        return $this->info;
    }

    public function setInfo($info) {
        $this->info = $info;
    }



    /**
     * Set the value of lastOrderDate.
     *
     * @param datetime $lastOrderDate
     * @return \Model\Entity\Customer
     */
    public function setLastOrderDate($lastOrderDate)
    {
        $this->lastOrderDate = $lastOrderDate;

        return $this;
    }

    /**
     * Get the value of lastOrderDate.
     *
     * @return datetime
     */
    public function getLastOrderDate()
    {
        return $this->lastOrderDate;
    }

    /**
     * Get the value of lastOrderDate.
     *
     * @return date
     */
    public function getLastOrderDateFormatted()
    {
        return $this->lastOrderDate ? $this->lastOrderDate->format('d/m/Y') : "";
    }


    /**
     * Get the value of discount.
     *
     * @return float
     */
    public function getDiscount()
    {
        return $this->discount;
    }

    /**
     * Set the value of discount.
     *
     * @param float $discount
     * @return \Model\Entity\Customer
     */
    public function setDiscount($discount)
    {
        $this->discount = $discount;

        return $this;
    }

    public function getDiscountCurrency()
    {
        return \Commons\Util\StringUtils::formatMoney($this->discount);
    }

    public function getDiscountCurrencyBRL()
    {
        return \Commons\Util\StringUtils::formatMoneyBRL($this->discount);
    }

    public function getDiscountPercent()
    {
        if($this->getDiscount() > 0){
            return ($this->getDiscount() * 100)/$this->getSubtotal();
        }
        return 0;
    }


    public function getZip() {
        return $this->zip;
    }

    public function setZip($zip) {
        $this->zip = $zip;
    }


    /**
     * Set the value of id.
     *
     * @param integer $id
     * @return \Model\Entity\Customer
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * Get the value of id.
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set the value of code.
     *
     * @param string $code
     * @return \Model\Entity\Customer
     */
    public function setCode($code)
    {
        $this->code = $code;

        return $this;
    }

    /**
     * Get the value of code.
     *
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * Set the value of name.
     *
     * @param string $name
     * @return \Model\Entity\Customer
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get the value of name.
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set the value of nickname.
     *
     * @param string $nickname
     * @return \Model\Entity\Customer
     */
    public function setNickname($nickname)
    {
        $this->nickname = $nickname;

        return $this;
    }

    /**
     * Get the value of nickname.
     *
     * @return string
     */
    public function getNickname()
    {
        return $this->nickname;
    }

    /**
     * Set the value of contact.
     *
     * @param string $contact
     * @return \Model\Entity\Customer
     */
    public function setContact($contact)
    {
        $this->contact = $contact;

        return $this;
    }

    /**
     * Get the value of contact.
     *
     * @return string
     */
    public function getContact()
    {
        return $this->contact;
    }

    /**
     * Set the value of address.
     *
     * @param string $address
     * @return \Model\Entity\Customer
     */
    public function setAddress($address)
    {
        $this->address = $address;

        return $this;
    }

    /**
     * Get the value of address.
     *
     * @return string
     */
    public function getAddress()
    {
        return $this->address;
    }

    /**
     * Set the value of neighbourhood.
     *
     * @param string $neighbourhood
     * @return \Model\Entity\Customer
     */
    public function setNeighbourhood($neighbourhood)
    {
        $this->neighbourhood = $neighbourhood;

        return $this;
    }

    /**
     * Get the value of neighbourhood.
     *
     * @return string
     */
    public function getNeighbourhood()
    {
        return $this->neighbourhood;
    }

    /**
     * Set the value of state.
     *
     * @param string $state
     * @return \Model\Entity\Customer
     */
    public function setState($state)
    {
        $this->state = $state;

        return $this;
    }

    /**
     * Get the value of state.
     *
     * @return string
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Set the value of city.
     *
     * @param string $city
     * @return \Model\Entity\Customer
     */
    public function setCity($city)
    {
        $this->city = $city;

        return $this;
    }

    /**
     * Get the value of city.
     *
     * @return string
     */
    public function getCity()
    {
        return $this->city;
    }

    /**
     * Set the value of website.
     *
     * @param string $website
     * @return \Model\Entity\Customer
     */
    public function setWebsite($website)
    {
        $this->website = $website;

        return $this;
    }

    /**
     * Get the value of website.
     *
     * @return string
     */
    public function getWebsite()
    {
        return $this->website;
    }

    /**
     * Set the value of email.
     *
     * @param string $email
     * @return \Model\Entity\Customer
     */
    public function setEmail($email)
    {
        $this->email = $email;

        return $this;
    }

    /**
     * Get the value of email.
     *
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Set the value of longitude.
     *
     * @param string $longitude
     * @return \Model\Entity\Customer
     */
    public function setLongitude($longitude)
    {
        $this->longitude = $longitude;

        return $this;
    }

    /**
     * Get the value of longitude.
     *
     * @return string
     */
    public function getLongitude()
    {
        return $this->longitude;
    }

    /**
     * Set the value of latitude.
     *
     * @param string $latitude
     * @return \Model\Entity\Customer
     */
    public function setLatitude($latitude)
    {
        $this->latitude = $latitude;

        return $this;
    }

    /**
     * Get the value of latitude.
     *
     * @return string
     */
    public function getLatitude()
    {
        return $this->latitude;
    }

    /**
     * Set customer location
     * @param $lat
     * @param $lng
     */
    public function setLocation($lat, $lng){
        $this->setLatitude($lat);
        $this->setLongitude($lng);
    }

    /**
     * Set the value of blocked.
     *
     * @param string $blocked
     * @return \Model\Entity\Customer
     */
    public function setBlocked($blocked)
    {
        $this->blocked = $blocked;

        return $this;
    }

    /**
     * Get the value of blocked.
     *
     * @return string
     */
    public function getBlocked()
    {
        return $this->blocked;
    }

    public function getCompanyName() {
        return $this->companyName;
    }

    public function setCompanyName($companyName) {
        $this->companyName = $companyName;
    }

    public function getDocumentNumber() {
        return $this->documentNumber;
    }

    public function setDocumentNumber($documentNumber) {
        $this->documentNumber = $documentNumber;
    }

    public function getSecondaryDocumentNumber() {
        return $this->secondaryDocumentNumber;
    }

    public function setSecondaryDocumentNumber($secondaryDocumentNumber) {
        $this->secondaryDocumentNumber = $secondaryDocumentNumber;
    }

    public function getAddressNumber() {
        return $this->addressNumber;
    }

    public function setAddressNumber($addressNumber) {
        $this->addressNumber = $addressNumber;
    }

    public function getAddressComplement() {
        return $this->addressComplement;
    }

    public function setAddressComplement($addressComplement) {
        $this->addressComplement = $addressComplement;
    }

    public function getPhonePrimary() {
        return $this->phonePrimary;
    }

    public function setPhonePrimary($phonePrimary) {
        $this->phonePrimary = $phonePrimary;
    }

    public function getPhoneSecondary() {
        return $this->phoneSecondary;
    }

    public function setPhoneSecondary($phoneSecondary) {
        $this->phoneSecondary = $phoneSecondary;
    }

    public function getCustomerType() {
        return $this->customerType;
    }

    public function setCustomerType($customerType) {
        $this->customerType = $customerType;
    }

    /**
     * Get Order entity collection (one to many).
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getOrders()
    {
        return $this->orders;
    }

    /**
     * Add Order entity to collection (one to many).
     *
     * @param \Model\Entity\Order $order
     * @return \Model\Entity\Customer
     */
    public function addOrder(Order $order)
    {
        $this->orders[] = $order;

        return $this;
    }

    /**
     * Remove Order entity from collection (one to many).
     *
     * @param \Model\Entity\Order $order
     * @return \Model\Entity\Customer
     */
    public function removeOrder(Order $order)
    {
        $this->orders->removeElement($order);

        return $this;
    }


    /**
     * @return mixed
     */
    public function getRepresentedCompanies()
    {
        return $this->representedCompanies;
    }

    /**
     * @param mixed $representedCompanies
     */
    public function setRepresentedCompanies($representedCompanies)
    {
        $this->representedCompanies = $representedCompanies;
    }

    /**
     * @param $list
     */
    public function addRepresentedCompanies($list){
        foreach($list as $obj){
            $this->representedCompanies->add($obj);
        }
    }

    /**
     * @param $list
     */
    public function removeRepresentedCompanies($list){
        foreach($list as $obj){
            $this->representedCompanies->removeElement($obj);
        }
    }

    /**
     * @param $obj
     * @return bool
     */
    public function hasCompany($obj){

        if($obj){
            foreach($this->getRepresentedCompanies() as $entity){
                if($entity->getId() == $obj->getId()){
                    return true;
                }
            }
        }

        return false;
    }
    
    /**
     * @return mixed
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * @param mixed $user
     */
    public function setUser($user)
    {
        $this->user = $user;
    }

    public function addUserCustomer(UserCustomer $customer)
    {
        $this->userCustomers[] = $customer;

        return $this;
    }

    public function removeUserCustomer(UserCustomer $customer)
    {
        $this->userCustomers->removeElement($customer);

        return $this;
    }

    public function getUserCustomers()
    {
        return $this->userCustomers;
    }

    /**
     * Set PriceList entity (many to one).
     *
     * @param \Model\Entity\PriceList $priceList
     * @return \Model\Entity\Customer
     */
    public function setPriceList(PriceList $priceList = null)
    {
        $this->priceList = $priceList;

        return $this;
    }

    /**
     * Get PriceList entity (many to one).
     *
     * @return \Model\Entity\PriceList
     */
    public function getPriceList()
    {
        return $this->priceList;
    }

   /**
     * Set the value of ramoAtividade.
     *
     * @param integer $ramoAtividade
     * @return \Model\Entity\Customer
     */
     public function setRamoAtividade($ramoAtividade)
     {
         $this->ramoAtividade = $ramoAtividade;
 
         return $this;
     }
 
     /**
      * Get the value of ramoAtividade.
      *
      * @return integer
      */
     public function getRamoAtividade()
     {
         return $this->ramoAtividade;
     } 



     /**
     * Set the value of categoria.
     *
     * @param integer $categoria
     * @return \Model\Entity\Customer
     */
    public function setCategoria($categoria)
    {
        $this->categoria = $categoria;

        return $this;
    }

    /**
     * Get the value of categoria.
     *
     * @return integer
     */
    public function getCategoria()
    {
        return $this->categoria;
    } 

    public function __sleep()
    {
        return array('id', 'code', 'name', 'nickname', 'company_name', 'document_number', 'secondary_document_number', 'address', 'number', 'neighbourhood', 'address_complement', 'state', 'city', 'phone_primary', 'phone_secondary', 'website', 'email', 'longitude', 'latitude', 'active');
    }

    public function populateFromSync($arr){
        $this->setName($arr['nome']);

        if (isset($arr['razaoSocial']) && !empty($arr['razaoSocial']))
            $this->setCompanyName($arr['razaoSocial']);

        if (isset($arr['contato']) && !empty($arr['contato']))
            $this->setContact($arr['contato']);

        if (isset($arr['documentoNacional']) && !empty($arr['documentoNacional']))
            $this->setDocumentNumber($arr['documentoNacional']);

        if (isset($arr['documentoEstadual']) && !empty($arr['documentoEstadual']))
            $this->setSecondaryDocumentNumber($arr['documentoEstadual']);

        if (isset($arr['email']) && !empty($arr['email']))
            $this->setEmail($arr['email']);

        if (isset($arr['cep']) && !empty($arr['cep']))
            $this->setZip($arr['cep']);

        if (isset($arr['endereco']) && !empty($arr['endereco']))
            $this->setAddress($arr['endereco']);

        if (isset($arr['numero']) && !empty($arr['numero']))
            $this->setAddressNumber($arr['numero']);
        else
            $this->setAddressNumber('0');

        if (isset($arr['complemento']) && !empty($arr['complemento']))
            $this->setAddressComplement($arr['complemento']);

        if (isset($arr['bairro']) && !empty($arr['bairro']))
            $this->setNeighbourhood($arr['bairro']);

        if (isset($arr['cidade']) && !empty($arr['cidade']))
            $this->setCity($arr['cidade']);

        if (isset($arr['estado']) && !empty($arr['estado']))
            $this->setState($arr['estado']);

        if (isset($arr['tipo']) && !empty($arr['tipo']))
            $this->setCustomerType($arr['tipo']);

        if (isset($arr['telefonePrincipal']) && !empty($arr['telefonePrincipal']))
            $this->setPhonePrimary($arr['telefonePrincipal']);

        if (isset($arr['telefoneSecundario']) && !empty($arr['telefoneSecundario']))
            $this->setPhoneSecondary($arr['telefoneSecundario']);

        if (isset($arr['info']) && !empty($arr['info']))
            $this->setInfo($arr['info']);

        if(isset($arr['latitude']) && is_numeric($arr['latitude']))
            $this->setLatitude($arr['latitude']);

        if(isset($arr['longitude']) && is_numeric($arr['longitude']))
            $this->setLongitude($arr['longitude']);

        if (isset($arr['code']) && !empty($arr['code']))
            $this->setCode(trim($arr['code']));

        if (isset($arr['nickname']) && !empty($arr['nickname']))
            $this->setNickname(trim($arr['nickname']));     

        if (isset($arr['active']))
            $this->setActive($arr['active']);
        else
            $this->setActive(true);

        $this->setSync(false);
    }

    public function populateFromImport($arr){

        //if (isset($arr[0]))
        //    $this->setId(trim($arr[0]));
        if (isset($arr[1]))
            $this->setCode(trim($arr[1]));
        if (isset($arr[2]))
            $this->setName($arr[2]);
        if (isset($arr[3]))
            $this->setCompanyName($arr[3]);
        if (isset($arr[4]))
            $this->setContact($arr[4]);
        if (isset($arr[5]))
            $this->setDocumentNumber($arr[5]);
        if (isset($arr[6]))
            $this->setSecondaryDocumentNumber($arr[6]);
        if (isset($arr[7]))
            $this->setZip($arr[7]);
        if (isset($arr[8]))
            $this->setAddress($arr[8]);
        if (isset($arr[9]))
            $this->setAddressNumber($arr[9]);
        if (isset($arr[10]))
            $this->setNeighbourhood($arr[10]);
        if (isset($arr[11]))
            $this->setAddressComplement($arr[11]);
        if (isset($arr[12]))
            $this->setState($arr[12]);
        if (isset($arr[13]))
            $this->setCity($arr[13]);
        if (isset($arr[14]))
            $this->setPhonePrimary($arr[14]);
        if (isset($arr[15]))
            $this->setPhoneSecondary($arr[15]);
        if (isset($arr[16]))
            $this->setWebsite($arr[16]);
        if (isset($arr[17]))
            $this->setEmail($arr[17]);
        if (isset($arr[18]) && is_numeric($arr[18]))
            $this->setLongitude($arr[18]);
        if (isset($arr[19]) && is_numeric($arr[19]))
            $this->setLatitude($arr[19]);
        if (isset($arr[20]) && is_numeric($arr[20]))
            $this->setActive($arr[20]);
        if (isset($arr[21]))
            $this->setCustomerType($arr[21]);
        if (isset($arr[22]))
            $this->setInfo($arr[22]);
    }

    public function getArrayCopy(){

        $arr = parent::getArrayCopy();

        unset($arr['orders']);

        $arrayCompanies = array();
        if(count($this->getRepresentedCompanies()) > 0){
            foreach($this->getRepresentedCompanies() as $rc){
                $arrayCompanies[] = $rc->getId();
            }
        }
        $arr['representedCompanies'] = $arrayCompanies;

        if (isset($arr['discount']) && $arr['discount'] > 0)
            $arr['discount'] = floatval($arr['discount']);

        if (isset($arr['lastOrderDate']))
            $arr['lastOrderDate'] = (is_object($this->getLastOrderDate()) ? $this->getLastOrderDate()->format('d/m/Y H:i') : '');

        if (is_object($this->getPriceList()))
            $arr['priceList'] = $this->getPriceList()->getId();

        return $arr;
    }

    public function getAddressWithNumber(){

        $addr = $this->getAddress();
        if(!$addr){
            return false;
        }

        if($this->getAddressNumber()){
            $addr .= ', ' . $this->getAddressNumber();
        }

        return $addr;

    }

    public function getAddressFullStr(){

        $addr = $this->getAddress();
        if(!$addr){
            return false;
        }

        if($this->getAddressNumber()){
            $addr .= ', ' . $this->getAddressNumber();
        }

        if($this->getNeighbourhood()){
            $addr .= ' - ' . $this->getNeighbourhood();
        }

        if($this->getAddressComplement()){
            $addr .= ' - ' . $this->getAddressComplement();
        }

        if($this->getCity()){
            $addr .= ' - ' . $this->getCity() . ($this->getState() ? ', ' . $this->getState() : '');
        }

        if($this->getZip()){
            $addr .= ' - CEP ' . $this->getZip();
        }

        return $addr;

    }
}
