<?php

namespace Model\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Zend\Form\Annotation;

/**
 * Model\Entity\Company
 *
 * @ORM\Entity(repositoryClass="Model\Repository\CompanyRepository")
 * @ORM\Table(name="company")
 * @Annotation\Name("company")
 * @Annotation\Attributes({"class":"form-horizontal form-validate"})
 */
class Company extends AbstractEntity
{
    const LOGO_FILENAME = "./data/images/company_logo.jpg";
    
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     * @Annotation\Type("Zend\Form\Element\Hidden")
     * @Annotation\Required({"required":"true" })
     * @Annotation\Attributes({"type":"hidden"})
     * @Annotation\Options({"label":":"})
     */
    protected $id;
    
    /** 
     * @ORM\Column(name="image", type="string", nullable=true)
     * @Annotation\Exclude()
     */
    protected $image;
    
    /**
     * @Annotation\Type("Zend\Form\Element\File")
     * @Annotation\Attributes({"id":"imageFile"})
     * @Annotation\Options({"label":"Imagem:"})
     */
    protected $imageFile;
    
    /**
     * @ORM\Column(name="document_number", type="string", length=100, nullable=true)
     * @Annotation\Type("Zend\Form\Element\Text")
     * @Annotation\Required({"required":"true" })
     * @Annotation\Attributes({"type":"text", "class":"form-control mask-cnpj", "placeholder":"Obrigatório"})
     * @Annotation\Options({"label":"CNPJ:"})
     */
    protected $documentNumber;

    /**
     * @ORM\Column(name="secondary_document_number",type="string", length=100, nullable=true)
     * @Annotation\Type("Zend\Form\Element\Text")
     * @Annotation\Attributes({"type":"text", "class":"form-control", "placeholder":""})
     * @Annotation\Options({"label":"IE:"})
     */
    protected $secondaryDocumentNumber;

    /**
     * @ORM\Column(name="company_name", type="string", length=255, nullable=false)
     * @Annotation\Type("Zend\Form\Element\Text")
     * @Annotation\Required({"required":"true" })
     * @Annotation\Attributes({"type":"text", "class":"form-control", "placeholder":"Obrigatório"})
     * @Annotation\Options({"label":"Razão Social:"})
     */
    protected $companyName;
    
    /**
     * @ORM\Column(name="trade_name", type="string", length=255, nullable=false)
     * @Annotation\Type("Zend\Form\Element\Text")
     * @Annotation\Required({"required":"true" })
     * @Annotation\Attributes({"type":"text", "class":"form-control", "placeholder":"Obrigatório"})
     * @Annotation\Options({"label":"Nome Fantasia:"})
     */
    protected $tradeName;

    /**
     * @ORM\Column(name="zip", type="string", length=30, nullable=true)
     * @Annotation\Type("Zend\Form\Element\Text")
     * @Annotation\Required({"required":"true" })
     * @Annotation\Attributes({"type":"text", "class":"form-control mask-cep", "placeholder":"", "id":"zip"})
     * @Annotation\Options({"label":"CEP:"})
     */
    protected $zip;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Annotation\Type("Zend\Form\Element\Text")
     * @Annotation\Required({"required":"true" })
     * @Annotation\Attributes({"type":"text", "class":"form-control", "placeholder":"Obrigatório", "id":"address"})
     * @Annotation\Options({"label":"Logradouro:"})
     */
    protected $address;

    /**
     * @ORM\Column(name="addressNumber", type="string", length=45, nullable=true)
     * @Annotation\Type("Zend\Form\Element\Text")
     * @Annotation\Attributes({"type":"text", "class":"form-control", "id":"addressNumber"})
     * @Annotation\Options({"label":"Número:"})
     */
    protected $addressNumber;

    /**
     * @ORM\Column(type="string", length=100, nullable=true)
     * @Annotation\Type("Zend\Form\Element\Text")
     * @Annotation\Required({"required":"true" })
     * @Annotation\Attributes({"type":"text", "class":"form-control", "placeholder":"Obrigatório", "id":"neighbourhood"})
     * @Annotation\Options({"label":"Bairro:"})
     */
    protected $neighbourhood;

    /**
     * @ORM\Column(name="address_complement", type="string", length=45, nullable=true)
     * @Annotation\Type("Zend\Form\Element\Text")
     * @Annotation\Attributes({"type":"text", "class":"form-control", "id":"addressComplement"})
     * @Annotation\Options({"label":"Complemento:"})
     */
    protected $addressComplement;

    /**
     * @ORM\Column(name="`state`", type="string", length=45, nullable=true)
     * @Annotation\Type("Zend\Form\Element\Text")
     * @Annotation\Required({"required":"true" })
     * @Annotation\Attributes({"type":"text", "class":"form-control", "placeholder":"Obrigatório", "id":"state"})
     * @Annotation\Options({"label":"Estado:"})
     */
    protected $state;

    /**
     * @ORM\Column(type="string", length=45, nullable=true)
     * @Annotation\Type("Zend\Form\Element\Text")
     * @Annotation\Required({"required":"true" })
     * @Annotation\Attributes({"type":"text", "class":"form-control", "placeholder":"Obrigatório", "id":"city"})
     * @Annotation\Options({"label":"Cidade:"})
     */
    protected $city;

    /**
     * @ORM\Column(name="phone_primary",type="string", length=45, nullable=true)
     * @Annotation\Type("Zend\Form\Element\Text")
     * @Annotation\Required({"required":"true" })
     * @Annotation\Attributes({"type":"text", "class":"form-control", "placeholder":"Obrigatório"})
     * @Annotation\Options({"label":"Telefone Principal:"})
     */
    protected $phonePrimary;

    /**
     * @ORM\Column(name="phone_secondary", type="string", length=45, nullable=true)
     * @Annotation\Type("Zend\Form\Element\Text")
     * @Annotation\Attributes({"type":"text", "class":"form-control", "placeholder":""})
     * @Annotation\Options({"label":"Telefone Secundário:"})
     */
    protected $phoneSecondary;

    /**
     * @ORM\Column(type="string", length=45, nullable=true)
     * @Annotation\Type("Zend\Form\Element\Text")
     * @Annotation\Attributes({"type":"text", "class":"form-control", "placeholder":""})
     * @Annotation\Options({"label":"Website:"})
     */
    protected $website;

    /**
     * @ORM\Column(type="string", length=45, nullable=true)
     * @Annotation\Type("Zend\Form\Element\Text")
     * @Annotation\Attributes({"type":"text", "class":"form-control", "placeholder":""})
     * @Annotation\Options({"label":"E-mail:"})
     */
    protected $email;


    public function __construct()
    {
        parent::__construct();
    }
    
    public function getId() {
        return $this->id;
    }

    public function setId($id) {
        $this->id = $id;
    }

    public function getDocumentNumber() {
        return $this->documentNumber;
    }

    public function setDocumentNumber($documentNumber) {
        $this->documentNumber = $documentNumber;
    }

    public function getSecondaryDocumentNumber() {
        return $this->secondaryDocumentNumber;
    }

    public function setSecondaryDocumentNumber($secondaryDocumentNumber) {
        $this->secondaryDocumentNumber = $secondaryDocumentNumber;
    }

    public function getCompanyName() {
        return $this->companyName;
    }

    public function setCompanyName($companyName) {
        $this->companyName = $companyName;
    }

    public function getTradeName() {
        return $this->tradeName;
    }

    public function setTradeName($tradeName) {
        $this->tradeName = $tradeName;
    }

    public function getZip() {
        return $this->zip;
    }

    public function setZip($zip) {
        $this->zip = $zip;
    }

    public function getAddress() {
        return $this->address;
    }

    public function setAddress($address) {
        $this->address = $address;
    }

    public function getAddressNumber() {
        return $this->addressNumber;
    }

    public function setAddressNumber($addressNumber) {
        $this->addressNumber = $addressNumber;
    }

    public function getNeighbourhood() {
        return $this->neighbourhood;
    }

    public function setNeighbourhood($neighbourhood) {
        $this->neighbourhood = $neighbourhood;
    }

    public function getAddressComplement() {
        return $this->addressComplement;
    }

    public function setAddressComplement($addressComplement) {
        $this->addressComplement = $addressComplement;
    }

    public function getState() {
        return $this->state;
    }

    public function setState($state) {
        $this->state = $state;
    }

    public function getCity() {
        return $this->city;
    }

    public function setCity($city) {
        $this->city = $city;
    }

    public function getPhonePrimary() {
        return $this->phonePrimary;
    }

    public function setPhonePrimary($phonePrimary) {
        $this->phonePrimary = $phonePrimary;
    }

    public function getPhoneSecondary() {
        return $this->phoneSecondary;
    }

    public function setPhoneSecondary($phoneSecondary) {
        $this->phoneSecondary = $phoneSecondary;
    }

    public function getWebsite() {
        return $this->website;
    }

    public function setWebsite($website) {
        $this->website = $website;
    }

    public function getEmail() {
        return $this->email;
    }

    public function setEmail($email) {
        $this->email = $email;
    }
    
    public function getImage() {
        return $this->image;
    }

    public function setImage($image) {
        $this->image = $image;
    }

    public function getImageFile() {
        return $this->imageFile;
    }

    public function setImageFile($imageFile) {
        $this->imageFile = $imageFile;
    }
    
    public function getInlineAddress(){
        
        $addr = $this->getAddress();
        if($this->getAddressNumber()){
            $addr .= ', ' . $this->getAddressNumber();
        }
        
        if($this->getNeighbourhood()){
            $addr .= ' - ' . $this->getNeighbourhood();
        }
        
        if($this->getAddressComplement()){
            $addr .= ' - ' . $this->getAddressComplement();
        }
        
        if($this->getCity() && $this->getState()){
            $addr .= ' - ' . $this->getCity() . ', ' . $this->getState();
        }
        
        if($this->getZip()){
            $addr .= ' - ' . $this->getZip();
        }
        
        return $addr;
        
    }
    
    public function getInlinePhones(){
        $line = "Telefone: " . $this->getPhonePrimary();
        
        if($this->getPhoneSecondary()){
            $line .= ' - ' . $this->getPhoneSecondary();
        }
        return $line;
    }

}