<?php

/**
 * Auto generated by MySQL Workbench Schema Exporter.
 * Version 2.1.5-dev (doctrine2-annotation) on 2014-10-22 00:16:27.
 * Goto https://github.com/johmue/mysql-workbench-schema-exporter for more
 * information.
 */

namespace Model\Entity;

use Commons\Util\ImageUtil;
use Doctrine\ORM\Mapping as ORM;

/**
 * Model\Entity\CatalogImage
 *
 * @ORM\Entity()
 * @ORM\Table(name="catalog_image")
 * @ORM\Entity(repositoryClass="Model\Repository\CatalogImageRepository")
 * @ORM\HasLifecycleCallbacks
 */
class CatalogImage extends AbstractEntity
{
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @ORM\Column(name="width", type="integer", nullable=true)
     */
    protected $width;

    /**
     * @ORM\Column(name="height", type="integer", nullable=true)
     */
    protected $height;

    /**
     * @ORM\Column(name="`size`", type="integer", nullable=true)
     */
    protected $size;

    /**
     * @ORM\Column(name="`type`", type="string", length=100, nullable=true)
     */
    protected $type;

    /**
     * @ORM\Column(name="thumb", type="string", length=255, nullable=true)
     */
    protected $thumb;

    /**
     * @ORM\Column(name="file", type="string", length=255)
     */
    protected $file;

    /**
     * @ORM\Column(name="`order`", type="integer")
     */
    protected $order;

    /**
     * @ORM\ManyToOne(targetEntity="Model\Entity\Catalog", inversedBy="images")
     * @ORM\JoinColumn(name="id_catalog", referencedColumnName="id")
     */
    protected $catalog;

    /**
     * @ORM\PreRemove()
     */
    public function preDelete() {
        if(file_exists($this->getFilePath())){
            unlink($this->getFilePath());
        }
        if(file_exists($this->getThumbPath())){
            unlink($this->getThumbPath());
        }
    }

    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Set the value of id.
     *
     * @param integer $id
     * @return \Model\Entity\ProductImage
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * Get the value of id.
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set the value of width.
     *
     * @param integer $width
     * @return \Model\Entity\ProductImage
     */
    public function setWidth($width)
    {
        $this->width = $width;

        return $this;
    }

    /**
     * Get the value of width.
     *
     * @return integer
     */
    public function getWidth()
    {
        return $this->width;
    }

    /**
     * Set the value of height.
     *
     * @param integer $height
     * @return \Model\Entity\ProductImage
     */
    public function setHeight($height)
    {
        $this->height = $height;

        return $this;
    }

    /**
     * Get the value of height.
     *
     * @return integer
     */
    public function getHeight()
    {
        return $this->height;
    }

    /**
     * Set the value of size.
     *
     * @param integer $size
     * @return \Model\Entity\ProductImage
     */
    public function setSize($size)
    {
        $this->size = $size;

        return $this;
    }

    /**
     * Get the value of size.
     *
     * @return integer
     */
    public function getSize()
    {
        return $this->size;
    }

    /**
     * Set the value of type.
     *
     * @param string $type
     * @return \Model\Entity\ProductImage
     */
    public function setType($type)
    {
        $this->type = $type;

        return $this;
    }

    /**
     * Get the value of type.
     *
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @return mixed
     */
    public function getFile()
    {
        return $this->file;
    }

    /**
     * @param mixed $file
     */
    public function setFile($file)
    {
        $this->file = $file;
    }

    /**
     * @return mixed
     */
    public function getCatalog()
    {
        return $this->catalog;
    }

    /**
     * @return mixed
     */
    public function getOrder()
    {
        return $this->order;
    }

    /**
     * @param mixed $order
     */
    public function setOrder($order)
    {
        $this->order = $order;
    }

    /**
     * @param mixed $catalog
     */
    public function setCatalog($catalog)
    {
        $this->catalog = $catalog;
    }

    /**
     * @return mixed
     */
    public function getThumb()
    {
        return $this->thumb;
    }

    /**
     * @param mixed $thumb
     */
    public function setThumb($thumb)
    {
        $this->thumb = $thumb;
    }

    /**
     * Set file resource
     * @param $file
     * @param null $catalog
     * @throws \Exception
     */
    public function setFileResource($file, $catalog = null){
        if(!$catalog && !$this->getCatalog()){
            throw new \Exception("Invalid catalog");
        }
        $selectedCatalog = $catalog ? $catalog : $this->getCatalog();
        $extension = pathinfo($file['name'], PATHINFO_EXTENSION);
        $hash = md5(uniqid(rand(), true));
        $filename = 'img_' . $hash  . '.' . $extension;
        $filenameThumb = 'img_' . $hash  . '_thumb.' . $extension;
        move_uploaded_file($file['tmp_name'], \Model\Entity\Catalog::getPathForFile($filename, $selectedCatalog->getId()));
        $this->setFile($filename);
        $this->setThumb($filenameThumb);
        ImageUtil::resize($this->getFilePath(), $this->getFilePath(), $extension, 600, 900, 80);

        // Generate thumb
        ImageUtil::resize($this->getFilePath(), $this->getThumbPath(), $extension, 160, 240, 50);
    }

    /**
     * Get path for file and id
     * @param $file
     * @param $id
     * @return string
     */
    public function getFilePath(){
        return Catalog::getPathForFile($this->getFile(), $this->getCatalog()->getId());
    }

    /**
     * Get path for thumb and id
     * @param $file
     * @param $id
     * @return string
     */
    public function getThumbPath(){
        return Catalog::getPathForFile($this->getThumb(), $this->getCatalog()->getId());
    }

}